/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.GTNHLibConfig;
import com.gtnewhorizon.gtnhlib.block.BlockTestTintMul;
import com.gtnewhorizon.gtnhlib.blockstate.command.BlockStateCommand;
import com.gtnewhorizon.gtnhlib.blockstate.init.BlockPropertyInit;
import com.gtnewhorizon.gtnhlib.brigadier.BrigadierApi;
import com.gtnewhorizon.gtnhlib.chat.ChatComponentCustomRegistry;
import com.gtnewhorizon.gtnhlib.chat.customcomponents.ChatComponentEnergy;
import com.gtnewhorizon.gtnhlib.chat.customcomponents.ChatComponentFluid;
import com.gtnewhorizon.gtnhlib.chat.customcomponents.ChatComponentNumber;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizon.gtnhlib.eventbus.AutoEventBus;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.eventbus.Phase;
import com.gtnewhorizon.gtnhlib.keybind.SyncedKeybind;
import com.gtnewhorizon.gtnhlib.network.NetworkHandler;
import com.gtnewhorizon.gtnhlib.network.PacketMessageAboveHotbar;
import com.gtnewhorizon.gtnhlib.network.PacketViewDistance;
import com.gtnewhorizon.gtnhlib.test.block.BlockTest;
import com.gtnewhorizon.gtnhlib.test.block.BlockTestTint;
import com.gtnewhorizon.gtnhlib.test.item.TestItem;
import com.gtnewhorizon.gtnhlib.util.numberformatting.NumberFormatConfig;
import com.gtnewhorizon.gtnhlib.util.numberformatting.NumberFormatUtil;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;

@EventBusSubscriber
public class CommonProxy {
    public void construct(FMLConstructionEvent event) {
        AutoEventBus.executePhase(Phase.CONSTRUCT);
    }

    public void preInit(FMLPreInitializationEvent event) {
        AutoEventBus.executePhase(Phase.PRE);
        GTNHLib.info("GTNHLib version 0.9.14-pre loaded.");
        if (GTNHLibConfig.enableTestBlocks) {
            GameRegistry.registerBlock((Block)new BlockTest(), (String)"model_test");
            GameRegistry.registerBlock((Block)new BlockTestTint(), (String)"model_test_tint");
            GameRegistry.registerBlock((Block)new BlockTestTintMul(), (String)"model_test_tint_mul");
        }
        if (GTNHLibConfig.enableTestItems) {
            GameRegistry.registerItem((Item)TestItem.INSTANCE, (String)"testitem");
        }
        BlockPropertyInit.init();
        ChatComponentCustomRegistry.register(ChatComponentNumber::new);
        ChatComponentCustomRegistry.register(ChatComponentFluid::new);
        ChatComponentCustomRegistry.register(ChatComponentEnergy::new);
        try {
            ConfigurationManager.registerConfig(NumberFormatConfig.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        NumberFormatUtil.postConfiguration();
    }

    public void init(FMLInitializationEvent event) {
        AutoEventBus.executePhase(Phase.INIT);
        NetworkHandler.init();
        ConfigurationManager.onInit();
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            SyncedKeybind.createConfigurable("gtnhlib.test_keybind", "debug", 0).registerGlobalListener((p, l, keyDown) -> GTNHLib.LOG.info("GTNHLib test keybind down: {}", new Object[]{keyDown}));
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        BrigadierApi.init();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BlockStateCommand());
    }

    public void serverStarted(FMLServerStartedEvent event) {
    }

    public void serverStopping(FMLServerStoppingEvent event) {
        BrigadierApi.clear();
    }

    public void serverStopped(FMLServerStoppedEvent event) {
    }

    public void addDebugToChat(String message) {
    }

    public void addDebugToChat(IChatComponent componentText) {
    }

    public void addInfoToChat(String message) {
    }

    public void addInfoToChat(IChatComponent componentText) {
    }

    public void addWarnToChat(String message) {
    }

    public void addWarnToChat(IChatComponent componentText) {
    }

    public void addErrorToChat(String message) {
    }

    public void addErrorToChat(IChatComponent componentText) {
    }

    public void addMessageToChat(IChatComponent componentText) {
    }

    public void printMessageAboveHotbar(String message, int displayDuration, boolean drawShadow, boolean shouldFade) {
    }

    public void sendMessageAboveHotbar(EntityPlayerMP player, IChatComponent chatComponent, int displayDuration, boolean drawShadow, boolean shouldFade) {
        if (player instanceof FakePlayer) {
            return;
        }
        NetworkHandler.instance.sendTo((IMessage)new PacketMessageAboveHotbar(chatComponent, displayDuration, drawShadow, shouldFade), player);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        int distance = MinecraftServer.func_71276_C().func_71203_ab().func_72395_o();
        NetworkHandler.instance.sendTo((IMessage)new PacketViewDistance(distance), playerMP);
    }
}

