/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.util.IOConsumer;
import xyz.wagyourtail.jvmdg.util.IOFunction;
import xyz.wagyourtail.jvmdg.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AsyncUtils {
    private static final ForkJoinPool pool = new ForkJoinPool(Math.min(Math.max(1, Runtime.getRuntime().availableProcessors() - 1), Short.MAX_VALUE), ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);

    @SafeVarargs
    public static <T> Future<List<T>> waitForFutures(Future<T> ... futures) {
        for (Future<T> future : futures) {
            if (future != null) continue;
            throw new NullPointerException();
        }
        return AsyncUtils.waitForFutures(new ArrayDeque<Future<T>>(Arrays.asList(futures)));
    }

    public static <T> Future<List<T>> waitForFutures(final Queue<Future<T>> futures) {
        final AtomicReference result = new AtomicReference();
        return new Future<List<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return result.get() != null;
            }

            @Override
            public List<T> get() throws InterruptedException, ExecutionException {
                try {
                    return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public List<T> get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                ArrayList list = new ArrayList();
                long remainingMs = unit.toMillis(timeout);
                while (!futures.isEmpty()) {
                    Future future = (Future)futures.poll();
                    long start = System.currentTimeMillis();
                    list.add(future.get(remainingMs, unit));
                    remainingMs -= System.currentTimeMillis() - start;
                }
                result.set(list);
                return list;
            }
        };
    }

    public static <T> Future<Void> forEachAsync(Collection<T> paths, final IOConsumer<T> fileVisitor) {
        ArrayDeque<Future<T>> futures = new ArrayDeque<Future<T>>();
        for (final T path : paths) {
            futures.add(pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        fileVisitor.accept(path);
                    }
                    catch (IOException e) {
                        Utils.sneakyThrow(e);
                    }
                }
            }, (Object)null));
        }
        return AsyncUtils.waitForFutures(futures);
    }

    public static Future<Void> runAll(Runnable ... runnables) {
        ArrayDeque futures = new ArrayDeque();
        for (Runnable runnable : runnables) {
            futures.add(pool.submit(runnable, (Object)null));
        }
        return AsyncUtils.waitForFutures(futures);
    }

    public static Future<Void> visitPathsAsync(final Path start, final IOFunction<Path, Boolean> folderVisitor, final IOConsumer<Path> fileVisitor) throws IOException {
        final ArrayDeque futures = new ArrayDeque();
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(final Path dir, BasicFileAttributes attrs) throws IOException {
                if (folderVisitor != null && !((Boolean)folderVisitor.apply(dir)).booleanValue()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (dir.equals(start)) {
                    return FileVisitResult.CONTINUE;
                }
                futures.add(pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AsyncUtils.visitPathsAsync(dir, folderVisitor, fileVisitor).get();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException | ExecutionException e) {
                            Utils.sneakyThrow(e);
                        }
                    }
                }, (Object)null));
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(final Path file, BasicFileAttributes attrs) {
                futures.add(pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            fileVisitor.accept(file);
                        }
                        catch (IOException e) {
                            Utils.sneakyThrow(e);
                        }
                    }
                }, (Object)null));
                return FileVisitResult.CONTINUE;
            }
        });
        return AsyncUtils.waitForFutures(futures);
    }
}

