/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.providers;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_CharSequence;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_Class;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_I_ConstantBootstraps;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_I_MethodHandles$Lookup;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_Math;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_StrictMath;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_N_C_ServerSocketChannel;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_N_C_SocketChannel;
import xyz.wagyourtail.jvmdg.j15.stub.java_base.J_U_NoSuchElementException;
import xyz.wagyourtail.jvmdg.util.Function;
import xyz.wagyourtail.jvmdg.version.VersionProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Java15Downgrader
extends VersionProvider {
    public Java15Downgrader() {
        super(59, 58, 0);
    }

    public void init() {
        this.stub(J_L_CharSequence.class);
        this.stub(J_L_Class.class);
        this.stub(J_L_Math.class);
        this.stub(J_L_StrictMath.class);
        this.stub(J_L_String.class);
        this.stub(J_L_I_ConstantBootstraps.class);
        this.stub(J_L_I_MethodHandles$Lookup.class);
        this.stub(J_L_I_MethodHandles$Lookup.ClassOption.class);
        this.stub(J_N_C_ServerSocketChannel.class);
        this.stub(J_N_C_SocketChannel.class);
        this.stub(J_U_NoSuchElementException.class);
    }

    public ClassNode otherTransforms(ClassNode clazz, Set<ClassNode> extra, Function<String, ClassNode> getReadOnly) throws IOException {
        super.otherTransforms(clazz, extra, getReadOnly);
        this.fixHandleAccessNests(clazz, getReadOnly);
        return clazz;
    }

    public void fixHandleAccessNests(ClassNode clazz, Function<String, ClassNode> getReadOnly) {
        if (clazz.nestHostClass == null) {
            this.fixNestsForParent(clazz, getReadOnly);
        } else {
            this.fixNestsForChild(clazz, getReadOnly);
        }
    }

    public Map<String, Object> determinePrivateFieldsAndMethodsReadByNestMembers(ClassNode clazz, Collection<ClassNode> nestMembers) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (ClassNode nestMember : nestMembers) {
            fields.putAll(this.determinePrivateFieldsAndMethodsReadByNestMember(clazz, nestMember));
        }
        return fields;
    }

    public Map<String, Object> determinePrivateFieldsAndMethodsReadByNestMember(ClassNode clazz, ClassNode nestMember) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (nestMember.methods == null) {
            return fields;
        }
        HashMap<String, Object> nestMemberPrivates = new HashMap<String, Object>();
        for (FieldNode field : clazz.fields) {
            if ((field.access & 2) == 0) continue;
            nestMemberPrivates.put(field.name, field);
        }
        for (MethodNode method : clazz.methods) {
            if ((method.access & 2) == 0) continue;
            nestMemberPrivates.put(method.name + method.desc, method);
        }
        for (MethodNode method : nestMember.methods) {
            if (method.instructions == null) continue;
            for (Object insn : method.instructions) {
                if (!(insn instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode methodInsn = (InvokeDynamicInsnNode)insn;
                if (methodInsn.bsm.getOwner().equals(clazz.name)) {
                    if (!nestMemberPrivates.containsKey(methodInsn.name + methodInsn.desc)) continue;
                    fields.put(methodInsn.name + methodInsn.desc, nestMemberPrivates.get(methodInsn.name + methodInsn.desc));
                    continue;
                }
                for (Object arg : methodInsn.bsmArgs) {
                    Handle handle;
                    if (!(arg instanceof Handle) || !(handle = (Handle)arg).getOwner().equals(clazz.name)) continue;
                    if (nestMemberPrivates.containsKey(handle.getName() + handle.getDesc())) {
                        fields.put(handle.getName() + handle.getDesc(), nestMemberPrivates.get(handle.getName() + handle.getDesc()));
                        continue;
                    }
                    if (!nestMemberPrivates.containsKey(handle.getName())) continue;
                    fields.put(handle.getName(), nestMemberPrivates.get(handle.getName()));
                }
            }
        }
        return fields;
    }

    public void useAccessors(ClassNode clazz, Map<String, ClassNode> nestMembers) {
        if (clazz.methods == null) {
            return;
        }
        for (MethodNode method : clazz.methods) {
            if (method.instructions == null) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode insn = method.instructions.get(i);
                if (!(insn instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode methodInsn = (InvokeDynamicInsnNode)insn;
                if (nestMembers.containsKey(methodInsn.bsm.getOwner())) {
                    ClassNode target = nestMembers.get(methodInsn.bsm.getOwner());
                    block18: for (MethodNode methodNode : target.methods) {
                        if (!methodNode.name.equals(methodInsn.name) || !methodNode.desc.equals(methodInsn.desc)) continue;
                        if ((methodNode.access & 2) == 0) break;
                        switch (methodInsn.bsm.getTag()) {
                            case 6: {
                                methodInsn.bsm = new Handle(6, methodInsn.bsm.getOwner(), "jvmdowngrader$handleNest$" + methodInsn.bsm.getOwner().replace("/", "_") + "$" + methodInsn.bsm.getName(), methodInsn.bsm.getDesc(), false);
                                break block18;
                            }
                            case 5: {
                                methodInsn.bsm = new Handle(5, methodInsn.bsm.getOwner(), "jvmdowngrader$handleNest$" + methodInsn.bsm.getOwner().replace("/", "_") + "$" + methodInsn.bsm.getName(), methodInsn.bsm.getDesc(), false);
                                break block18;
                            }
                            case 7: {
                                methodInsn.bsm = new Handle(7, methodInsn.bsm.getOwner(), "jvmdowngrader$handleNest$" + methodInsn.bsm.getOwner().replace("/", "_") + "$" + methodInsn.bsm.getName(), methodInsn.bsm.getDesc(), false);
                                break block18;
                            }
                            default: {
                                throw new RuntimeException("Unexpected opcode: " + insn.getOpcode());
                            }
                        }
                    }
                }
                block19: for (int j = 0; j < methodInsn.bsmArgs.length; ++j) {
                    Handle handle;
                    Object arg = methodInsn.bsmArgs[j];
                    if (!(arg instanceof Handle) || !nestMembers.containsKey((handle = (Handle)arg).getOwner())) continue;
                    ClassNode target = nestMembers.get(handle.getOwner());
                    if (!handle.getOwner().equals(target.name) || handle.getName().equals("<init>")) continue;
                    block20: for (MethodNode methodNode : target.methods) {
                        if (!methodNode.name.equals(handle.getName()) || !methodNode.desc.equals(handle.getDesc())) continue;
                        if ((methodNode.access & 2) == 0) break;
                        switch (handle.getTag()) {
                            case 6: {
                                methodInsn.bsmArgs[j] = new Handle(6, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$" + handle.getName(), handle.getDesc(), false);
                                break block20;
                            }
                            case 5: {
                                methodInsn.bsmArgs[j] = new Handle(5, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$" + handle.getName(), handle.getDesc(), false);
                                break block20;
                            }
                            case 7: {
                                methodInsn.bsmArgs[j] = new Handle(7, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$" + handle.getName(), handle.getDesc(), false);
                                break block20;
                            }
                            default: {
                                throw new RuntimeException("Unexpected opcode: " + insn.getOpcode());
                            }
                        }
                    }
                    for (FieldNode fieldNode : target.fields) {
                        if (!fieldNode.name.equals(handle.getName()) || !fieldNode.desc.equals(handle.getDesc())) continue;
                        if ((fieldNode.access & 2) == 0) continue block19;
                        switch (handle.getTag()) {
                            case 1: {
                                methodInsn.bsmArgs[j] = new Handle(5, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$get$" + handle.getName(), handle.getDesc(), false);
                                continue block19;
                            }
                            case 3: {
                                methodInsn.bsmArgs[j] = new Handle(5, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$set$" + handle.getName(), handle.getDesc(), false);
                                continue block19;
                            }
                            case 2: {
                                methodInsn.bsmArgs[j] = new Handle(6, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$get$" + handle.getName(), handle.getDesc(), false);
                                continue block19;
                            }
                            case 4: {
                                methodInsn.bsmArgs[j] = new Handle(6, handle.getOwner(), "jvmdowngrader$handleNest$" + handle.getOwner().replace("/", "_") + "$set$" + handle.getName(), handle.getDesc(), false);
                                continue block19;
                            }
                            default: {
                                throw new RuntimeException("Unexpected opcode: " + insn.getOpcode());
                            }
                        }
                    }
                }
            }
        }
    }

    private void createAccessors(ClassNode clazz, Map<String, Object> fields) {
        for (String field : fields.keySet()) {
            if (field.contains("(")) {
                String name = field.substring(0, field.indexOf("("));
                String desc = field.substring(field.indexOf("("));
                Type methodType = Type.getMethodType((String)desc);
                Type[] args = methodType.getArgumentTypes();
                Type returnType = methodType.getReturnType();
                if (!(fields.get(field) instanceof MethodNode)) {
                    throw new RuntimeException("not method?");
                }
                MethodNode methodNode = (MethodNode)fields.get(field);
                boolean isStatic = (methodNode.access & 8) != 0;
                if (name.equals("<init>")) {
                    if (fields.get(field) instanceof MethodNode) {
                        methodNode = (MethodNode)fields.get(field);
                        methodNode.access &= 0xFFFFFFFD;
                        continue;
                    }
                    throw new RuntimeException("not method?");
                }
                MethodVisitor mv = clazz.visitMethod((isStatic ? 8 : 0) | 1 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "jvmdowngrader$handleNest$" + clazz.name.replace("/", "_") + "$" + name, desc, null, null);
                mv.visitCode();
                if (!isStatic) {
                    mv.visitVarInsn(25, 0);
                }
                int index = isStatic ? 0 : 1;
                for (Type arg : args) {
                    mv.visitVarInsn(arg.getOpcode(21), index);
                    index += arg.getSize();
                }
                mv.visitMethodInsn(isStatic ? 184 : 183, clazz.name, name, desc, false);
                if (returnType == Type.VOID_TYPE) {
                    mv.visitInsn(177);
                } else {
                    mv.visitInsn(returnType.getOpcode(172));
                }
                mv.visitEnd();
                continue;
            }
            String desc = ((FieldNode)fields.get((Object)field)).desc;
            Type fieldType = Type.getType((String)desc);
            if (!(fields.get(field) instanceof FieldNode)) {
                throw new RuntimeException("not field?");
            }
            FieldNode fieldNode = (FieldNode)fields.get(field);
            boolean isStatic = (fieldNode.access & 8) != 0;
            MethodVisitor mv = clazz.visitMethod((isStatic ? 8 : 0) | 1 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "jvmdowngrader$handleNest$" + clazz.name.replace("/", "_") + "$get$" + field, "()" + desc, null, null);
            mv.visitCode();
            if (!isStatic) {
                mv.visitVarInsn(25, 0);
            }
            mv.visitFieldInsn(isStatic ? 178 : 180, clazz.name, field, desc);
            mv.visitInsn(fieldType.getOpcode(172));
            mv.visitEnd();
            mv = clazz.visitMethod((isStatic ? 8 : 0) | 1 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "jvmdowngrader$handleNest$" + clazz.name.replace("/", "_") + "$set$" + field, "(" + desc + ")V", null, null);
            mv.visitCode();
            if (!isStatic) {
                mv.visitVarInsn(25, 0);
            }
            mv.visitVarInsn(fieldType.getOpcode(21), isStatic ? 0 : 1);
            mv.visitFieldInsn(isStatic ? 179 : 181, clazz.name, field, desc);
            mv.visitInsn(177);
            mv.visitEnd();
        }
    }

    public void fixNestsForParent(ClassNode clazz, Function<String, ClassNode> getReadOnly) {
        if (clazz.nestMembers == null) {
            return;
        }
        HashMap<String, ClassNode> nestMembers = new HashMap<String, ClassNode>();
        for (String member : clazz.nestMembers) {
            ClassNode node = getReadOnly.apply(member);
            if (node == null) continue;
            nestMembers.put(node.name, node);
        }
        this.createAccessors(clazz, this.determinePrivateFieldsAndMethodsReadByNestMembers(clazz, nestMembers.values()));
        this.useAccessors(clazz, nestMembers);
    }

    public void fixNestsForChild(ClassNode clazz, Function<String, ClassNode> getReadOnly) {
        if (clazz.nestHostClass == null) {
            return;
        }
        HashMap<String, ClassNode> nestMembers = new HashMap<String, ClassNode>();
        ClassNode nestHost = getReadOnly.apply(clazz.nestHostClass);
        if (nestHost == null) {
            throw new RuntimeException("nest host not found?");
        }
        for (String member : nestHost.nestMembers) {
            ClassNode node = getReadOnly.apply(member);
            if (node == null) continue;
            nestMembers.put(node.name, node);
        }
        nestMembers.put(nestHost.name, nestHost);
        nestMembers.remove(clazz.name);
        this.createAccessors(clazz, this.determinePrivateFieldsAndMethodsReadByNestMembers(clazz, nestMembers.values()));
        this.useAccessors(clazz, nestMembers);
    }
}

