/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_S_Stream {
    @Stub
    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<T> predicate) {
        return new TakeWhileStream(stream.iterator(), predicate).stream();
    }

    @Stub
    public static <T> Stream<T> dropWhile(Stream<T> stream, Predicate<T> predicate) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return Stream.empty();
        }
        Object next = iterator.next();
        if (!predicate.test(next)) {
            next = iterator.next();
        } else {
            while (iterator.hasNext() && predicate.test(next = iterator.next())) {
            }
        }
        return Stream.concat(Stream.of(next), StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    @Stub(ref=@Ref(value="Ljava/util/stream/Stream;"))
    public static <T> Stream<T> iterate(T seed, Predicate<T> hasNext, UnaryOperator<T> next) {
        return new StreamIterator<T>(seed, hasNext, next).stream();
    }

    @Stub(ref=@Ref(value="Ljava/util/stream/Stream;"))
    public static <T> Stream<T> ofNullable(T t) {
        return t == null ? Stream.empty() : Stream.of(t);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class StreamIterator<T>
    implements Iterator<T> {
        private final Predicate<T> hasNext;
        private final UnaryOperator<T> computeNext;
        private T prev;

        public StreamIterator(T seed, Predicate<T> hasNext, UnaryOperator<T> computeNext) {
            this.prev = seed;
            this.hasNext = hasNext;
            this.computeNext = computeNext;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext.test(this.prev);
        }

        @Override
        public T next() {
            T next = this.prev;
            this.prev = this.computeNext.apply(this.prev);
            return next;
        }

        public Stream<T> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class TakeWhileStream<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private final Predicate<T> predicate;
        private T next;
        private boolean hasNext;

        public TakeWhileStream(Iterator<T> iterator, Predicate<T> predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            T prev = this.next;
            this.hasNext = this.iterator.hasNext() && this.predicate.test(this.next = this.iterator.next());
            return prev;
        }

        public Stream<T> stream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }
}

