/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_S_LongStream {
    @Stub
    public static LongStream takeWhile(LongStream stream, LongPredicate predicate) {
        return new TakeWhileStream(stream.iterator(), predicate).stream();
    }

    @Stub
    public static LongStream dropWhile(LongStream stream, LongPredicate predicate) {
        PrimitiveIterator.OfLong iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return LongStream.empty();
        }
        long next = iterator.nextLong();
        if (!predicate.test(next)) {
            next = iterator.nextLong();
        } else {
            while (iterator.hasNext() && predicate.test(next = iterator.nextLong())) {
            }
        }
        return LongStream.concat(LongStream.of(next), StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    @Stub(ref=@Ref(value="Ljava/util/stream/LongStream;"))
    public static LongStream iterate(long seed, LongPredicate hasNext, LongUnaryOperator next) {
        return new LongIterator(seed, hasNext, next).stream();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class LongIterator
    implements PrimitiveIterator.OfLong {
        private final LongPredicate hasNext;
        private final LongUnaryOperator computeNext;
        private long prev;

        public LongIterator(long seed, LongPredicate hasNext, LongUnaryOperator computeNext) {
            this.prev = seed;
            this.hasNext = hasNext;
            this.computeNext = computeNext;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext.test(this.prev);
        }

        @Override
        public long nextLong() {
            long next = this.prev;
            this.prev = this.computeNext.applyAsLong(this.prev);
            return next;
        }

        public LongStream stream() {
            return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class TakeWhileStream
    implements PrimitiveIterator.OfLong {
        private final PrimitiveIterator.OfLong iterator;
        private final LongPredicate predicate;
        private long next;
        private boolean hasNext;

        public TakeWhileStream(PrimitiveIterator.OfLong iterator, LongPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
            this.nextLong();
        }

        @Override
        public long nextLong() {
            long prev = this.next;
            this.hasNext = this.iterator.hasNext() && this.predicate.test(this.next = this.iterator.nextLong());
            return prev;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public LongStream stream() {
            return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(this, 16), false);
        }
    }
}

