/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_N_Authenticator {
    private static final MethodHandles.Lookup IMPL_LOOKUP = Utils.getImplLookup();
    private static final MethodHandle getTheAuthenticator;
    private static final MethodHandle setRequestingHost;
    private static final MethodHandle setRequestingSite;
    private static final MethodHandle setRequestingPort;
    private static final MethodHandle setRequestingProtocol;
    private static final MethodHandle setRequestingPrompt;
    private static final MethodHandle setRequestingScheme;
    private static final MethodHandle setRequestingURL;
    private static final MethodHandle setRequestingAuthType;
    private static final MethodHandle getPasswordAuthentication;

    @Stub(ref=@Ref(value="Ljava/net/Authenticator;"))
    public static Authenticator getDefault() throws Throwable {
        return getTheAuthenticator.invokeExact();
    }

    @Stub(ref=@Ref(value="Ljava/net/Authenticator;"))
    public static PasswordAuthentication requestPasswordAuthentication(Authenticator authenticator, String host, InetAddress addr, int port, String protocol, String prompt, String scheme, URL url, Authenticator.RequestorType reqType) throws Throwable {
        if (authenticator == null) {
            return Authenticator.requestPasswordAuthentication(host, addr, port, protocol, prompt, scheme, url, reqType);
        }
        return J_N_Authenticator.requestPasswordAuthenticationInstance(authenticator, host, addr, port, protocol, prompt, scheme, url, reqType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stub
    public static PasswordAuthentication requestPasswordAuthenticationInstance(Authenticator authenticator, String host, InetAddress addr, int port, String protocol, String prompt, String scheme, URL url, Authenticator.RequestorType reqType) throws Throwable {
        Authenticator authenticator2 = authenticator;
        synchronized (authenticator2) {
            setRequestingHost.invokeExact(authenticator, host);
            setRequestingSite.invokeExact(authenticator, addr);
            setRequestingPort.invokeExact(authenticator, port);
            setRequestingProtocol.invokeExact(authenticator, protocol);
            setRequestingPrompt.invokeExact(authenticator, prompt);
            setRequestingScheme.invokeExact(authenticator, scheme);
            setRequestingURL.invokeExact(authenticator, url);
            setRequestingAuthType.invokeExact(authenticator, reqType);
            return getPasswordAuthentication.invokeExact(authenticator);
        }
    }

    static {
        try {
            getTheAuthenticator = IMPL_LOOKUP.findStaticGetter(Authenticator.class, "theAuthenticator", Authenticator.class);
            setRequestingHost = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingHost", String.class);
            setRequestingSite = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingSite", InetAddress.class);
            setRequestingPort = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingPort", Integer.TYPE);
            setRequestingProtocol = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingProtocol", String.class);
            setRequestingPrompt = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingPrompt", String.class);
            setRequestingScheme = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingScheme", String.class);
            setRequestingURL = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingURL", URL.class);
            setRequestingAuthType = IMPL_LOOKUP.findSetter(Authenticator.class, "requestingAuthType", Authenticator.RequestorType.class);
            getPasswordAuthentication = IMPL_LOOKUP.findVirtual(Authenticator.class, "getPasswordAuthentication", MethodType.methodType(PasswordAuthentication.class));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

