/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_M_BigDecimal {
    @Stub
    public static BigDecimal sqrt(BigDecimal x, MathContext mc) {
        int signum = x.signum();
        if (signum == 1) {
            BigDecimal result;
            int targetPrecision;
            int preferredScale = x.scale() / 2;
            BigDecimal zeroWithFinalPreferredScale = BigDecimal.valueOf(0L, preferredScale);
            BigDecimal stripped = x.stripTrailingZeros();
            int strippedScale = stripped.scale();
            if (BigInteger.ONE.equals(x.unscaledValue()) && strippedScale % 2 == 0) {
                BigDecimal result2 = BigDecimal.valueOf(1L, strippedScale / 2);
                if (result2.scale() != preferredScale) {
                    result2 = result2.add(zeroWithFinalPreferredScale, mc);
                }
                return result2;
            }
            int scale = stripped.scale() - stripped.precision() + 1;
            int scaleAdjust = scale % 2 == 0 ? scale : scale - 1;
            BigDecimal working = stripped.scaleByPowerOfTen(scaleAdjust);
            assert (BigDecimal.valueOf(1L, 1).compareTo(working) <= 0 && working.compareTo(BigDecimal.TEN) < 0);
            BigDecimal guess = BigDecimal.valueOf(Math.sqrt(working.doubleValue()));
            int guessPrecision = 15;
            int originalPrecision = mc.getPrecision();
            if (originalPrecision == 0) {
                targetPrecision = stripped.precision() / 2 + 1;
            } else {
                switch (mc.getRoundingMode()) {
                    case HALF_UP: 
                    case HALF_DOWN: 
                    case HALF_EVEN: {
                        targetPrecision = 2 * originalPrecision;
                        if (targetPrecision >= 0) break;
                        targetPrecision = 0x7FFFFFFD;
                        break;
                    }
                    default: {
                        targetPrecision = originalPrecision;
                    }
                }
            }
            BigDecimal approx = guess;
            int workingPrecision = working.precision();
            do {
                int tmpPrecision = Math.max(Math.max(guessPrecision, targetPrecision + 2), workingPrecision);
                MathContext mcTmp = new MathContext(tmpPrecision, RoundingMode.HALF_EVEN);
                approx = BigDecimal.valueOf(5L, 1).multiply(approx.add(working.divide(approx, mcTmp), mcTmp));
            } while ((guessPrecision *= 2) < targetPrecision + 2);
            RoundingMode targetRm = mc.getRoundingMode();
            if (targetRm == RoundingMode.UNNECESSARY || originalPrecision == 0) {
                RoundingMode tmpRm = targetRm == RoundingMode.UNNECESSARY ? RoundingMode.DOWN : targetRm;
                MathContext mcTmp = new MathContext(targetPrecision, tmpRm);
                result = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mcTmp);
                if (x.subtract(result.multiply(result)).compareTo(BigDecimal.ZERO) != 0) {
                    throw new ArithmeticException("Computed square root not exact.");
                }
            } else {
                result = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mc);
                int i = result.multiply(result).compareTo(x);
                switch (targetRm) {
                    case DOWN: 
                    case FLOOR: {
                        if (i <= 0) break;
                        BigDecimal ulp = result.ulp();
                        if (approx.compareTo(BigDecimal.ONE) == 0) {
                            ulp = ulp.multiply(BigDecimal.valueOf(1L, 1));
                        }
                        result = result.subtract(ulp);
                        break;
                    }
                    case UP: 
                    case CEILING: {
                        if (i >= 0) break;
                        result = result.add(result.ulp());
                        break;
                    }
                }
            }
            if (result.scale() != preferredScale) {
                result = result.stripTrailingZeros().add(zeroWithFinalPreferredScale, new MathContext(originalPrecision, RoundingMode.UNNECESSARY));
            }
            return result;
        }
        switch (signum) {
            case -1: {
                throw new ArithmeticException("Attempted square root of negative BigDecimal");
            }
            case 0: {
                BigDecimal result = BigDecimal.valueOf(0L, x.scale() / 2);
                return result;
            }
        }
        throw new AssertionError((Object)"Bad value from signum");
    }
}

