/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Modify;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Thread {
    private static final ThreadLocal<Object> old = new ThreadLocal();
    private static final MethodHandles.Lookup impl_lookup = Utils.getImplLookup();

    @Stub(ref=@Ref(value="Ljava/lang/Thread;"))
    public static void onSpinWait() {
        Thread.yield();
    }

    @Modify(ref=@Ref(value="java/lang/Thread", member="<init>", desc="(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;JZ)V"))
    public static void init(MethodNode mnode, int i) {
        MethodInsnNode node = (MethodInsnNode)mnode.instructions.get(i);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getType(J_L_Thread.class).getInternalName(), "preInit", "(Z)V", false));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Thread", "<init>", "(Ljava/lang/ThreadGroup;Ljava/lang/Runnable;Ljava/lang/String;J)V", false));
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getType(J_L_Thread.class).getInternalName(), "postInit", "()V", false));
        mnode.instructions.insert((AbstractInsnNode)node, list);
        mnode.instructions.remove((AbstractInsnNode)node);
    }

    public static void preInit(boolean inheritThreadLocals) {
        if (!inheritThreadLocals) {
            Thread current = Thread.currentThread();
            try {
                Class<?> map = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                MethodHandle setter = impl_lookup.findSetter(Thread.class, "inheritableThreadLocals", map);
                MethodHandle getter = impl_lookup.findGetter(Thread.class, "inheritableThreadLocals", map);
                old.set(getter.invoke(current));
                setter.invoke(current, null);
            }
            catch (Throwable e) {
                throw new Error(e);
            }
        } else {
            old.remove();
        }
    }

    public static void postInit() {
        Object o = old.get();
        if (o != null) {
            Thread current = Thread.currentThread();
            try {
                Class<?> map = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                MethodHandle setter = impl_lookup.findSetter(Thread.class, "inheritableThreadLocals", map);
                setter.invoke(current, o);
            }
            catch (Throwable e) {
                throw new Error(e);
            }
        }
    }
}

