/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.j9.intl.LoggerFinderImpl;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Class;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Module;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_System {
    @Stub(ref=@Ref(value="Ljava/lang/System;"))
    public static Logger getLogger(String name) throws ClassNotFoundException {
        Class<?> caller = Utils.getCaller(MethodHandles.lookup());
        return LoggerFinder.getLoggerFinder().getLogger(name, J_L_Class.getModule(caller));
    }

    @Stub(ref=@Ref(value="Ljava/lang/System;"))
    public static Logger getLogger(String name, ResourceBundle bundle) throws ClassNotFoundException {
        Objects.requireNonNull(bundle);
        Class<?> caller = Utils.getCaller(MethodHandles.lookup());
        return LoggerFinder.getLoggerFinder().getLocalizedLogger(name, bundle, J_L_Class.getModule(caller));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/System$LoggerFinder")
    public static abstract class LoggerFinder {
        protected LoggerFinder() {
        }

        public static LoggerFinder getLoggerFinder() {
            return LoggerFinderImpl.INSTANCE;
        }

        public abstract Logger getLogger(String var1, J_L_Module var2);

        public Logger getLocalizedLogger(String name, final ResourceBundle bundle, J_L_Module module) {
            Objects.requireNonNull(bundle);
            Objects.requireNonNull(module);
            final Logger logger = this.getLogger(name, module);
            return new Logger(){

                @Override
                public String getName() {
                    return logger.getName();
                }

                @Override
                public boolean isLoggable(Logger.Level level) {
                    return logger.isLoggable(level);
                }

                @Override
                public void log(Logger.Level level, ResourceBundle unused, String message, Throwable thrown) {
                    logger.log(level, bundle, message, thrown);
                }

                @Override
                public void log(Logger.Level level, ResourceBundle unused, String format, Object ... args) {
                    logger.log(level, bundle, format, args);
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/System$Logger")
    public static interface Logger {
        public String getName();

        public boolean isLoggable(Level var1);

        default public void log(Level level, String message) {
            this.log(level, null, message, (Object[])null);
        }

        default public void log(Level level, Supplier<String> message) {
            Objects.requireNonNull(message);
            if (this.isLoggable(level)) {
                this.log(level, message.get());
            }
        }

        default public void log(Level level, Object object) {
            Objects.requireNonNull(object);
            if (this.isLoggable(level)) {
                this.log(level, object.toString());
            }
        }

        default public void log(Level level, String message, Throwable throwable) {
            this.log(level, null, message, throwable);
        }

        default public void log(Level level, Supplier<String> message, Throwable throwable) {
            Objects.requireNonNull(message);
            if (this.isLoggable(level)) {
                this.log(level, message.get(), throwable);
            }
        }

        default public void log(Level level, String format, Object ... args) {
            this.log(level, null, format, args);
        }

        public void log(Level var1, ResourceBundle var2, String var3, Throwable var4);

        public void log(Level var1, ResourceBundle var2, String var3, Object ... var4);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @Adapter(value="java/lang/System$Logger$Level")
        public static enum Level {
            ALL(Integer.MIN_VALUE),
            TRACE(400),
            DEBUG(500),
            INFO(800),
            WARNING(900),
            ERROR(1000),
            OFF(Integer.MAX_VALUE);

            final int level;

            private Level(int level) {
                this.level = level;
            }

            public final String getName() {
                return this.name();
            }

            public final int getSeverity() {
                return this.level;
            }
        }
    }
}

