/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j9.intl.UnixProcessHandle;
import xyz.wagyourtail.jvmdg.j9.intl.WindowsProcessHandle;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/ProcessHandle")
public interface J_L_ProcessHandle
extends Comparable<J_L_ProcessHandle> {
    public static final RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();

    public static boolean isUnix() {
        return File.pathSeparatorChar == ':';
    }

    public static Optional<J_L_ProcessHandle> of(long pid) {
        if (J_L_ProcessHandle.isUnix()) {
            return Optional.of(new UnixProcessHandle(pid));
        }
        return Optional.of(new WindowsProcessHandle(pid));
    }

    public static J_L_ProcessHandle current() {
        String pidName = bean.getName();
        long pid = Long.parseLong(pidName.substring(0, pidName.indexOf(64)));
        if (J_L_ProcessHandle.isUnix()) {
            return new UnixProcessHandle(pid){

                @Override
                public CompletableFuture<J_L_ProcessHandle> onExit() {
                    throw new IllegalStateException();
                }
            };
        }
        return new WindowsProcessHandle(pid){

            @Override
            public CompletableFuture<J_L_ProcessHandle> onExit() {
                throw new IllegalStateException();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stream<J_L_ProcessHandle> allProcesses() {
        if (J_L_ProcessHandle.isUnix()) {
            Path pth = Paths.get("/proc", new String[0]);
            try (Stream<Path> stream3 = Files.list(pth);){
                List ph = stream3.map(Path::getFileName).map(Path::toString).mapToLong(Long::parseLong).mapToObj(J_L_ProcessHandle::of).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                Stream<J_L_ProcessHandle> stream2 = ph.stream();
                return stream2;
            }
            catch (IOException e2) {
                return Stream.empty();
            }
        }
        ProcessBuilder pb = new ProcessBuilder(WindowsProcessHandle.wmicLocation, "process", "get", "ProcessID");
        try {
            Process p = pb.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                Stream<J_L_ProcessHandle> stream = br.lines().skip(1L).filter(e -> !e.trim().isEmpty()).map(e -> new WindowsProcessHandle(Long.parseLong(e.trim())));
                return stream;
            }
        }
        catch (IOException e3) {
            return Stream.empty();
        }
    }

    public long pid();

    public Optional<J_L_ProcessHandle> parent();

    public Stream<J_L_ProcessHandle> children();

    public Stream<J_L_ProcessHandle> descendants();

    public Info info();

    public CompletableFuture<J_L_ProcessHandle> onExit();

    public boolean supportsNormalTermination();

    public boolean destroy();

    public boolean destroyForcibly();

    public boolean isAlive();

    public int hashCode();

    public boolean equals(Object var1);

    @Override
    public int compareTo(@NotNull J_L_ProcessHandle var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/ProcessHandle$Info")
    public static interface Info {
        public Optional<String> command();

        public Optional<String> commandLine();

        public Optional<String[]> arguments();

        public Optional<Instant> startInstant();

        public Optional<Duration> totalCpuDuration();

        public Optional<String> user();
    }
}

