/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_ProcessHandle;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Process {
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final MethodHandle getPid;

    @Stub
    public static long pid(Process process) throws Throwable {
        return getPid.invokeExact(process);
    }

    public static CompletableFuture<Process> onExit(Process process) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return process;
        });
    }

    @Stub
    public static J_L_ProcessHandle toHandle(Process process) throws Throwable {
        return J_L_ProcessHandle.of(J_L_Process.pid(process)).get();
    }

    @Stub
    public static J_L_ProcessHandle.Info info(Process process) throws Throwable {
        return J_L_Process.toHandle(process).info();
    }

    @Stub
    public static Stream<J_L_ProcessHandle> children(Process process) throws Throwable {
        return J_L_Process.toHandle(process).children();
    }

    @Stub
    public static Stream<J_L_ProcessHandle> descendants(Process process) throws Throwable {
        return J_L_Process.toHandle(process).descendants();
    }

    static {
        block5: {
            IMPL_LOOKUP = Utils.getImplLookup();
            try {
                if (J_L_ProcessHandle.isUnix()) {
                    MethodHandle gp;
                    try {
                        gp = IMPL_LOOKUP.findGetter(Class.forName("java.lang.UNIXProcess"), "pid", Integer.TYPE).asType(MethodType.methodType(Long.TYPE, Process.class));
                    }
                    catch (ClassNotFoundException e) {
                        gp = IMPL_LOOKUP.findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE));
                    }
                    getPid = gp;
                    break block5;
                }
                getPid = IMPL_LOOKUP.findGetter(Class.forName("java.lang.ProcessImpl"), "handle", Long.TYPE).asType(MethodType.methodType(Long.TYPE, Process.class));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

