/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.math.BigDecimal;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Math {
    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long multiplyExact(long x, int y) {
        return Math.multiplyExact(x, (long)y);
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long multiplyFull(int x, int y) {
        return (long)x * (long)y;
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long multiplyHigh(long x, long y) {
        if (x < 0L || y < 0L) {
            long x1 = x >> 32;
            long x2 = x & 0xFFFFFFFFL;
            long y1 = y >> 32;
            long y2 = y & 0xFFFFFFFFL;
            long z2 = x2 * y2;
            long t = x1 * y2 + (z2 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z0 = t >> 32;
            return x1 * y1 + z0 + ((z1 += x2 * y1) >> 32);
        }
        long x1 = x >>> 32;
        long y1 = y >>> 32;
        long x2 = x & 0xFFFFFFFFL;
        long y2 = y & 0xFFFFFFFFL;
        long A = x1 * y1;
        long B = x2 * y2;
        long C = (x1 + x2) * (y1 + y2);
        long K = C - A - B;
        return ((B >>> 32) + K >>> 32) + A;
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long floorDiv(long x, int y) {
        return Math.floorDiv(x, (long)y);
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int floorMod(long x, int y) {
        return (int)Math.floorMod(x, (long)y);
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static float fma(float a, float b, float c) {
        if (Float.isFinite(a) && Float.isFinite(b) && Float.isFinite(c)) {
            if ((double)a == 0.0 || (double)b == 0.0) {
                return a * b + c;
            }
            return BigDecimal.valueOf((double)a * (double)b).add(new BigDecimal(c)).floatValue();
        }
        return (float)J_L_Math.fma((double)a, (double)b, (double)c);
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static double fma(double a, double b, double c) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c)) {
            return Double.NaN;
        }
        boolean infiniteA = Double.isInfinite(a);
        boolean infiniteB = Double.isInfinite(b);
        boolean infiniteC = Double.isInfinite(c);
        if (infiniteA || infiniteB || infiniteC) {
            if (infiniteA && b == 0.0 || infiniteB && a == 0.0) {
                return Double.NaN;
            }
            double product = a * b;
            if (Double.isInfinite(product) && !infiniteA && !infiniteB) {
                assert (Double.isInfinite(c));
                return c;
            }
            double result = product + c;
            assert (!Double.isFinite(result));
            return result;
        }
        BigDecimal product = new BigDecimal(a).multiply(new BigDecimal(b));
        if (c == 0.0) {
            if (a == 0.0 || b == 0.0) {
                return a * b + c;
            }
            return product.doubleValue();
        }
        return product.add(new BigDecimal(c)).doubleValue();
    }
}

