/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_I_InputStream;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/module/ModuleReader")
public interface J_L_M_ModuleReader
extends Closeable {
    public Optional<URI> find(String var1) throws IOException;

    default public Optional<InputStream> open(String name) throws IOException {
        Optional<URI> optionalURI = this.find(name);
        if (!optionalURI.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(optionalURI.get().toURL().openStream());
    }

    default public Optional<ByteBuffer> read(String name) throws IOException {
        Optional<InputStream> optionalInputStream = this.open(name);
        if (!optionalInputStream.isPresent()) {
            return Optional.empty();
        }
        try (InputStream in = optionalInputStream.get();){
            Optional<ByteBuffer> optional = Optional.of(ByteBuffer.wrap(J_I_InputStream.readAllBytes(in)));
            return optional;
        }
    }

    default public void release(ByteBuffer bb) {
        Objects.requireNonNull(bb);
    }

    public Stream<String> list() throws IOException;
}

