/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j9.intl.NameChecks;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Arrays;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.CoverageIgnore;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/module/ModuleDescriptor")
public class J_L_M_ModuleDescriptor
implements Comparable<J_L_M_ModuleDescriptor> {
    private final String name;
    private final Version version;
    private final String rawVersion;
    private final EnumSet<Modifier> modifiers;
    private final Set<Requires> requiresSet;
    private final Set<Exports> exportsSet;
    private final Set<Opens> opensSet;
    private final Set<String> uses;
    private final Set<Provides> provides;
    private final Set<String> packages;
    private final String mainClass;
    private transient int hash = 0;

    private J_L_M_ModuleDescriptor(String name, Version version, String rawVersion, Set<Modifier> modifiers, Set<Requires> requiresSet, Set<Exports> exportsSet, Set<Opens> opensSet, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass) {
        this.name = name;
        this.version = version;
        this.rawVersion = rawVersion;
        this.modifiers = modifiers.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(modifiers);
        this.requiresSet = Collections.unmodifiableSet(requiresSet);
        this.exportsSet = Collections.unmodifiableSet(exportsSet);
        this.opensSet = Collections.unmodifiableSet(opensSet);
        this.uses = Collections.unmodifiableSet(uses);
        this.provides = Collections.unmodifiableSet(provides);
        this.packages = Collections.unmodifiableSet(packages);
        this.mainClass = mainClass;
    }

    private static long longHash(EnumSet<?> enums) {
        long hash = 0L;
        for (Enum anEnum : enums) {
            hash |= 1L << anEnum.ordinal();
        }
        return hash;
    }

    private static <T> int compare(T a, T b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return ((Comparable)a).compareTo(b);
    }

    private static <T> int compare(Set<T> a, Set<T> b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] aArray = a.toArray();
        Object[] bArray = b.toArray();
        Arrays.sort(aArray);
        Arrays.sort(bArray);
        return J_U_Arrays.compare((Comparable[])((Comparable[])aArray), (Comparable[])((Comparable[])bArray));
    }

    public String name() {
        return this.name;
    }

    public Set<Modifier> modifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    public boolean isOpen() {
        return this.modifiers.contains((Object)Modifier.OPEN);
    }

    public boolean isAutomatic() {
        return this.modifiers.contains((Object)Modifier.AUTOMATIC);
    }

    public Set<Requires> requires() {
        return this.requiresSet;
    }

    public Set<Exports> exports() {
        return this.exportsSet;
    }

    public Set<Opens> opens() {
        return this.opensSet;
    }

    public Set<String> uses() {
        return this.uses;
    }

    public Set<Provides> provides() {
        return this.provides;
    }

    public Optional<Version> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> rawVersion() {
        if (this.version != null) {
            return Optional.of(this.version.toString());
        }
        return Optional.ofNullable(this.rawVersion);
    }

    public String toNameAndVersion() {
        return this.name + (this.version != null ? "@" + this.version : "");
    }

    public Optional<String> mainClass() {
        return Optional.ofNullable(this.mainClass);
    }

    public Set<String> packages() {
        return this.packages;
    }

    @Override
    public int compareTo(@NotNull J_L_M_ModuleDescriptor o) {
        if (this == o) {
            return 0;
        }
        int i = this.name.compareTo(o.name);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.version, o.version);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.rawVersion, o.rawVersion);
        if (i != 0) {
            return i;
        }
        i = Long.compare(J_L_M_ModuleDescriptor.longHash(this.modifiers), J_L_M_ModuleDescriptor.longHash(o.modifiers));
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.requiresSet, o.requiresSet);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.packages, o.packages);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.exportsSet, o.exportsSet);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.opensSet, o.opensSet);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.uses, o.uses);
        if (i != 0) {
            return i;
        }
        i = J_L_M_ModuleDescriptor.compare(this.provides, o.provides);
        if (i != 0) {
            return i;
        }
        return J_L_M_ModuleDescriptor.compare(this.mainClass, o.mainClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof J_L_M_ModuleDescriptor)) {
            return false;
        }
        J_L_M_ModuleDescriptor that = (J_L_M_ModuleDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.rawVersion, that.rawVersion) && Objects.equals(this.modifiers, that.modifiers) && Objects.equals(this.requiresSet, that.requiresSet) && Objects.equals(this.exportsSet, that.exportsSet) && Objects.equals(this.opensSet, that.opensSet) && Objects.equals(this.uses, that.uses) && Objects.equals(this.provides, that.provides) && Objects.equals(this.packages, that.packages) && Objects.equals(this.mainClass, that.mainClass);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int hash = this.name.hashCode() * 43;
        hash = hash * 43 + this.modifiers.hashCode();
        hash = hash * 43 + this.requiresSet.hashCode();
        hash = hash * 43 + this.packages.hashCode();
        hash = hash * 43 + this.exportsSet.hashCode();
        hash = hash * 43 + this.opensSet.hashCode();
        hash = hash * 43 + this.uses.hashCode();
        hash = hash * 43 + this.provides.hashCode();
        hash = this.version != null ? hash * 43 + this.version.hashCode() : (hash *= 43);
        hash = this.rawVersion != null ? hash * 43 + this.rawVersion.hashCode() : (hash *= 43);
        hash = this.mainClass != null ? hash * 43 + this.mainClass.hashCode() : (hash *= 43);
        if (hash == 0) {
            hash = -1;
        }
        this.hash = hash;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOpen()) {
            sb.append("open ");
        }
        sb.append("module { name: ").append(this.toNameAndVersion());
        if (!this.requiresSet.isEmpty()) {
            sb.append(", requires: ").append(this.requiresSet);
        }
        if (!this.uses.isEmpty()) {
            sb.append(", uses: ").append(this.uses);
        }
        if (!this.exportsSet.isEmpty()) {
            sb.append(", exports: ").append(this.exportsSet);
        }
        if (!this.opensSet.isEmpty()) {
            sb.append(", opens: ").append(this.opensSet);
        }
        if (!this.provides.isEmpty()) {
            sb.append(", provides: ").append(this.provides);
        }
        sb.append(" }");
        return sb.toString();
    }

    public static Builder newModule(String name, Set<Modifier> ms) {
        HashSet<Modifier> mods = new HashSet<Modifier>(ms);
        if (mods.contains((Object)Modifier.AUTOMATIC) && mods.size() > 1) {
            throw new IllegalArgumentException("AUTOMATIC cannot be used with other modifiers");
        }
        return new Builder(name, true, mods);
    }

    public static Builder newModule(String name) {
        return new Builder(name, true, Collections.emptySet());
    }

    public static Builder newOpenModule(String name) {
        return new Builder(name, true, Collections.singleton(Modifier.OPEN));
    }

    public static Builder newAutomaticModule(String name) {
        return new Builder(name, true, Collections.singleton(Modifier.AUTOMATIC));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Version")
    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final List<Object> sequence;
        private final List<Object> pre;
        private final List<Object> build;

        private Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Null version string");
            }
            if (version.isEmpty()) {
                throw new IllegalArgumentException("Empty version string");
            }
            this.version = version;
            int i = 0;
            int l = version.length() - 1;
            char c = version.charAt(i);
            if (!Character.isDigit(c)) {
                throw new IllegalArgumentException(version + ": Version string does not start with a number");
            }
            ArrayList<Object> seq = new ArrayList<Object>(4);
            StringBuilder sb = new StringBuilder();
            while (c != '-' && c != '+' && i < l) {
                while (c != '.' && c != '-' && c != '+' && i < l) {
                    sb.append(c);
                    c = version.charAt(++i);
                }
                try {
                    seq.add(Integer.parseInt(sb.toString()));
                }
                catch (NumberFormatException e) {
                    seq.add(sb.toString());
                }
                sb.setLength(0);
            }
            this.sequence = Collections.unmodifiableList(seq);
            if (c == '-' && i >= version.length()) {
                throw new IllegalArgumentException(version + ": Empty pre-release");
            }
            ArrayList<Object> pre = new ArrayList<Object>(2);
            while (c != '+' && i < l) {
                sb.setLength(0);
                c = version.charAt(++i);
                while (c != '.' && c != '-' && c != '+' && i < l) {
                    sb.append(c);
                    c = version.charAt(++i);
                }
                try {
                    pre.add(Integer.parseInt(sb.toString()));
                }
                catch (NumberFormatException e) {
                    pre.add(sb.toString());
                }
            }
            this.pre = Collections.unmodifiableList(pre);
            if (c == '+' && i >= version.length()) {
                throw new IllegalArgumentException(version + ": Empty pre-release");
            }
            ArrayList<Object> build = new ArrayList<Object>(2);
            while (i < l) {
                sb.setLength(0);
                c = version.charAt(++i);
                while (c != '.' && c != '-' && c != '+' && i < l) {
                    sb.append(c);
                    c = version.charAt(++i);
                }
                try {
                    build.add(Integer.parseInt(sb.toString()));
                }
                catch (NumberFormatException e) {
                    build.add(sb.toString());
                }
            }
            this.build = Collections.unmodifiableList(build);
        }

        public static Version parse(String version) {
            return new Version(version);
        }

        private static int cmp(Object a, Object b) {
            if (a instanceof Integer && b instanceof Integer) {
                return Integer.compare((Integer)a, (Integer)b);
            }
            return a.toString().compareTo(b.toString());
        }

        @Override
        public int compareTo(@NotNull Version o) {
            int c = J_U_Arrays.compare(this.sequence.toArray(), o.sequence.toArray(), Version::cmp);
            if (c != 0) {
                return c;
            }
            if (this.pre.isEmpty() && !o.pre.isEmpty()) {
                return 1;
            }
            if (!this.pre.isEmpty() && o.pre.isEmpty()) {
                return -1;
            }
            c = J_U_Arrays.compare(this.pre.toArray(), o.pre.toArray(), Version::cmp);
            if (c != 0) {
                return c;
            }
            return J_U_Arrays.compare(this.build.toArray(), o.build.toArray(), Version::cmp);
        }

        public boolean equals(Object obj) {
            return obj instanceof Version && this.compareTo((Version)obj) == 0;
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        public String toString() {
            return this.version;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Provides")
    public static final class Provides
    implements Comparable<Provides> {
        private final String service;
        private final List<String> providers;

        private Provides(String service, List<String> providers) {
            this.service = service;
            this.providers = Collections.unmodifiableList(providers);
        }

        public String service() {
            return this.service;
        }

        public List<String> providers() {
            return this.providers;
        }

        @Override
        public int compareTo(@NotNull Provides o) {
            if (this == o) {
                return 0;
            }
            int i = this.service.compareTo(o.service);
            if (i != 0) {
                return i;
            }
            return J_U_Arrays.compare((Comparable[])((Comparable[])this.providers.toArray(new String[0])), (Comparable[])((Comparable[])o.providers.toArray(new String[0])));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Provides)) {
                return false;
            }
            Provides provides = (Provides)o;
            return Objects.equals(this.service, provides.service) && Objects.equals(this.providers, provides.providers);
        }

        public int hashCode() {
            int hash = this.service.hashCode() * 43;
            hash = hash * 43 + this.providers.hashCode();
            return hash;
        }

        public String toString() {
            return this.service + " with " + this.providers;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Opens")
    public static final class Opens
    implements Comparable<Opens> {
        private final EnumSet<Modifier> modifiers;
        private final String source;
        private final Set<String> targets;

        private Opens(Set<Modifier> modifiers, String source, Set<String> targets) {
            this.modifiers = modifiers.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(modifiers);
            this.source = source;
            this.targets = Collections.unmodifiableSet(targets);
        }

        public Set<Modifier> modifiers() {
            return Collections.unmodifiableSet(this.modifiers);
        }

        public boolean isQualified() {
            return !this.targets.isEmpty();
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }

        @Override
        public int compareTo(@NotNull Opens o) {
            if (this == o) {
                return 0;
            }
            int i = this.source.compareTo(o.source);
            if (i != 0) {
                return i;
            }
            i = Long.compare(J_L_M_ModuleDescriptor.longHash(this.modifiers), J_L_M_ModuleDescriptor.longHash(o.modifiers));
            if (i != 0) {
                return i;
            }
            return J_L_M_ModuleDescriptor.compare(this.targets, o.targets);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Opens)) {
                return false;
            }
            Opens opens = (Opens)o;
            return Objects.equals(this.modifiers, opens.modifiers) && Objects.equals(this.source, opens.source) && Objects.equals(this.targets, opens.targets);
        }

        public int hashCode() {
            int hash = this.source.hashCode() * 43 + this.modifiers.hashCode();
            hash = hash * 43 + this.targets.hashCode();
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString().toLowerCase()).append(" ");
            }
            sb.append(this.source);
            if (!this.targets.isEmpty()) {
                sb.append(" to ").append(this.targets);
            }
            return sb.toString();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @Adapter(value="java/lang/module/ModuleDescriptor$Opens$Modifier")
        public static enum Modifier {
            SYNTHETIC,
            MANDATED;

        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Exports")
    public static final class Exports
    implements Comparable<Exports> {
        private final EnumSet<Modifier> modifiers;
        private final String source;
        private final Set<String> targets;

        private Exports(Set<Modifier> modifiers, String source, Set<String> targets) {
            this.modifiers = modifiers.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(modifiers);
            this.source = source;
            this.targets = Collections.unmodifiableSet(targets);
        }

        public Set<Modifier> modifiers() {
            return Collections.unmodifiableSet(this.modifiers);
        }

        public boolean isQualified() {
            return !this.targets.isEmpty();
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }

        @Override
        public int compareTo(@NotNull Exports o) {
            if (this == o) {
                return 0;
            }
            int i = this.source.compareTo(o.source);
            if (i != 0) {
                return i;
            }
            i = Long.compare(J_L_M_ModuleDescriptor.longHash(this.modifiers), J_L_M_ModuleDescriptor.longHash(o.modifiers));
            if (i != 0) {
                return i;
            }
            return J_L_M_ModuleDescriptor.compare(this.targets, o.targets);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Exports)) {
                return false;
            }
            Exports exports = (Exports)o;
            return Objects.equals(this.modifiers, exports.modifiers) && Objects.equals(this.source, exports.source) && Objects.equals(this.targets, exports.targets);
        }

        public int hashCode() {
            int hash = this.source.hashCode() * 43 + this.modifiers.hashCode();
            hash = hash * 43 + this.targets.hashCode();
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString().toLowerCase()).append(" ");
            }
            sb.append(this.source);
            if (!this.targets.isEmpty()) {
                sb.append(" to ").append(this.targets);
            }
            return sb.toString();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @Adapter(value="java/lang/module/ModuleDescriptor$Exports$Modifier")
        public static enum Modifier {
            SYNTHETIC,
            MANDATED;

        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Requires")
    public static final class Requires
    implements Comparable<Requires> {
        private final EnumSet<Modifier> modifiers;
        private final String name;
        private final Version version;
        private final String rawVersion;

        private Requires(Set<Modifier> modifiers, String name, Version version, String rawVersion) {
            this.modifiers = modifiers.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(modifiers);
            this.name = name;
            this.version = version;
            this.rawVersion = rawVersion;
        }

        public Set<Modifier> modifiers() {
            return Collections.unmodifiableSet(this.modifiers);
        }

        public String name() {
            return this.name;
        }

        public Optional<Version> compiledVersion() {
            return Optional.ofNullable(this.version);
        }

        public Optional<String> rawCompiledVersion() {
            if (this.version != null) {
                return Optional.of(this.version.toString());
            }
            return Optional.ofNullable(this.rawVersion);
        }

        @Override
        public int compareTo(@NotNull Requires o) {
            if (this == o) {
                return 0;
            }
            int i = this.name.compareTo(o.name);
            if (i != 0) {
                return i;
            }
            i = Long.compare(J_L_M_ModuleDescriptor.longHash(this.modifiers), J_L_M_ModuleDescriptor.longHash(o.modifiers));
            if (i != 0) {
                return i;
            }
            i = J_L_M_ModuleDescriptor.compare(this.version, o.version);
            if (i != 0) {
                return i;
            }
            return J_L_M_ModuleDescriptor.compare(this.rawVersion, o.rawVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Requires)) {
                return false;
            }
            Requires requires = (Requires)o;
            return Objects.equals(this.modifiers, requires.modifiers) && Objects.equals(this.name, requires.name) && Objects.equals(this.version, requires.version) && Objects.equals(this.rawVersion, requires.rawVersion);
        }

        public int hashCode() {
            int hash = this.name.hashCode() * 43 + this.modifiers.hashCode();
            if (this.version != null) {
                hash = hash * 43 + this.version.hashCode();
            }
            if (this.rawVersion != null) {
                hash = hash * 43 + this.rawVersion.hashCode();
            }
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString().toLowerCase()).append(" ");
            }
            if (this.version != null) {
                sb.append(this.name).append("@(").append(this.version).append(")");
            } else {
                sb.append(this.name);
            }
            return sb.toString();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @Adapter(value="java/lang/module/ModuleDescriptor$Requires$Modifier")
        public static enum Modifier {
            TRANSITIVE,
            STATIC,
            SYNTHETIC,
            MANDATED;

        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Builder")
    public static final class Builder {
        final String name;
        final boolean strict;
        final Set<Modifier> modifiers;
        final Set<String> packages = new HashSet<String>();
        final Map<String, Requires> requires = new HashMap<String, Requires>();
        final Map<String, Exports> exports = new HashMap<String, Exports>();
        final Map<String, Opens> opens = new HashMap<String, Opens>();
        final Set<String> uses = new HashSet<String>();
        final Map<String, Provides> provides = new HashMap<String, Provides>();
        Version version;
        String rawVersion;
        String mainClass;

        @CoverageIgnore
        public Builder(String name, boolean strict, Set<Modifier> modifiers) {
            this.name = name;
            this.strict = strict;
            this.modifiers = modifiers;
            assert (!modifiers.contains((Object)Modifier.OPEN) || !modifiers.contains((Object)Modifier.AUTOMATIC));
        }

        private static String packageName(String cn) {
            int index = cn.lastIndexOf(46);
            return index == -1 ? "" : cn.substring(0, index);
        }

        public Builder requires(Requires requires) {
            if (this.modifiers.contains((Object)Modifier.AUTOMATIC)) {
                throw new IllegalStateException("Automatic modules cannot declare dependencies");
            }
            if (this.name.equals(requires.name)) {
                throw new IllegalArgumentException("Dependence on self");
            }
            if (this.requires.containsKey(requires.name)) {
                throw new IllegalArgumentException("Dependence upon " + requires.name + " already declared");
            }
            this.requires.put(requires.name, requires);
            return this;
        }

        public Builder requires(Set<Requires.Modifier> mods, String name, Version version) {
            Objects.requireNonNull(version);
            if (this.strict) {
                NameChecks.checkModuleName(name);
            }
            return this.requires(new Requires(mods, name, version, null));
        }

        public Builder requires(Set<Requires.Modifier> mods, String name) {
            if (this.strict) {
                NameChecks.checkModuleName(name);
            }
            return this.requires(new Requires(mods, name, null, null));
        }

        public Builder requires(String name) {
            return this.requires(EnumSet.noneOf(Requires.Modifier.class), name);
        }

        public Builder exports(Exports exports) {
            if (this.modifiers.contains((Object)Modifier.AUTOMATIC)) {
                throw new IllegalStateException("Automatic modules cannot export packages");
            }
            if (this.exports.containsKey(exports.source)) {
                throw new IllegalArgumentException("Exported package " + exports.source + " already declared");
            }
            this.exports.put(exports.source, exports);
            this.packages.add(exports.source);
            return this;
        }

        public Builder exports(Set<Exports.Modifier> mods, String source, Set<String> targets) {
            if (this.strict) {
                NameChecks.checkPackageName(source);
                for (String target : targets) {
                    NameChecks.checkModuleName(target);
                }
            }
            return this.exports(new Exports(mods, source, targets));
        }

        public Builder exports(Set<Exports.Modifier> mods, String source) {
            if (this.strict) {
                NameChecks.checkPackageName(source);
            }
            return this.exports(new Exports(mods, source, Collections.emptySet()));
        }

        public Builder exports(String source, Set<String> targets) {
            return this.exports(EnumSet.noneOf(Exports.Modifier.class), source, targets);
        }

        public Builder exports(String source) {
            return this.exports(EnumSet.noneOf(Exports.Modifier.class), source);
        }

        public Builder opens(Opens opens) {
            if (this.modifiers.contains((Object)Modifier.AUTOMATIC) || this.modifiers.contains((Object)Modifier.OPEN)) {
                throw new IllegalStateException("Open or Automatic modules cannot open packages");
            }
            if (this.opens.containsKey(opens.source)) {
                throw new IllegalArgumentException("Open package " + opens.source + " already declared");
            }
            this.opens.put(opens.source, opens);
            this.packages.add(opens.source);
            return this;
        }

        public Builder opens(Set<Opens.Modifier> mods, String source, Set<String> targets) {
            if (this.strict) {
                NameChecks.checkPackageName(source);
                for (String target : targets) {
                    NameChecks.checkModuleName(target);
                }
            }
            return this.opens(new Opens(mods, source, targets));
        }

        public Builder opens(Set<Opens.Modifier> mods, String source) {
            if (this.strict) {
                NameChecks.checkPackageName(source);
            }
            return this.opens(new Opens(mods, source, Collections.emptySet()));
        }

        public Builder opens(String source, Set<String> targets) {
            return this.opens(EnumSet.noneOf(Opens.Modifier.class), source, targets);
        }

        public Builder opens(String source) {
            return this.opens(EnumSet.noneOf(Opens.Modifier.class), source);
        }

        public Builder uses(String service) {
            if (this.modifiers.contains((Object)Modifier.AUTOMATIC)) {
                throw new IllegalStateException("Automatic modules cannot declare service dependences");
            }
            NameChecks.checkServiceTypeName(service);
            if (this.uses.contains(service)) {
                throw new IllegalArgumentException("Service " + service + " already declared");
            }
            this.uses.add(service);
            return this;
        }

        public Builder provides(Provides provides) {
            if (this.provides.containsKey(provides.service)) {
                throw new IllegalArgumentException("Providers of service " + provides.service + " already provided");
            }
            this.provides.put(provides.service, provides);
            for (String provider : provides.providers()) {
                this.packages.add(Builder.packageName(provider));
            }
            return this;
        }

        public Builder provides(String service, List<String> providers) {
            if (providers.isEmpty()) {
                throw new IllegalArgumentException("Empty providers set");
            }
            if (this.strict) {
                NameChecks.checkServiceTypeName(service);
                for (String provider : providers) {
                    NameChecks.checkServiceProviderName(provider);
                }
            } else {
                if (Builder.packageName(service).isEmpty()) {
                    throw new IllegalArgumentException(service + ": unnamed package");
                }
                for (String provider : providers) {
                    if (!Builder.packageName(provider).isEmpty()) continue;
                    throw new IllegalArgumentException(provider + ": unnamed package");
                }
            }
            return this.provides(new Provides(service, providers));
        }

        public Builder packages(Set<String> packages) {
            if (this.strict) {
                for (String pkg : packages) {
                    NameChecks.checkPackageName(pkg);
                }
            }
            this.packages.addAll(packages);
            return this;
        }

        public Builder version(Version version) {
            this.version = Objects.requireNonNull(version);
            this.rawVersion = null;
            return this;
        }

        public Builder version(String version) {
            try {
                this.version = Version.parse(version);
                this.rawVersion = null;
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw e;
                }
                this.version = null;
                this.rawVersion = version;
            }
            return this;
        }

        public Builder mainClass(String mainClass) {
            if (this.strict) {
                NameChecks.checkClassName("main class name", mainClass);
            } else if (Builder.packageName(mainClass).isEmpty()) {
                throw new IllegalArgumentException(mainClass + ": unnamed package");
            }
            this.packages.add(Builder.packageName(mainClass));
            this.mainClass = mainClass;
            return this;
        }

        public J_L_M_ModuleDescriptor build() {
            HashSet<Requires> requires = new HashSet<Requires>(this.requires.values());
            HashSet<Exports> exports = new HashSet<Exports>(this.exports.values());
            HashSet<Opens> opens = new HashSet<Opens>(this.opens.values());
            HashSet<Provides> provides = new HashSet<Provides>(this.provides.values());
            if (this.strict && !this.name.equals("java.base") && !this.requires.containsKey("java.base")) {
                requires.add(new Requires(EnumSet.of(Requires.Modifier.MANDATED), "java.base", null, null));
            }
            return new J_L_M_ModuleDescriptor(this.name, this.version, this.rawVersion, this.modifiers, requires, exports, opens, this.uses, provides, this.packages, this.mainClass);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/module/ModuleDescriptor$Modifier")
    public static enum Modifier {
        OPEN,
        AUTOMATIC,
        SYNTHETIC,
        MANDATED;

    }
}

