/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import sun.misc.Unsafe;
import xyz.wagyourtail.jvmdg.asm.ASMUtils;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Modify;
import xyz.wagyourtail.jvmdg.version.Ref;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/invoke/VarHandle")
public class J_L_I_VarHandle {
    private static final Unsafe unsafe = Utils.getUnsafe();
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Object staticFieldBase;
    private final long fieldOffset;
    private final Field field;
    private final Class<?> ownerClass;
    private final Class<?> type;
    private final boolean isStatic;
    private final boolean isArray;
    private final long arrayIndexScale;

    @Modify(ref=@Ref(value="xyz/wagyourtail/jvmdg/j9/stub/java_base/J_L_I_VarHandle"))
    public static void modifyPolymorphics(MethodNode mnode, int i) {
        MethodInsnNode min = (MethodInsnNode)mnode.instructions.get(i);
        AccessMode am = AccessMode.byName.get(min.name);
        if (am == null) {
            return;
        }
        Type ret = Type.getReturnType((String)min.desc);
        min.name = J_L_I_VarHandle.fixMethodName(min.name, ret.getDescriptor());
        Type[] args = Type.getArgumentTypes((String)min.desc);
        for (int j = 0; j < args.length; ++j) {
            if (args[j].getSort() < 9) continue;
            args[j] = Type.getObjectType((String)"java/lang/Object");
        }
        if (ret.getSort() >= 9) {
            if (!ret.getInternalName().equals("java/lang/Object")) {
                mnode.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new TypeInsnNode(192, ret.getInternalName()));
            }
            ret = Type.getObjectType((String)"java/lang/Object");
        }
        if (ret.getInternalName().equals("java/lang/Object")) {
            switch (am.accessType) {
                case GET: {
                    break;
                }
                case SET: 
                case COMPARE_AND_SET: {
                    throw new IllegalStateException();
                }
                case COMPARE_AND_EXCHANGE: 
                case GET_AND_UPDATE: {
                    Type lastArg = args[args.length - 1];
                    if (lastArg.getSort() >= 9) break;
                    ret = lastArg;
                    Handle box = ASMUtils.boxType((Type)lastArg);
                    assert (box != null);
                    mnode.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(184, box.getOwner(), box.getName(), box.getDesc(), false));
                }
            }
        }
        min.desc = Type.getMethodDescriptor((Type)ret, (Type[])args);
    }

    private static String fixMethodName(String name, String desc) {
        if (name.startsWith("get") && !name.startsWith("getAnd") && desc.length() == 1) {
            return name + desc;
        }
        return name;
    }

    public J_L_I_VarHandle(Field field) {
        this.field = field;
        this.ownerClass = field.getDeclaringClass();
        this.type = field.getType();
        this.isStatic = Modifier.isStatic(field.getModifiers());
        this.isArray = false;
        this.arrayIndexScale = 0L;
        if (this.isStatic) {
            this.staticFieldBase = unsafe.staticFieldBase(field);
            this.fieldOffset = unsafe.staticFieldOffset(field);
        } else {
            this.staticFieldBase = null;
            this.fieldOffset = unsafe.objectFieldOffset(field);
        }
    }

    public J_L_I_VarHandle(Class<?> arrayClass) {
        this.field = null;
        this.ownerClass = arrayClass;
        this.type = arrayClass.getComponentType();
        this.isStatic = false;
        this.isArray = true;
        this.staticFieldBase = null;
        this.fieldOffset = unsafe.arrayBaseOffset(arrayClass);
        this.arrayIndexScale = unsafe.arrayIndexScale(arrayClass);
    }

    private void checkStatic(Class<?> type) {
        if (this.isArray || !this.isStatic || !type.isAssignableFrom(this.type)) {
            throw new WrongMethodTypeException();
        }
    }

    private void checkOwner(Object owner, Class<?> type) {
        Objects.requireNonNull(owner);
        if (this.isArray || this.isStatic || !this.ownerClass.isAssignableFrom(owner.getClass()) || !type.isAssignableFrom(this.type)) {
            throw new WrongMethodTypeException();
        }
    }

    private void checkArray(Object array, int index, Class<?> type) {
        Objects.requireNonNull(array);
        if (!(this.isArray && this.ownerClass.isAssignableFrom(array.getClass()) && type.isAssignableFrom(this.type))) {
            throw new WrongMethodTypeException();
        }
        if (index < 0 || index >= Array.getLength(array)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public final Object get() {
        if (Object.class.isAssignableFrom(this.type)) {
            this.checkStatic(Object.class);
            return unsafe.getObject(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Boolean.TYPE) {
            this.checkStatic(Boolean.TYPE);
            return unsafe.getBoolean(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Byte.TYPE) {
            this.checkStatic(Byte.TYPE);
            return unsafe.getByte(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Character.TYPE) {
            this.checkStatic(Character.TYPE);
            return Character.valueOf(unsafe.getChar(this.staticFieldBase, this.fieldOffset));
        }
        if (this.type == Short.TYPE) {
            this.checkStatic(Short.TYPE);
            return unsafe.getShort(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Integer.TYPE) {
            this.checkStatic(Integer.TYPE);
            return unsafe.getInt(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Long.TYPE) {
            this.checkStatic(Long.TYPE);
            return unsafe.getLong(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Float.TYPE) {
            this.checkStatic(Float.TYPE);
            return Float.valueOf(unsafe.getFloat(this.staticFieldBase, this.fieldOffset));
        }
        if (this.type == Double.TYPE) {
            this.checkStatic(Double.TYPE);
            return unsafe.getDouble(this.staticFieldBase, this.fieldOffset);
        }
        throw new WrongMethodTypeException();
    }

    public final boolean getZ() {
        this.checkStatic(Boolean.TYPE);
        return unsafe.getBoolean(this.staticFieldBase, this.fieldOffset);
    }

    public final byte getB() {
        this.checkStatic(Byte.TYPE);
        return unsafe.getByte(this.staticFieldBase, this.fieldOffset);
    }

    public final char getC() {
        this.checkStatic(Character.TYPE);
        return unsafe.getChar(this.staticFieldBase, this.fieldOffset);
    }

    public final short getS() {
        this.checkStatic(Short.TYPE);
        return unsafe.getShort(this.staticFieldBase, this.fieldOffset);
    }

    public final int getI() {
        this.checkStatic(Integer.TYPE);
        return unsafe.getInt(this.staticFieldBase, this.fieldOffset);
    }

    public final long getJ() {
        this.checkStatic(Long.TYPE);
        return unsafe.getLong(this.staticFieldBase, this.fieldOffset);
    }

    public final float getF() {
        this.checkStatic(Float.TYPE);
        return unsafe.getFloat(this.staticFieldBase, this.fieldOffset);
    }

    public final double getD() {
        this.checkStatic(Double.TYPE);
        return unsafe.getDouble(this.staticFieldBase, this.fieldOffset);
    }

    public final Object get(Object owner) {
        if (Object.class.isAssignableFrom(this.type)) {
            this.checkOwner(owner, Object.class);
            return unsafe.getObject(owner, this.fieldOffset);
        }
        if (this.type == Boolean.TYPE) {
            this.checkOwner(owner, Boolean.TYPE);
            return unsafe.getBoolean(owner, this.fieldOffset);
        }
        if (this.type == Byte.TYPE) {
            this.checkOwner(owner, Byte.TYPE);
            return unsafe.getByte(owner, this.fieldOffset);
        }
        if (this.type == Character.TYPE) {
            this.checkOwner(owner, Character.TYPE);
            return Character.valueOf(unsafe.getChar(owner, this.fieldOffset));
        }
        if (this.type == Short.TYPE) {
            this.checkOwner(owner, Short.TYPE);
            return unsafe.getShort(owner, this.fieldOffset);
        }
        if (this.type == Integer.TYPE) {
            this.checkOwner(owner, Integer.TYPE);
            return unsafe.getInt(owner, this.fieldOffset);
        }
        if (this.type == Long.TYPE) {
            this.checkOwner(owner, Long.TYPE);
            return unsafe.getLong(owner, this.fieldOffset);
        }
        if (this.type == Float.TYPE) {
            this.checkOwner(owner, Float.TYPE);
            return Float.valueOf(unsafe.getFloat(owner, this.fieldOffset));
        }
        if (this.type == Double.TYPE) {
            this.checkOwner(owner, Double.TYPE);
            return unsafe.getDouble(owner, this.fieldOffset);
        }
        throw new WrongMethodTypeException();
    }

    public final boolean getZ(Object owner) {
        this.checkOwner(owner, Boolean.TYPE);
        return unsafe.getBoolean(owner, this.fieldOffset);
    }

    public final byte getB(Object owner) {
        this.checkOwner(owner, Byte.TYPE);
        return unsafe.getByte(owner, this.fieldOffset);
    }

    public final char getC(Object owner) {
        this.checkOwner(owner, Character.TYPE);
        return unsafe.getChar(owner, this.fieldOffset);
    }

    public final short getS(Object owner) {
        this.checkOwner(owner, Short.TYPE);
        return unsafe.getShort(owner, this.fieldOffset);
    }

    public final int getI(Object owner) {
        this.checkOwner(owner, Integer.TYPE);
        return unsafe.getInt(owner, this.fieldOffset);
    }

    public final long getJ(Object owner) {
        this.checkOwner(owner, Long.TYPE);
        return unsafe.getLong(owner, this.fieldOffset);
    }

    public final float getF(Object owner) {
        this.checkOwner(owner, Float.TYPE);
        return unsafe.getFloat(owner, this.fieldOffset);
    }

    public final double getD(Object owner) {
        this.checkOwner(owner, Double.TYPE);
        return unsafe.getDouble(owner, this.fieldOffset);
    }

    public final Object get(Object owner, int index) {
        if (Object.class.isAssignableFrom(this.type)) {
            this.checkArray(owner, index, Object.class);
            return unsafe.getObject(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Boolean.TYPE) {
            this.checkArray(owner, index, Boolean.TYPE);
            return unsafe.getBoolean(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Byte.TYPE) {
            this.checkArray(owner, index, Byte.TYPE);
            return unsafe.getByte(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Character.TYPE) {
            this.checkArray(owner, index, Character.TYPE);
            return Character.valueOf(unsafe.getChar(owner, this.fieldOffset + (long)index * this.arrayIndexScale));
        }
        if (this.type == Short.TYPE) {
            this.checkArray(owner, index, Short.TYPE);
            return unsafe.getShort(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Integer.TYPE) {
            this.checkArray(owner, index, Integer.TYPE);
            return unsafe.getInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Long.TYPE) {
            this.checkArray(owner, index, Long.TYPE);
            return unsafe.getLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Float.TYPE) {
            this.checkArray(owner, index, Float.TYPE);
            return Float.valueOf(unsafe.getFloat(owner, this.fieldOffset + (long)index * this.arrayIndexScale));
        }
        if (this.type == Double.TYPE) {
            this.checkArray(owner, index, Double.TYPE);
            return unsafe.getDouble(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        throw new WrongMethodTypeException();
    }

    public final boolean getZ(Object owner, int index) {
        this.checkArray(owner, index, Boolean.TYPE);
        return unsafe.getBoolean(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final byte getB(Object owner, int index) {
        this.checkArray(owner, index, Byte.TYPE);
        return unsafe.getByte(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final char getC(Object owner, int index) {
        this.checkArray(owner, index, Character.TYPE);
        return unsafe.getChar(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final short getS(Object owner, int index) {
        this.checkArray(owner, index, Short.TYPE);
        return unsafe.getShort(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final int getI(Object owner, int index) {
        this.checkArray(owner, index, Integer.TYPE);
        return unsafe.getInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final long getJ(Object owner, int index) {
        this.checkArray(owner, index, Long.TYPE);
        return unsafe.getLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final float getF(Object owner, int index) {
        this.checkArray(owner, index, Float.TYPE);
        return unsafe.getFloat(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final double getD(Object owner, int index) {
        this.checkArray(owner, index, Double.TYPE);
        return unsafe.getDouble(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final void set(Object value) {
        this.checkStatic(Object.class);
        unsafe.putObject(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(boolean value) {
        this.checkStatic(Boolean.TYPE);
        unsafe.putBoolean(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(byte value) {
        this.checkStatic(Byte.TYPE);
        unsafe.putByte(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(char value) {
        this.checkStatic(Character.TYPE);
        unsafe.putChar(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(short value) {
        this.checkStatic(Short.TYPE);
        unsafe.putShort(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(int value) {
        this.checkStatic(Integer.TYPE);
        unsafe.putInt(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(long value) {
        this.checkStatic(Long.TYPE);
        unsafe.putLong(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(float value) {
        this.checkStatic(Float.TYPE);
        unsafe.putFloat(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(double value) {
        this.checkStatic(Double.TYPE);
        unsafe.putDouble(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void set(Object owner, Object value) {
        this.checkOwner(owner, Object.class);
        unsafe.putObject(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, boolean value) {
        this.checkOwner(owner, Boolean.TYPE);
        unsafe.putBoolean(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, byte value) {
        this.checkOwner(owner, Byte.TYPE);
        unsafe.putByte(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, char value) {
        this.checkOwner(owner, Character.TYPE);
        unsafe.putChar(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, short value) {
        this.checkOwner(owner, Short.TYPE);
        unsafe.putShort(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, int value) {
        this.checkOwner(owner, Integer.TYPE);
        unsafe.putInt(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, long value) {
        this.checkOwner(owner, Long.TYPE);
        unsafe.putLong(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, float value) {
        this.checkOwner(owner, Float.TYPE);
        unsafe.putFloat(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, double value) {
        this.checkOwner(owner, Double.TYPE);
        unsafe.putDouble(owner, this.fieldOffset, value);
    }

    public final void set(Object owner, int index, Object value) {
        this.checkArray(owner, index, Object.class);
        unsafe.putObject(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, boolean value) {
        this.checkArray(owner, index, Boolean.TYPE);
        unsafe.putBoolean(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, byte value) {
        this.checkArray(owner, index, Byte.TYPE);
        unsafe.putByte(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, char value) {
        this.checkArray(owner, index, Character.TYPE);
        unsafe.putChar(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, short value) {
        this.checkArray(owner, index, Short.TYPE);
        unsafe.putShort(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, int value) {
        this.checkArray(owner, index, Integer.TYPE);
        unsafe.putInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, long value) {
        this.checkArray(owner, index, Long.TYPE);
        unsafe.putLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, float value) {
        this.checkArray(owner, index, Float.TYPE);
        unsafe.putFloat(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void set(Object owner, int index, double value) {
        this.checkArray(owner, index, Double.TYPE);
        unsafe.putDouble(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final Object getVolatile() {
        if (Object.class.isAssignableFrom(this.type)) {
            this.checkStatic(Object.class);
            return unsafe.getObjectVolatile(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Boolean.TYPE) {
            this.checkStatic(Boolean.TYPE);
            return unsafe.getBooleanVolatile(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Byte.TYPE) {
            this.checkStatic(Byte.TYPE);
            return unsafe.getByteVolatile(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Character.TYPE) {
            this.checkStatic(Character.TYPE);
            return Character.valueOf(unsafe.getCharVolatile(this.staticFieldBase, this.fieldOffset));
        }
        if (this.type == Short.TYPE) {
            this.checkStatic(Short.TYPE);
            return unsafe.getShortVolatile(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Integer.TYPE) {
            this.checkStatic(Integer.TYPE);
            return unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Long.TYPE) {
            this.checkStatic(Long.TYPE);
            return unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset);
        }
        if (this.type == Float.TYPE) {
            this.checkStatic(Float.TYPE);
            return Float.valueOf(unsafe.getFloatVolatile(this.staticFieldBase, this.fieldOffset));
        }
        if (this.type == Double.TYPE) {
            this.checkStatic(Double.TYPE);
            return unsafe.getDoubleVolatile(this.staticFieldBase, this.fieldOffset);
        }
        throw new WrongMethodTypeException();
    }

    public final boolean getVolatileZ() {
        this.checkStatic(Boolean.TYPE);
        return unsafe.getBooleanVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final byte getVolatileB() {
        this.checkStatic(Byte.TYPE);
        return unsafe.getByteVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final char getVolatileC() {
        this.checkStatic(Character.TYPE);
        return unsafe.getCharVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final short getVolatileS() {
        this.checkStatic(Short.TYPE);
        return unsafe.getShortVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final int getVolatileI() {
        this.checkStatic(Integer.TYPE);
        return unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final long getVolatileJ() {
        this.checkStatic(Long.TYPE);
        return unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final float getVolatileF() {
        this.checkStatic(Float.TYPE);
        return unsafe.getFloatVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final double getVolatileD() {
        this.checkStatic(Double.TYPE);
        return unsafe.getDoubleVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final Object getVolatile(Object owner) {
        if (Object.class.isAssignableFrom(this.type)) {
            this.checkOwner(owner, Object.class);
            return unsafe.getObjectVolatile(owner, this.fieldOffset);
        }
        if (this.type == Boolean.TYPE) {
            this.checkOwner(owner, Boolean.TYPE);
            return unsafe.getBooleanVolatile(owner, this.fieldOffset);
        }
        if (this.type == Byte.TYPE) {
            this.checkOwner(owner, Byte.TYPE);
            return unsafe.getByteVolatile(owner, this.fieldOffset);
        }
        if (this.type == Character.TYPE) {
            this.checkOwner(owner, Character.TYPE);
            return Character.valueOf(unsafe.getCharVolatile(owner, this.fieldOffset));
        }
        if (this.type == Short.TYPE) {
            this.checkOwner(owner, Short.TYPE);
            return unsafe.getShortVolatile(owner, this.fieldOffset);
        }
        if (this.type == Integer.TYPE) {
            this.checkOwner(owner, Integer.TYPE);
            return unsafe.getIntVolatile(owner, this.fieldOffset);
        }
        if (this.type == Long.TYPE) {
            this.checkOwner(owner, Long.TYPE);
            return unsafe.getLongVolatile(owner, this.fieldOffset);
        }
        if (this.type == Float.TYPE) {
            this.checkOwner(owner, Float.TYPE);
            return Float.valueOf(unsafe.getFloatVolatile(owner, this.fieldOffset));
        }
        if (this.type == Double.TYPE) {
            this.checkOwner(owner, Double.TYPE);
            return unsafe.getDoubleVolatile(owner, this.fieldOffset);
        }
        throw new WrongMethodTypeException();
    }

    public final boolean getVolatileZ(Object owner) {
        this.checkOwner(owner, Boolean.TYPE);
        return unsafe.getBooleanVolatile(owner, this.fieldOffset);
    }

    public final byte getVolatileB(Object owner) {
        this.checkOwner(owner, Byte.TYPE);
        return unsafe.getByteVolatile(owner, this.fieldOffset);
    }

    public final char getVolatileC(Object owner) {
        this.checkOwner(owner, Character.TYPE);
        return unsafe.getCharVolatile(owner, this.fieldOffset);
    }

    public final short getVolatileS(Object owner) {
        this.checkOwner(owner, Short.TYPE);
        return unsafe.getShortVolatile(owner, this.fieldOffset);
    }

    public final int getVolatileI(Object owner) {
        this.checkOwner(owner, Integer.TYPE);
        return unsafe.getIntVolatile(owner, this.fieldOffset);
    }

    public final long getVolatileJ(Object owner) {
        this.checkOwner(owner, Long.TYPE);
        return unsafe.getLongVolatile(owner, this.fieldOffset);
    }

    public final float getVolatileF(Object owner) {
        this.checkOwner(owner, Float.TYPE);
        return unsafe.getFloatVolatile(owner, this.fieldOffset);
    }

    public final double getVolatileD(Object owner) {
        this.checkOwner(owner, Double.TYPE);
        return unsafe.getDoubleVolatile(owner, this.fieldOffset);
    }

    public final Object getVolatile(Object owner, int index) {
        if (Object.class.isAssignableFrom(this.type)) {
            this.checkArray(owner, index, Object.class);
            return unsafe.getObjectVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Boolean.TYPE) {
            this.checkArray(owner, index, Boolean.TYPE);
            return unsafe.getBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Byte.TYPE) {
            this.checkArray(owner, index, Byte.TYPE);
            return unsafe.getByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Character.TYPE) {
            this.checkArray(owner, index, Character.TYPE);
            return Character.valueOf(unsafe.getCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale));
        }
        if (this.type == Short.TYPE) {
            this.checkArray(owner, index, Short.TYPE);
            return unsafe.getShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Integer.TYPE) {
            this.checkArray(owner, index, Integer.TYPE);
            return unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Long.TYPE) {
            this.checkArray(owner, index, Long.TYPE);
            return unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        if (this.type == Float.TYPE) {
            this.checkArray(owner, index, Float.TYPE);
            return Float.valueOf(unsafe.getFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale));
        }
        if (this.type == Double.TYPE) {
            this.checkArray(owner, index, Double.TYPE);
            return unsafe.getDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        }
        throw new WrongMethodTypeException();
    }

    public final boolean getVolatileZ(Object owner, int index) {
        this.checkArray(owner, index, Boolean.TYPE);
        return unsafe.getBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final byte getVolatileB(Object owner, int index) {
        this.checkArray(owner, index, Byte.TYPE);
        return unsafe.getByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final char getVolatileC(Object owner, int index) {
        this.checkArray(owner, index, Character.TYPE);
        return unsafe.getCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final short getVolatileS(Object owner, int index) {
        this.checkArray(owner, index, Short.TYPE);
        return unsafe.getShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final int getVolatileI(Object owner, int index) {
        this.checkArray(owner, index, Integer.TYPE);
        return unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final long getVolatileJ(Object owner, int index) {
        this.checkArray(owner, index, Long.TYPE);
        return unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final float getVolatileF(Object owner, int index) {
        this.checkArray(owner, index, Float.TYPE);
        return unsafe.getFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final double getVolatileD(Object owner, int index) {
        this.checkArray(owner, index, Double.TYPE);
        return unsafe.getDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final void setVolatile(Object value) {
        this.checkStatic(Object.class);
        unsafe.putObjectVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(boolean value) {
        this.checkStatic(Boolean.TYPE);
        unsafe.putBooleanVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(byte value) {
        this.checkStatic(Byte.TYPE);
        unsafe.putByteVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(char value) {
        this.checkStatic(Character.TYPE);
        unsafe.putCharVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(short value) {
        this.checkStatic(Short.TYPE);
        unsafe.putShortVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(int value) {
        this.checkStatic(Integer.TYPE);
        unsafe.putIntVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(long value) {
        this.checkStatic(Long.TYPE);
        unsafe.putLongVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(float value) {
        this.checkStatic(Float.TYPE);
        unsafe.putFloatVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(double value) {
        this.checkStatic(Double.TYPE);
        unsafe.putDoubleVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, Object value) {
        this.checkOwner(owner, Object.class);
        unsafe.putObjectVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, boolean value) {
        this.checkOwner(owner, Boolean.TYPE);
        unsafe.putBooleanVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, byte value) {
        this.checkOwner(owner, Byte.TYPE);
        unsafe.putByteVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, char value) {
        this.checkOwner(owner, Character.TYPE);
        unsafe.putCharVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, short value) {
        this.checkOwner(owner, Short.TYPE);
        unsafe.putShortVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, int value) {
        this.checkOwner(owner, Integer.TYPE);
        unsafe.putIntVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, long value) {
        this.checkOwner(owner, Long.TYPE);
        unsafe.putLongVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, float value) {
        this.checkOwner(owner, Float.TYPE);
        unsafe.putFloatVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, double value) {
        this.checkOwner(owner, Double.TYPE);
        unsafe.putDoubleVolatile(owner, this.fieldOffset, value);
    }

    public final void setVolatile(Object owner, int index, Object value) {
        this.checkArray(owner, index, Object.class);
        unsafe.putObjectVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, boolean value) {
        this.checkArray(owner, index, Boolean.TYPE);
        unsafe.putBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, byte value) {
        this.checkArray(owner, index, Byte.TYPE);
        unsafe.putByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, char value) {
        this.checkArray(owner, index, Character.TYPE);
        unsafe.putCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, short value) {
        this.checkArray(owner, index, Short.TYPE);
        unsafe.putShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, int value) {
        this.checkArray(owner, index, Integer.TYPE);
        unsafe.putIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, long value) {
        this.checkArray(owner, index, Long.TYPE);
        unsafe.putLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, float value) {
        this.checkArray(owner, index, Float.TYPE);
        unsafe.putFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setVolatile(Object owner, int index, double value) {
        this.checkArray(owner, index, Double.TYPE);
        unsafe.putDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final Object getOpaque() {
        return this.getVolatile();
    }

    public final boolean getOpaqueZ() {
        this.checkStatic(Boolean.TYPE);
        return unsafe.getBooleanVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final byte getOpaqueB() {
        this.checkStatic(Byte.TYPE);
        return unsafe.getByteVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final char getOpaqueC() {
        this.checkStatic(Character.TYPE);
        return unsafe.getCharVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final short getOpaqueS() {
        this.checkStatic(Short.TYPE);
        return unsafe.getShortVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final int getOpaqueI() {
        this.checkStatic(Integer.TYPE);
        return unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final long getOpaqueJ() {
        this.checkStatic(Long.TYPE);
        return unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final float getOpaqueF() {
        this.checkStatic(Float.TYPE);
        return unsafe.getFloatVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final double getOpaqueD() {
        this.checkStatic(Double.TYPE);
        return unsafe.getDoubleVolatile(this.staticFieldBase, this.fieldOffset);
    }

    public final Object getOpaque(Object owner) {
        return this.getVolatile(owner);
    }

    public final boolean getOpaqueZ(Object owner) {
        this.checkOwner(owner, Boolean.TYPE);
        return unsafe.getBooleanVolatile(owner, this.fieldOffset);
    }

    public final byte getOpaqueB(Object owner) {
        this.checkOwner(owner, Byte.TYPE);
        return unsafe.getByteVolatile(owner, this.fieldOffset);
    }

    public final char getOpaqueC(Object owner) {
        this.checkOwner(owner, Character.TYPE);
        return unsafe.getCharVolatile(owner, this.fieldOffset);
    }

    public final short getOpaqueS(Object owner) {
        this.checkOwner(owner, Short.TYPE);
        return unsafe.getShortVolatile(owner, this.fieldOffset);
    }

    public final int getOpaqueI(Object owner) {
        this.checkOwner(owner, Integer.TYPE);
        return unsafe.getIntVolatile(owner, this.fieldOffset);
    }

    public final long getOpaqueJ(Object owner) {
        this.checkOwner(owner, Long.TYPE);
        return unsafe.getLongVolatile(owner, this.fieldOffset);
    }

    public final float getOpaqueF(Object owner) {
        this.checkOwner(owner, Float.TYPE);
        return unsafe.getFloatVolatile(owner, this.fieldOffset);
    }

    public final double getOpaqueD(Object owner) {
        this.checkOwner(owner, Double.TYPE);
        return unsafe.getDoubleVolatile(owner, this.fieldOffset);
    }

    public final Object getOpaque(Object owner, int index) {
        return this.getVolatile(owner, index);
    }

    public final boolean getOpaqueZ(Object owner, int index) {
        this.checkArray(owner, index, Boolean.TYPE);
        return unsafe.getBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final byte getOpaqueB(Object owner, int index) {
        this.checkArray(owner, index, Byte.TYPE);
        return unsafe.getByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final char getOpaqueC(Object owner, int index) {
        this.checkArray(owner, index, Character.TYPE);
        return unsafe.getCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final short getOpaqueS(Object owner, int index) {
        this.checkArray(owner, index, Short.TYPE);
        return unsafe.getShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final int getOpaqueI(Object owner, int index) {
        this.checkArray(owner, index, Integer.TYPE);
        return unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final long getOpaqueJ(Object owner, int index) {
        this.checkArray(owner, index, Long.TYPE);
        return unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final float getOpaqueF(Object owner, int index) {
        this.checkArray(owner, index, Float.TYPE);
        return unsafe.getFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final double getOpaqueD(Object owner, int index) {
        this.checkArray(owner, index, Double.TYPE);
        return unsafe.getDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
    }

    public final void setOpaque(Object value) {
        this.checkStatic(Object.class);
        unsafe.putObjectVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(boolean value) {
        this.checkStatic(Boolean.TYPE);
        unsafe.putBooleanVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(byte value) {
        this.checkStatic(Byte.TYPE);
        unsafe.putByteVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(char value) {
        this.checkStatic(Character.TYPE);
        unsafe.putCharVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(short value) {
        this.checkStatic(Short.TYPE);
        unsafe.putShortVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(int value) {
        this.checkStatic(Integer.TYPE);
        unsafe.putIntVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(long value) {
        this.checkStatic(Long.TYPE);
        unsafe.putLongVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(float value) {
        this.checkStatic(Float.TYPE);
        unsafe.putFloatVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(double value) {
        this.checkStatic(Double.TYPE);
        unsafe.putDoubleVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, Object value) {
        this.checkOwner(owner, Object.class);
        unsafe.putObjectVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, boolean value) {
        this.checkOwner(owner, Boolean.TYPE);
        unsafe.putBooleanVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, byte value) {
        this.checkOwner(owner, Byte.TYPE);
        unsafe.putByteVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, char value) {
        this.checkOwner(owner, Character.TYPE);
        unsafe.putCharVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, short value) {
        this.checkOwner(owner, Short.TYPE);
        unsafe.putShortVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, int value) {
        this.checkOwner(owner, Integer.TYPE);
        unsafe.putIntVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, long value) {
        this.checkOwner(owner, Long.TYPE);
        unsafe.putLongVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, float value) {
        this.checkOwner(owner, Float.TYPE);
        unsafe.putFloatVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, double value) {
        this.checkOwner(owner, Double.TYPE);
        unsafe.putDoubleVolatile(owner, this.fieldOffset, value);
    }

    public final void setOpaque(Object owner, int index, Object value) {
        this.checkArray(owner, index, Object.class);
        unsafe.putObjectVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, boolean value) {
        this.checkArray(owner, index, Boolean.TYPE);
        unsafe.putBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, byte value) {
        this.checkArray(owner, index, Byte.TYPE);
        unsafe.putByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, char value) {
        this.checkArray(owner, index, Character.TYPE);
        unsafe.putCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, short value) {
        this.checkArray(owner, index, Short.TYPE);
        unsafe.putShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, int value) {
        this.checkArray(owner, index, Integer.TYPE);
        unsafe.putIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, long value) {
        this.checkArray(owner, index, Long.TYPE);
        unsafe.putLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, float value) {
        this.checkArray(owner, index, Float.TYPE);
        unsafe.putFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setOpaque(Object owner, int index, double value) {
        this.checkArray(owner, index, Double.TYPE);
        unsafe.putDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final Object getAcquire() {
        this.checkStatic(Object.class);
        Object obj = this.getVolatile();
        unsafe.fullFence();
        return obj;
    }

    public final boolean getAcquireZ() {
        this.checkStatic(Boolean.TYPE);
        boolean v = unsafe.getBooleanVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final byte getAcquireB() {
        this.checkStatic(Byte.TYPE);
        byte v = unsafe.getByteVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final char getAcquireC() {
        this.checkStatic(Character.TYPE);
        char v = unsafe.getCharVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final short getAcquireS() {
        this.checkStatic(Short.TYPE);
        short v = unsafe.getShortVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final int getAcquireI() {
        this.checkStatic(Integer.TYPE);
        int v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final long getAcquireJ() {
        this.checkStatic(Long.TYPE);
        long v = unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final float getAcquireF() {
        this.checkStatic(Float.TYPE);
        float v = unsafe.getFloatVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final double getAcquireD() {
        this.checkStatic(Double.TYPE);
        double v = unsafe.getDoubleVolatile(this.staticFieldBase, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final Object getAcquire(Object owner) {
        this.checkOwner(owner, Object.class);
        Object obj = this.getVolatile(owner);
        unsafe.fullFence();
        return obj;
    }

    public final boolean getAcquireZ(Object owner) {
        this.checkOwner(owner, Boolean.TYPE);
        boolean v = unsafe.getBooleanVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final byte getAcquireB(Object owner) {
        this.checkOwner(owner, Byte.TYPE);
        byte v = unsafe.getByteVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final char getAcquireC(Object owner) {
        this.checkOwner(owner, Character.TYPE);
        char v = unsafe.getCharVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final short getAcquireS(Object owner) {
        this.checkOwner(owner, Short.TYPE);
        short v = unsafe.getShortVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final int getAcquireI(Object owner) {
        this.checkOwner(owner, Integer.TYPE);
        int v = unsafe.getIntVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final long getAcquireJ(Object owner) {
        this.checkOwner(owner, Long.TYPE);
        long v = unsafe.getLongVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final float getAcquireF(Object owner) {
        this.checkOwner(owner, Float.TYPE);
        float v = unsafe.getFloatVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final double getAcquireD(Object owner) {
        this.checkOwner(owner, Double.TYPE);
        double v = unsafe.getDoubleVolatile(owner, this.fieldOffset);
        unsafe.fullFence();
        return v;
    }

    public final Object getAcquire(Object owner, int index) {
        this.checkArray(owner, index, Object.class);
        Object obj = this.getVolatile(owner, index);
        unsafe.fullFence();
        return obj;
    }

    public final boolean getAcquireZ(Object owner, int index) {
        this.checkArray(owner, index, Boolean.TYPE);
        boolean v = unsafe.getBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final byte getAcquireB(Object owner, int index) {
        this.checkArray(owner, index, Byte.TYPE);
        byte v = unsafe.getByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final char getAcquireC(Object owner, int index) {
        this.checkArray(owner, index, Character.TYPE);
        char v = unsafe.getCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final short getAcquireS(Object owner, int index) {
        this.checkArray(owner, index, Short.TYPE);
        short v = unsafe.getShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final int getAcquireI(Object owner, int index) {
        this.checkArray(owner, index, Integer.TYPE);
        int v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final long getAcquireJ(Object owner, int index) {
        this.checkArray(owner, index, Long.TYPE);
        long v = unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final float getAcquireF(Object owner, int index) {
        this.checkArray(owner, index, Float.TYPE);
        float v = unsafe.getFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final double getAcquireD(Object owner, int index) {
        this.checkArray(owner, index, Double.TYPE);
        double v = unsafe.getDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale);
        unsafe.fullFence();
        return v;
    }

    public final void setRelease(Object value) {
        this.checkStatic(Object.class);
        unsafe.fullFence();
        unsafe.putObjectVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(boolean value) {
        this.checkStatic(Boolean.TYPE);
        unsafe.fullFence();
        unsafe.putBooleanVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(byte value) {
        this.checkStatic(Byte.TYPE);
        unsafe.fullFence();
        unsafe.putByteVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(char value) {
        this.checkStatic(Character.TYPE);
        unsafe.fullFence();
        unsafe.putCharVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(short value) {
        this.checkStatic(Short.TYPE);
        unsafe.fullFence();
        unsafe.putShortVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(int value) {
        this.checkStatic(Integer.TYPE);
        unsafe.fullFence();
        unsafe.putIntVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(long value) {
        this.checkStatic(Long.TYPE);
        unsafe.fullFence();
        unsafe.putLongVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(float value) {
        this.checkStatic(Float.TYPE);
        unsafe.fullFence();
        unsafe.putFloatVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(double value) {
        this.checkStatic(Double.TYPE);
        unsafe.fullFence();
        unsafe.putDoubleVolatile(this.staticFieldBase, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, Object value) {
        this.checkOwner(owner, Object.class);
        unsafe.fullFence();
        unsafe.putObjectVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, boolean value) {
        this.checkOwner(owner, Boolean.TYPE);
        unsafe.fullFence();
        unsafe.putBooleanVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, byte value) {
        this.checkOwner(owner, Byte.TYPE);
        unsafe.fullFence();
        unsafe.putByteVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, char value) {
        this.checkOwner(owner, Character.TYPE);
        unsafe.fullFence();
        unsafe.putCharVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, short value) {
        this.checkOwner(owner, Short.TYPE);
        unsafe.fullFence();
        unsafe.putShortVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, int value) {
        this.checkOwner(owner, Integer.TYPE);
        unsafe.fullFence();
        unsafe.putIntVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, long value) {
        this.checkOwner(owner, Long.TYPE);
        unsafe.fullFence();
        unsafe.putLongVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, float value) {
        this.checkOwner(owner, Float.TYPE);
        unsafe.fullFence();
        unsafe.putFloatVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, double value) {
        this.checkOwner(owner, Double.TYPE);
        unsafe.fullFence();
        unsafe.putDoubleVolatile(owner, this.fieldOffset, value);
    }

    public final void setRelease(Object owner, int index, Object value) {
        this.checkArray(owner, index, Object.class);
        unsafe.fullFence();
        unsafe.putObjectVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, boolean value) {
        this.checkArray(owner, index, Boolean.TYPE);
        unsafe.fullFence();
        unsafe.putBooleanVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, byte value) {
        this.checkArray(owner, index, Byte.TYPE);
        unsafe.fullFence();
        unsafe.putByteVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, char value) {
        this.checkArray(owner, index, Character.TYPE);
        unsafe.fullFence();
        unsafe.putCharVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, short value) {
        this.checkArray(owner, index, Short.TYPE);
        unsafe.fullFence();
        unsafe.putShortVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, int value) {
        this.checkArray(owner, index, Integer.TYPE);
        unsafe.fullFence();
        unsafe.putIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, long value) {
        this.checkArray(owner, index, Long.TYPE);
        unsafe.fullFence();
        unsafe.putLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, float value) {
        this.checkArray(owner, index, Float.TYPE);
        unsafe.fullFence();
        unsafe.putFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final void setRelease(Object owner, int index, double value) {
        this.checkArray(owner, index, Double.TYPE);
        unsafe.fullFence();
        unsafe.putDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final boolean compareAndSet(Object expected, Object newValue) {
        this.checkStatic(Object.class);
        return unsafe.compareAndSwapObject(this.staticFieldBase, this.fieldOffset, expected, newValue);
    }

    public final boolean compareAndSet(boolean expected, boolean newValue) {
        int i;
        this.checkStatic(Boolean.TYPE);
        do {
            if ((byte)(i = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) != 0 == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, i, newValue ? 1 : 0));
        return true;
    }

    public final boolean compareAndSet(byte expected, byte newValue) {
        int i;
        this.checkStatic(Byte.TYPE);
        do {
            if ((byte)(i = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, i, newValue));
        return true;
    }

    public final boolean compareAndSet(char expected, char newValue) {
        int i;
        this.checkStatic(Character.TYPE);
        do {
            if ((char)(i = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, i, newValue));
        return true;
    }

    public final boolean compareAndSet(short expected, short newValue) {
        int i;
        this.checkStatic(Short.TYPE);
        do {
            if ((short)(i = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, i, newValue));
        return true;
    }

    public final boolean compareAndSet(int expected, int newValue) {
        this.checkStatic(Integer.TYPE);
        return unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, expected, newValue);
    }

    public final boolean compareAndSet(long expected, long newValue) {
        this.checkStatic(Long.TYPE);
        return unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, expected, newValue);
    }

    public final boolean compareAndSet(float expected, float newValue) {
        this.checkStatic(Float.TYPE);
        return unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(newValue));
    }

    public final boolean compareAndSet(double expected, double newValue) {
        this.checkStatic(Double.TYPE);
        return unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(newValue));
    }

    public final boolean compareAndSet(Object owner, Object expected, Object newValue) {
        this.checkOwner(owner, Object.class);
        return unsafe.compareAndSwapObject(owner, this.fieldOffset, expected, newValue);
    }

    public final boolean compareAndSet(Object owner, boolean expected, boolean newValue) {
        int i;
        this.checkOwner(owner, Boolean.TYPE);
        do {
            if ((byte)(i = unsafe.getIntVolatile(owner, this.fieldOffset)) != 0 == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, i, newValue ? 1 : 0));
        return true;
    }

    public final boolean compareAndSet(Object owner, byte expected, byte newValue) {
        int i;
        this.checkOwner(owner, Byte.TYPE);
        do {
            if ((byte)(i = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, i, newValue));
        return true;
    }

    public final boolean compareAndSet(Object owner, char expected, char newValue) {
        int i;
        this.checkOwner(owner, Character.TYPE);
        do {
            if ((char)(i = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, i, newValue));
        return true;
    }

    public final boolean compareAndSet(Object owner, short expected, short newValue) {
        int i;
        this.checkOwner(owner, Short.TYPE);
        do {
            if ((short)(i = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, i, newValue));
        return true;
    }

    public final boolean compareAndSet(Object owner, int expected, int newValue) {
        this.checkOwner(owner, Integer.TYPE);
        return unsafe.compareAndSwapInt(owner, this.fieldOffset, expected, newValue);
    }

    public final boolean compareAndSet(Object owner, long expected, long newValue) {
        this.checkOwner(owner, Long.TYPE);
        return unsafe.compareAndSwapLong(owner, this.fieldOffset, expected, newValue);
    }

    public final boolean compareAndSet(Object owner, float expected, float newValue) {
        this.checkOwner(owner, Float.TYPE);
        return unsafe.compareAndSwapInt(owner, this.fieldOffset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(newValue));
    }

    public final boolean compareAndSet(Object owner, double expected, double newValue) {
        this.checkOwner(owner, Double.TYPE);
        return unsafe.compareAndSwapLong(owner, this.fieldOffset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(newValue));
    }

    public final boolean compareAndSet(Object owner, int index, Object expected, Object newValue) {
        this.checkArray(owner, index, Object.class);
        return unsafe.compareAndSwapObject(owner, this.fieldOffset + (long)index * this.arrayIndexScale, expected, newValue);
    }

    public final boolean compareAndSet(Object owner, int index, boolean expected, boolean newValue) {
        int i;
        this.checkArray(owner, index, Boolean.TYPE);
        do {
            if ((byte)(i = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) != 0 == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, i, newValue ? 1 : 0));
        return true;
    }

    public final boolean compareAndSet(Object owner, int index, byte expected, byte newValue) {
        int i;
        this.checkArray(owner, index, Byte.TYPE);
        do {
            if ((byte)(i = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, i, newValue));
        return true;
    }

    public final boolean compareAndSet(Object owner, int index, char expected, char newValue) {
        int i;
        this.checkArray(owner, index, Character.TYPE);
        do {
            if ((char)(i = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, i, newValue));
        return true;
    }

    public final boolean compareAndSet(Object owner, int index, short expected, short newValue) {
        int i;
        this.checkArray(owner, index, Short.TYPE);
        do {
            if ((short)(i = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return false;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, i, newValue));
        return true;
    }

    public final boolean compareAndSet(Object owner, int index, int expected, int newValue) {
        this.checkArray(owner, index, Integer.TYPE);
        return unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, expected, newValue);
    }

    public final boolean compareAndSet(Object owner, int index, long expected, long newValue) {
        this.checkArray(owner, index, Long.TYPE);
        return unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, expected, newValue);
    }

    public final boolean compareAndSet(Object owner, int index, float expected, float newValue) {
        this.checkArray(owner, index, Float.TYPE);
        return unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(newValue));
    }

    public final boolean compareAndSet(Object owner, int index, double expected, double newValue) {
        this.checkArray(owner, index, Double.TYPE);
        return unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(newValue));
    }

    public final Object compareAndExchange(Object expected, Object newValue) {
        this.checkStatic(Object.class);
        do {
            Object v;
            if ((v = unsafe.getObjectVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapObject(this.staticFieldBase, this.fieldOffset, expected, newValue));
        return expected;
    }

    public final boolean compareAndExchange(boolean expected, boolean newValue) {
        int v;
        this.checkStatic(Boolean.TYPE);
        do {
            if ((byte)(v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) != 0 == expected) continue;
            return (byte)v != 0;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, newValue ? 1 : 0));
        return expected;
    }

    public final byte compareAndExchange(byte expected, byte newValue) {
        int v;
        this.checkStatic(Byte.TYPE);
        do {
            if ((byte)(v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return (byte)v;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, newValue));
        return expected;
    }

    public final char compareAndExchange(char expected, char newValue) {
        int v;
        this.checkStatic(Character.TYPE);
        do {
            if ((char)(v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return (char)v;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, newValue));
        return expected;
    }

    public final short compareAndExchange(short expected, short newValue) {
        int v;
        this.checkStatic(Short.TYPE);
        do {
            if ((short)(v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return (short)v;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, newValue));
        return expected;
    }

    public final int compareAndExchange(int expected, int newValue) {
        int v;
        this.checkStatic(Integer.TYPE);
        do {
            if ((v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, newValue));
        return expected;
    }

    public final long compareAndExchange(long expected, long newValue) {
        long v;
        this.checkStatic(Long.TYPE);
        do {
            if ((v = unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, v, newValue));
        return expected;
    }

    public final float compareAndExchange(float expected, float newValue) {
        float v;
        this.checkStatic(Float.TYPE);
        do {
            if ((v = unsafe.getFloatVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, Float.floatToRawIntBits(v), Float.floatToRawIntBits(newValue)));
        return expected;
    }

    public final double compareAndExchange(double expected, double newValue) {
        double v;
        this.checkStatic(Double.TYPE);
        do {
            if ((v = unsafe.getDoubleVolatile(this.staticFieldBase, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, Double.doubleToRawLongBits(v), Double.doubleToRawLongBits(newValue)));
        return expected;
    }

    public final Object compareAndExchange(Object owner, Object expected, Object newValue) {
        Object v;
        this.checkOwner(owner, Object.class);
        do {
            if ((v = unsafe.getObjectVolatile(owner, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapObject(owner, this.fieldOffset, v, newValue));
        return expected;
    }

    public final boolean compareAndExchange(Object owner, boolean expected, boolean newValue) {
        int v;
        this.checkOwner(owner, Boolean.TYPE);
        do {
            if ((byte)(v = unsafe.getIntVolatile(owner, this.fieldOffset)) != 0 == expected) continue;
            return (byte)v != 0;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, newValue ? 1 : 0));
        return expected;
    }

    public final byte compareAndExchange(Object owner, byte expected, byte newValue) {
        int v;
        this.checkOwner(owner, Byte.TYPE);
        do {
            if ((byte)(v = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return (byte)v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, newValue));
        return expected;
    }

    public final char compareAndExchange(Object owner, char expected, char newValue) {
        int v;
        this.checkOwner(owner, Character.TYPE);
        do {
            if ((char)(v = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return (char)v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, newValue));
        return expected;
    }

    public final short compareAndExchange(Object owner, short expected, short newValue) {
        int v;
        this.checkOwner(owner, Short.TYPE);
        do {
            if ((short)(v = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return (short)v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, newValue));
        return expected;
    }

    public final int compareAndExchange(Object owner, int expected, int newValue) {
        int v;
        this.checkOwner(owner, Integer.TYPE);
        do {
            if ((v = unsafe.getIntVolatile(owner, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, newValue));
        return expected;
    }

    public final long compareAndExchange(Object owner, long expected, long newValue) {
        long v;
        this.checkOwner(owner, Long.TYPE);
        do {
            if ((v = unsafe.getLongVolatile(owner, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapLong(owner, this.fieldOffset, v, newValue));
        return expected;
    }

    public final float compareAndExchange(Object owner, float expected, float newValue) {
        float v;
        this.checkOwner(owner, Float.TYPE);
        do {
            if ((v = unsafe.getFloatVolatile(owner, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, Float.floatToRawIntBits(v), Float.floatToRawIntBits(newValue)));
        return expected;
    }

    public final double compareAndExchange(Object owner, double expected, double newValue) {
        double v;
        this.checkOwner(owner, Double.TYPE);
        do {
            if ((v = unsafe.getDoubleVolatile(owner, this.fieldOffset)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapLong(owner, this.fieldOffset, Double.doubleToRawLongBits(v), Double.doubleToRawLongBits(newValue)));
        return expected;
    }

    public final Object compareAndExchange(Object owner, int index, Object expected, Object newValue) {
        Object v;
        this.checkArray(owner, index, Object.class);
        do {
            if ((v = unsafe.getObjectVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapObject(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue));
        return expected;
    }

    public final boolean compareAndExchange(Object owner, int index, boolean expected, boolean newValue) {
        int v;
        this.checkArray(owner, index, Boolean.TYPE);
        do {
            if ((byte)(v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) != 0 == expected) continue;
            return (byte)v != 0;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue ? 1 : 0));
        return expected;
    }

    public final byte compareAndExchange(Object owner, int index, byte expected, byte newValue) {
        int v;
        this.checkArray(owner, index, Byte.TYPE);
        do {
            if ((byte)(v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return (byte)v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue));
        return expected;
    }

    public final char compareAndExchange(Object owner, int index, char expected, char newValue) {
        int v;
        this.checkArray(owner, index, Character.TYPE);
        do {
            if ((char)(v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return (char)v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue));
        return expected;
    }

    public final short compareAndExchange(Object owner, int index, short expected, short newValue) {
        int v;
        this.checkArray(owner, index, Short.TYPE);
        do {
            if ((short)(v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return (short)v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue));
        return expected;
    }

    public final int compareAndExchange(Object owner, int index, int expected, int newValue) {
        int v;
        this.checkArray(owner, index, Integer.TYPE);
        do {
            if ((v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue));
        return expected;
    }

    public final long compareAndExchange(Object owner, int index, long expected, long newValue) {
        long v;
        this.checkArray(owner, index, Long.TYPE);
        do {
            if ((v = unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v, newValue));
        return expected;
    }

    public final float compareAndExchange(Object owner, int index, float expected, float newValue) {
        float v;
        this.checkArray(owner, index, Float.TYPE);
        do {
            if ((v = unsafe.getFloatVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Float.floatToRawIntBits(v), Float.floatToRawIntBits(newValue)));
        return expected;
    }

    public final double compareAndExchange(Object owner, int index, double expected, double newValue) {
        double v;
        this.checkArray(owner, index, Double.TYPE);
        do {
            if ((v = unsafe.getDoubleVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale)) == expected) continue;
            return v;
        } while (!unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Double.doubleToRawLongBits(v), Double.doubleToRawLongBits(newValue)));
        return expected;
    }

    public final Object compareAndExchangeAcquire(Object expected, Object newValue) {
        Object v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final boolean compareAndExchangeAcquire(boolean expected, boolean newValue) {
        boolean v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final byte compareAndExchangeAcquire(byte expected, byte newValue) {
        byte v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final char compareAndExchangeAcquire(char expected, char newValue) {
        char v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final short compareAndExchangeAcquire(short expected, short newValue) {
        short v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final int compareAndExchangeAcquire(int expected, int newValue) {
        int v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final long compareAndExchangeAcquire(long expected, long newValue) {
        long v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final float compareAndExchangeAcquire(float expected, float newValue) {
        float v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final double compareAndExchangeAcquire(double expected, double newValue) {
        double v = this.compareAndExchange(expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final Object compareAndExchangeAcquire(Object owner, Object expected, Object newValue) {
        Object v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final boolean compareAndExchangeAcquire(Object owner, boolean expected, boolean newValue) {
        boolean v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final byte compareAndExchangeAcquire(Object owner, byte expected, byte newValue) {
        byte v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final char compareAndExchangeAcquire(Object owner, char expected, char newValue) {
        char v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final short compareAndExchangeAcquire(Object owner, short expected, short newValue) {
        short v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final int compareAndExchangeAcquire(Object owner, int expected, int newValue) {
        int v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final long compareAndExchangeAcquire(Object owner, long expected, long newValue) {
        long v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final float compareAndExchangeAcquire(Object owner, float expected, float newValue) {
        float v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final double compareAndExchangeAcquire(Object owner, double expected, double newValue) {
        double v = this.compareAndExchange(owner, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final Object compareAndExchangeAcquire(Object owner, int index, Object expected, Object newValue) {
        Object v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final boolean compareAndExchangeAcquire(Object owner, int index, boolean expected, boolean newValue) {
        boolean v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final byte compareAndExchangeAcquire(Object owner, int index, byte expected, byte newValue) {
        byte v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final char compareAndExchangeAcquire(Object owner, int index, char expected, char newValue) {
        char v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final short compareAndExchangeAcquire(Object owner, int index, short expected, short newValue) {
        short v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final int compareAndExchangeAcquire(Object owner, int index, int expected, int newValue) {
        int v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final long compareAndExchangeAcquire(Object owner, int index, long expected, long newValue) {
        long v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final float compareAndExchangeAcquire(Object owner, int index, float expected, float newValue) {
        float v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final double compareAndExchangeAcquire(Object owner, int index, double expected, double newValue) {
        double v = this.compareAndExchange(owner, index, expected, newValue);
        unsafe.fullFence();
        return v;
    }

    public final Object compareAndExchangeRelease(Object expected, Object newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final boolean compareAndExchangeRelease(boolean expected, boolean newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final byte compareAndExchangeRelease(byte expected, byte newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final char compareAndExchangeRelease(char expected, char newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final short compareAndExchangeRelease(short expected, short newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final int compareAndExchangeRelease(int expected, int newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final long compareAndExchangeRelease(long expected, long newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final float compareAndExchangeRelease(float expected, float newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final double compareAndExchangeRelease(double expected, double newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(expected, newValue);
    }

    public final Object compareAndExchangeRelease(Object owner, Object expected, Object newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final boolean compareAndExchangeRelease(Object owner, boolean expected, boolean newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final byte compareAndExchangeRelease(Object owner, byte expected, byte newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final char compareAndExchangeRelease(Object owner, char expected, char newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final short compareAndExchangeRelease(Object owner, short expected, short newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final int compareAndExchangeRelease(Object owner, int expected, int newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final long compareAndExchangeRelease(Object owner, long expected, long newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final float compareAndExchangeRelease(Object owner, float expected, float newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final double compareAndExchangeRelease(Object owner, double expected, double newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, expected, newValue);
    }

    public final Object compareAndExchangeRelease(Object owner, int index, Object expected, Object newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final boolean compareAndExchangeRelease(Object owner, int index, boolean expected, boolean newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final byte compareAndExchangeRelease(Object owner, int index, byte expected, byte newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final char compareAndExchangeRelease(Object owner, int index, char expected, char newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final short compareAndExchangeRelease(Object owner, int index, short expected, short newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final int compareAndExchangeRelease(Object owner, int index, int expected, int newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final long compareAndExchangeRelease(Object owner, int index, long expected, long newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final float compareAndExchangeRelease(Object owner, int index, float expected, float newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final double compareAndExchangeRelease(Object owner, int index, double expected, double newValue) {
        unsafe.fullFence();
        return this.compareAndExchange(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object expected, Object newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(boolean expected, boolean newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(byte expected, byte newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(char expected, char newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(short expected, short newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(int expected, int newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(long expected, long newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(float expected, float newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(double expected, double newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, Object expected, Object newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, boolean expected, boolean newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, byte expected, byte newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, char expected, char newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, short expected, short newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int expected, int newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, long expected, long newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, float expected, float newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, double expected, double newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, Object expected, Object newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, boolean expected, boolean newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, byte expected, byte newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, char expected, char newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, short expected, short newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, int expected, int newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, long expected, long newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, float expected, float newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetPlain(Object owner, int index, double expected, double newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object expected, Object newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(boolean expected, boolean newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(byte expected, byte newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(char expected, char newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(short expected, short newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(int expected, int newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(long expected, long newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(float expected, float newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(double expected, double newValue) {
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, Object expected, Object newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, boolean expected, boolean newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, byte expected, byte newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, char expected, char newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, short expected, short newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int expected, int newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, long expected, long newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, float expected, float newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, double expected, double newValue) {
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, Object expected, Object newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, boolean expected, boolean newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, byte expected, byte newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, char expected, char newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, short expected, short newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, int expected, int newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, long expected, long newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, float expected, float newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSet(Object owner, int index, double expected, double newValue) {
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetAcquire(Object expected, Object newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(boolean expected, boolean newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(byte expected, byte newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(char expected, char newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(short expected, short newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(int expected, int newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(long expected, long newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(float expected, float newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(double expected, double newValue) {
        boolean b = this.compareAndSet(expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, Object expected, Object newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, boolean expected, boolean newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, byte expected, byte newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, char expected, char newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, short expected, short newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int expected, int newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, long expected, long newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, float expected, float newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, double expected, double newValue) {
        boolean b = this.compareAndSet(owner, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, Object expected, Object newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, boolean expected, boolean newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, byte expected, byte newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, char expected, char newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, short expected, short newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, int expected, int newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, long expected, long newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, float expected, float newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetAcquire(Object owner, int index, double expected, double newValue) {
        boolean b = this.compareAndSet(owner, index, expected, newValue);
        unsafe.fullFence();
        return b;
    }

    public final boolean weakCompareAndSetRelease(Object expected, Object newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(boolean expected, boolean newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(byte expected, byte newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(char expected, char newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(short expected, short newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(int expected, int newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(long expected, long newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(float expected, float newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(double expected, double newValue) {
        unsafe.fullFence();
        return this.compareAndSet(expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, Object expected, Object newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, boolean expected, boolean newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, byte expected, byte newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, char expected, char newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, short expected, short newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int expected, int newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, long expected, long newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, float expected, float newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, double expected, double newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, Object expected, Object newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, boolean expected, boolean newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, byte expected, byte newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, char expected, char newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, short expected, short newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, int expected, int newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, long expected, long newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, float expected, float newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final boolean weakCompareAndSetRelease(Object owner, int index, double expected, double newValue) {
        unsafe.fullFence();
        return this.compareAndSet(owner, index, expected, newValue);
    }

    public final Object getAndSet(Object newValue) {
        this.checkStatic(Object.class);
        return unsafe.getAndSetObject(this.staticFieldBase, this.fieldOffset, newValue);
    }

    public final boolean getAndSet(boolean newValue) {
        this.checkStatic(Boolean.TYPE);
        return (byte)unsafe.getAndSetInt(this.staticFieldBase, this.fieldOffset, newValue ? 1 : 0) != 0;
    }

    public final byte getAndSet(byte newValue) {
        this.checkStatic(Byte.TYPE);
        return (byte)unsafe.getAndSetInt(this.staticFieldBase, this.fieldOffset, newValue);
    }

    public final char getAndSet(char newValue) {
        this.checkStatic(Character.TYPE);
        return (char)unsafe.getAndSetInt(this.staticFieldBase, this.fieldOffset, newValue);
    }

    public final short getAndSet(short newValue) {
        this.checkStatic(Short.TYPE);
        return (short)unsafe.getAndSetInt(this.staticFieldBase, this.fieldOffset, newValue);
    }

    public final int getAndSet(int newValue) {
        this.checkStatic(Integer.TYPE);
        return unsafe.getAndSetInt(this.staticFieldBase, this.fieldOffset, newValue);
    }

    public final long getAndSet(long newValue) {
        this.checkStatic(Long.TYPE);
        return unsafe.getAndSetLong(this.staticFieldBase, this.fieldOffset, newValue);
    }

    public final float getAndSet(float newValue) {
        this.checkStatic(Float.TYPE);
        return Float.intBitsToFloat(unsafe.getAndSetInt(this.staticFieldBase, this.fieldOffset, Float.floatToRawIntBits(newValue)));
    }

    public final double getAndSet(double newValue) {
        this.checkStatic(Double.TYPE);
        return Double.longBitsToDouble(unsafe.getAndSetLong(this.staticFieldBase, this.fieldOffset, Double.doubleToRawLongBits(newValue)));
    }

    public final Object getAndSet(Object owner, Object newValue) {
        this.checkOwner(owner, Object.class);
        return unsafe.getAndSetObject(owner, this.fieldOffset, newValue);
    }

    public final boolean getAndSet(Object owner, boolean newValue) {
        this.checkOwner(owner, Boolean.TYPE);
        return (byte)unsafe.getAndSetInt(owner, this.fieldOffset, newValue ? 1 : 0) != 0;
    }

    public final byte getAndSet(Object owner, byte newValue) {
        this.checkOwner(owner, Byte.TYPE);
        return (byte)unsafe.getAndSetInt(owner, this.fieldOffset, newValue);
    }

    public final char getAndSet(Object owner, char newValue) {
        this.checkOwner(owner, Character.TYPE);
        return (char)unsafe.getAndSetInt(owner, this.fieldOffset, newValue);
    }

    public final short getAndSet(Object owner, short newValue) {
        this.checkOwner(owner, Short.TYPE);
        return (short)unsafe.getAndSetInt(owner, this.fieldOffset, newValue);
    }

    public final int getAndSet(Object owner, int newValue) {
        this.checkOwner(owner, Integer.TYPE);
        return unsafe.getAndSetInt(owner, this.fieldOffset, newValue);
    }

    public final long getAndSet(Object owner, long newValue) {
        this.checkOwner(owner, Long.TYPE);
        return unsafe.getAndSetLong(owner, this.fieldOffset, newValue);
    }

    public final float getAndSet(Object owner, float newValue) {
        this.checkOwner(owner, Float.TYPE);
        return Float.intBitsToFloat(unsafe.getAndSetInt(owner, this.fieldOffset, Float.floatToRawIntBits(newValue)));
    }

    public final double getAndSet(Object owner, double newValue) {
        this.checkOwner(owner, Double.TYPE);
        return Double.longBitsToDouble(unsafe.getAndSetLong(owner, this.fieldOffset, Double.doubleToRawLongBits(newValue)));
    }

    public final Object getAndSet(Object owner, int index, Object newValue) {
        this.checkArray(owner, index, Object.class);
        return unsafe.getAndSetObject(owner, this.fieldOffset + (long)index * this.arrayIndexScale, index);
    }

    public final boolean getAndSet(Object owner, int index, boolean newValue) {
        this.checkArray(owner, index, Boolean.TYPE);
        return (byte)unsafe.getAndSetInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, newValue ? 1 : 0) != 0;
    }

    public final byte getAndSet(Object owner, int index, byte newValue) {
        this.checkArray(owner, index, Byte.TYPE);
        return (byte)unsafe.getAndSetInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, newValue);
    }

    public final char getAndSet(Object owner, int index, char newValue) {
        this.checkArray(owner, index, Character.TYPE);
        return (char)unsafe.getAndSetInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, newValue);
    }

    public final short getAndSet(Object owner, int index, short newValue) {
        this.checkArray(owner, index, Short.TYPE);
        return (short)unsafe.getAndSetInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, newValue);
    }

    public final int getAndSet(Object owner, int index, int newValue) {
        this.checkArray(owner, index, Integer.TYPE);
        return unsafe.getAndSetInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, newValue);
    }

    public final long getAndSet(Object owner, int index, long newValue) {
        this.checkArray(owner, index, Long.TYPE);
        return unsafe.getAndSetLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, newValue);
    }

    public final float getAndSet(Object owner, int index, float newValue) {
        this.checkArray(owner, index, Float.TYPE);
        return Float.intBitsToFloat(unsafe.getAndSetInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Float.floatToRawIntBits(newValue)));
    }

    public final double getAndSet(Object owner, int index, double newValue) {
        this.checkArray(owner, index, Double.TYPE);
        return Double.longBitsToDouble(unsafe.getAndSetLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Double.doubleToRawLongBits(newValue)));
    }

    public final Object getAndSetAcquire(Object newValue) {
        Object v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndSetAcquire(boolean newValue) {
        boolean v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndSetAcquire(byte newValue) {
        byte v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final char getAndSetAcquire(char newValue) {
        char v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final short getAndSetAcquire(short newValue) {
        short v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final int getAndSetAcquire(int newValue) {
        int v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final long getAndSetAcquire(long newValue) {
        long v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final float getAndSetAcquire(float newValue) {
        float v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final double getAndSetAcquire(double newValue) {
        double v = this.getAndSet(newValue);
        unsafe.fullFence();
        return v;
    }

    public final Object getAndSetAcquire(Object owner, Object newValue) {
        Object v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndSetAcquire(Object owner, boolean newValue) {
        boolean v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndSetAcquire(Object owner, byte newValue) {
        byte v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final char getAndSetAcquire(Object owner, char newValue) {
        char v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final short getAndSetAcquire(Object owner, short newValue) {
        short v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final int getAndSetAcquire(Object owner, int newValue) {
        int v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final long getAndSetAcquire(Object owner, long newValue) {
        long v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final float getAndSetAcquire(Object owner, float newValue) {
        float v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final double getAndSetAcquire(Object owner, double newValue) {
        double v = this.getAndSet(owner, newValue);
        unsafe.fullFence();
        return v;
    }

    public final Object getAndSetAcquire(Object owner, int index, Object newValue) {
        Object v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndSetAcquire(Object owner, int index, boolean newValue) {
        boolean v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndSetAcquire(Object owner, int index, byte newValue) {
        byte v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final char getAndSetAcquire(Object owner, int index, char newValue) {
        char v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final short getAndSetAcquire(Object owner, int index, short newValue) {
        short v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final int getAndSetAcquire(Object owner, int index, int newValue) {
        int v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final long getAndSetAcquire(Object owner, int index, long newValue) {
        long v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final float getAndSetAcquire(Object owner, int index, float newValue) {
        float v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final double getAndSetAcquire(Object owner, int index, double newValue) {
        double v = this.getAndSet(owner, index, newValue);
        unsafe.fullFence();
        return v;
    }

    public final Object getAndSetRelease(Object newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final boolean getAndSetRelease(boolean newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final byte getAndSetRelease(byte newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final char getAndSetRelease(char newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final short getAndSetRelease(short newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final int getAndSetRelease(int newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final long getAndSetRelease(long newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final float getAndSetRelease(float newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final double getAndSetRelease(double newValue) {
        unsafe.fullFence();
        return this.getAndSet(newValue);
    }

    public final Object getAndSetRelease(Object owner, Object newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final boolean getAndSetRelease(Object owner, boolean newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final byte getAndSetRelease(Object owner, byte newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final char getAndSetRelease(Object owner, char newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final short getAndSetRelease(Object owner, short newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final int getAndSetRelease(Object owner, int newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final long getAndSetRelease(Object owner, long newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final float getAndSetRelease(Object owner, float newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final double getAndSetRelease(Object owner, double newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, newValue);
    }

    public final Object getAndSetRelease(Object owner, int index, Object newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final boolean getAndSetRelease(Object owner, int index, boolean newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final byte getAndSetRelease(Object owner, int index, byte newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final char getAndSetRelease(Object owner, int index, char newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final short getAndSetRelease(Object owner, int index, short newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final int getAndSetRelease(Object owner, int index, int newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final long getAndSetRelease(Object owner, int index, long newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final float getAndSetRelease(Object owner, int index, float newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final double getAndSetRelease(Object owner, int index, double newValue) {
        unsafe.fullFence();
        return this.getAndSet(owner, index, newValue);
    }

    public final byte getAndAdd(byte value) {
        byte v;
        this.checkStatic(Byte.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getByte(this.staticFieldBase, this.fieldOffset), v + value)) {
        }
        return v;
    }

    public final char getAndAdd(char value) {
        char v;
        this.checkStatic(Character.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getChar(this.staticFieldBase, this.fieldOffset), value)) {
        }
        return v;
    }

    public final short getAndAdd(short value) {
        short v;
        this.checkStatic(Short.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getShort(this.staticFieldBase, this.fieldOffset), value)) {
        }
        return v;
    }

    public final int getAndAdd(int value) {
        this.checkStatic(Integer.TYPE);
        return unsafe.getAndAddInt(this.staticFieldBase, this.fieldOffset, value);
    }

    public final long getAndAdd(long value) {
        this.checkStatic(Long.TYPE);
        return unsafe.getAndAddLong(this.staticFieldBase, this.fieldOffset, value);
    }

    public final float getAndAdd(float value) {
        float v;
        this.checkStatic(Float.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, Float.floatToRawIntBits(v = unsafe.getFloat(this.staticFieldBase, this.fieldOffset)), Float.floatToRawIntBits(v + value))) {
        }
        return v;
    }

    public final double getAndAdd(double value) {
        double v;
        this.checkStatic(Double.TYPE);
        while (!unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, Double.doubleToRawLongBits(v = unsafe.getDouble(this.staticFieldBase, this.fieldOffset)), Double.doubleToRawLongBits(v + value))) {
        }
        return v;
    }

    public final byte getAndAdd(Object owner, byte value) {
        byte v;
        this.checkOwner(owner, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getByte(owner, this.fieldOffset), v + value)) {
        }
        return v;
    }

    public final char getAndAdd(Object owner, char value) {
        char v;
        this.checkOwner(owner, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getChar(owner, this.fieldOffset), v + value)) {
        }
        return v;
    }

    public final short getAndAdd(Object owner, short value) {
        short v;
        this.checkOwner(owner, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getShort(owner, this.fieldOffset), v + value)) {
        }
        return v;
    }

    public final int getAndAdd(Object owner, int value) {
        this.checkOwner(owner, Integer.TYPE);
        return unsafe.getAndAddInt(owner, this.fieldOffset, value);
    }

    public final long getAndAdd(Object owner, long value) {
        this.checkOwner(owner, Long.TYPE);
        return unsafe.getAndAddLong(owner, this.fieldOffset, value);
    }

    public final float getAndAdd(Object owner, float value) {
        float v;
        this.checkOwner(owner, Float.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, Float.floatToRawIntBits(v = unsafe.getFloat(owner, this.fieldOffset)), Float.floatToRawIntBits(v + value))) {
        }
        return v;
    }

    public final double getAndAdd(Object owner, double value) {
        double v;
        this.checkOwner(owner, Double.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset, Double.doubleToRawLongBits(v = unsafe.getDouble(owner, this.fieldOffset)), Double.doubleToRawLongBits(v + value))) {
        }
        return v;
    }

    public final byte getAndAdd(Object owner, int index, byte value) {
        byte v;
        this.checkArray(owner, index, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getByte(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v + value)) {
        }
        return v;
    }

    public final char getAndAdd(Object owner, int index, char value) {
        char v;
        this.checkArray(owner, index, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getChar(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v + value)) {
        }
        return v;
    }

    public final short getAndAdd(Object owner, int index, short value) {
        short v;
        this.checkArray(owner, index, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getShort(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v + value)) {
        }
        return v;
    }

    public final int getAndAdd(Object owner, int index, int value) {
        this.checkArray(owner, index, Integer.TYPE);
        return unsafe.getAndAddInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final long getAndAdd(Object owner, int index, long value) {
        this.checkArray(owner, index, Long.TYPE);
        return unsafe.getAndAddLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, value);
    }

    public final float getAndAdd(Object owner, int index, float value) {
        float v;
        this.checkArray(owner, index, Float.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Float.floatToRawIntBits(v = unsafe.getFloat(owner, this.fieldOffset + (long)index * this.arrayIndexScale)), Float.floatToRawIntBits(v + value))) {
        }
        return v;
    }

    public final double getAndAdd(Object owner, int index, double value) {
        double v;
        this.checkArray(owner, index, Double.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, Double.doubleToRawLongBits(v = unsafe.getDouble(owner, this.fieldOffset + (long)index * this.arrayIndexScale)), Double.doubleToRawLongBits(v + value))) {
        }
        return v;
    }

    public final byte getAndAddAcquire(byte value) {
        byte v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndAddAcquire(char value) {
        char v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndAddAcquire(short value) {
        short v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndAddAcquire(int value) {
        int v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndAddAcquire(long value) {
        long v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final float getAndAddAcquire(float value) {
        float v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final double getAndAddAcquire(double value) {
        double v = this.getAndAdd(value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndAddAcquire(Object owner, byte value) {
        byte v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndAddAcquire(Object owner, char value) {
        char v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndAddAcquire(Object owner, short value) {
        short v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndAddAcquire(Object owner, int value) {
        int v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndAddAcquire(Object owner, long value) {
        long v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final float getAndAddAcquire(Object owner, float value) {
        float v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final double getAndAddAcquire(Object owner, double value) {
        double v = this.getAndAdd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndAddAcquire(Object owner, int index, byte value) {
        byte v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndAddAcquire(Object owner, int index, char value) {
        char v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndAddAcquire(Object owner, int index, short value) {
        short v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndAddAcquire(Object owner, int index, int value) {
        int v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndAddAcquire(Object owner, int index, long value) {
        long v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final float getAndAddAcquire(Object owner, int index, float value) {
        float v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final double getAndAddAcquire(Object owner, int index, double value) {
        double v = this.getAndAdd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndAddRelease(byte value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final char getAndAddRelease(char value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final short getAndAddRelease(short value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final int getAndAddRelease(int value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final long getAndAddRelease(long value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final float getAndAddRelease(float value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final double getAndAddRelease(double value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final byte getAndAddRelease(Object owner, byte value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, value);
    }

    public final char getAndAddRelease(Object owner, char value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, value);
    }

    public final short getAndAddRelease(Object owner, short value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, value);
    }

    public final int getAndAddRelease(Object owner, int value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final long getAndAddRelease(Object owner, long value) {
        unsafe.fullFence();
        return this.getAndAdd(value);
    }

    public final float getAndAddRelease(Object owner, float value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, value);
    }

    public final double getAndAddRelease(Object owner, double value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, value);
    }

    public final byte getAndAddRelease(Object owner, int index, byte value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final char getAndAddRelease(Object owner, int index, char value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final short getAndAddRelease(Object owner, int index, short value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final int getAndAddRelease(Object owner, int index, int value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final long getAndAddRelease(Object owner, int index, long value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final float getAndAddRelease(Object owner, int index, float value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final double getAndAddRelease(Object owner, int index, double value) {
        unsafe.fullFence();
        return this.getAndAdd(owner, index, value);
    }

    public final boolean getAndBitwiseOr(boolean value) {
        int v;
        this.checkStatic(Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), value || (byte)v != 0 ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseOr(byte value) {
        int v;
        this.checkStatic(Byte.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v | value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseOr(char value) {
        int v;
        this.checkStatic(Character.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v | value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseOr(short value) {
        int v;
        this.checkStatic(Short.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v | value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseOr(int value) {
        int v;
        this.checkStatic(Integer.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v | value)) {
        }
        return v;
    }

    public final long getAndBitwiseOr(long value) {
        long v;
        this.checkStatic(Long.TYPE);
        while (!unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, v = unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset), v | value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseOr(Object owner, boolean value) {
        int v;
        this.checkOwner(owner, Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), value || (byte)v != 0 ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseOr(Object owner, byte value) {
        int v;
        this.checkOwner(owner, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v | value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseOr(Object owner, char value) {
        int v;
        this.checkOwner(owner, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v | value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseOr(Object owner, short value) {
        int v;
        this.checkOwner(owner, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v | value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseOr(Object owner, int value) {
        int v;
        this.checkOwner(owner, Integer.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v | value)) {
        }
        return v;
    }

    public final long getAndBitwiseOr(Object owner, long value) {
        long v;
        this.checkOwner(owner, Long.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset, v = unsafe.getLongVolatile(owner, this.fieldOffset), v | value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseOr(Object owner, int index, boolean value) {
        int v;
        this.checkArray(owner, index, Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), (byte)v != 0 || value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseOr(Object owner, int index, byte value) {
        int v;
        this.checkArray(owner, index, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v | value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseOr(Object owner, int index, char value) {
        int v;
        this.checkArray(owner, index, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v | value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseOr(Object owner, int index, short value) {
        int v;
        this.checkArray(owner, index, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v | value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseOr(Object owner, int index, int value) {
        int v;
        this.checkArray(owner, index, Integer.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v | value)) {
        }
        return v;
    }

    public final long getAndBitwiseOr(Object owner, int index, long value) {
        long v;
        this.checkArray(owner, index, Long.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v | value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseOrAcquire(boolean value) {
        boolean v = this.getAndBitwiseOr(value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseOrAcquire(byte value) {
        byte v = this.getAndBitwiseOr(value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseOrAcquire(char value) {
        char v = this.getAndBitwiseOr(value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseOrAcquire(short value) {
        short v = this.getAndBitwiseOr(value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseOrAcquire(int value) {
        int v = this.getAndBitwiseOr(value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseOrAcquire(long value) {
        long v = this.getAndBitwiseOr(value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseOrAcquire(Object owner, boolean value) {
        boolean v = this.getAndBitwiseOr(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseOrAcquire(Object owner, byte value) {
        byte v = this.getAndBitwiseOr(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseOrAcquire(Object owner, char value) {
        char v = this.getAndBitwiseOr(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseOrAcquire(Object owner, short value) {
        short v = this.getAndBitwiseOr(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseOrAcquire(Object owner, int value) {
        int v = this.getAndBitwiseOr(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseOrAcquire(Object owner, long value) {
        long v = this.getAndBitwiseOr(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseOrAcquire(Object owner, int index, boolean value) {
        boolean v = this.getAndBitwiseOr(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseOrAcquire(Object owner, int index, byte value) {
        byte v = this.getAndBitwiseOr(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseOrAcquire(Object owner, int index, char value) {
        char v = this.getAndBitwiseOr(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseOrAcquire(Object owner, int index, short value) {
        short v = this.getAndBitwiseOr(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseOrAcquire(Object owner, int index, int value) {
        int v = this.getAndBitwiseOr(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseOrAcquire(Object owner, int index, long value) {
        long v = this.getAndBitwiseOr(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseOrRelease(boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(value);
    }

    public final byte getAndBitwiseOrRelease(byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(value);
    }

    public final short getAndBitwiseOrRelease(short value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(value);
    }

    public final char getAndBitwiseOrRelease(char value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(value);
    }

    public final int getAndBitwiseOrRelease(int value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(value);
    }

    public final long getAndBitwiseOrRelease(long value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(value);
    }

    public final boolean getAndBitwiseOrRelease(Object owner, boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, value);
    }

    public final byte getAndBitwiseOrRelease(Object owner, byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, value);
    }

    public final char getAndBitwiseOrRelease(Object owner, char value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, value);
    }

    public final short getAndBitwiseOrRelease(Object owner, short value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, value);
    }

    public final int getAndBitwiseOrRelease(Object owner, int value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, value);
    }

    public final long getAndBitwiseOrRelease(Object owner, long value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, value);
    }

    public final boolean getAndBitwiseOrRelease(Object owner, int index, boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, index, value);
    }

    public final byte getAndBitwiseOrRelease(Object owner, int index, byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, index, value);
    }

    public final char getAndBitwiseOrRelease(Object owner, int index, char value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, index, value);
    }

    public final short getAndBitwiseOrRelease(Object owner, int index, short value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, index, value);
    }

    public final int getAndBitwiseOrRelease(Object owner, int index, int value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, index, value);
    }

    public final long getAndBitwiseOrRelease(Object owner, int index, long value) {
        unsafe.fullFence();
        return this.getAndBitwiseOr(owner, index, value);
    }

    public final boolean getAndBitwiseAnd(boolean value) {
        int v;
        this.checkStatic(Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, (byte)(v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) != 0 && value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseAnd(byte value) {
        int v;
        this.checkStatic(Byte.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v & value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseAnd(char value) {
        int v;
        this.checkStatic(Character.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v & value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseAnd(short value) {
        int v;
        this.checkStatic(Short.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v & value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseAnd(int value) {
        int v;
        this.checkStatic(Integer.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v & value)) {
        }
        return v;
    }

    public final long getAndBitwiseAnd(long value) {
        long v;
        this.checkStatic(Long.TYPE);
        while (!unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, v = unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset), v & value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseAnd(Object owner, boolean value) {
        int v;
        this.checkOwner(owner, Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, (byte)(v = unsafe.getIntVolatile(owner, this.fieldOffset)) != 0 && value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseAnd(Object owner, byte value) {
        int v;
        this.checkOwner(owner, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v & value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseAnd(Object owner, char value) {
        int v;
        this.checkOwner(owner, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v & value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseAnd(Object owner, short value) {
        int v;
        this.checkOwner(owner, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v & value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseAnd(Object owner, int value) {
        int v;
        this.checkOwner(owner, Integer.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v & value)) {
        }
        return v;
    }

    public final long getAndBitwiseAnd(Object owner, long value) {
        long v;
        this.checkOwner(owner, Long.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset, v = unsafe.getLongVolatile(owner, this.fieldOffset), v & value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseAnd(Object owner, int index, boolean value) {
        int v;
        this.checkArray(owner, index, Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), (byte)v != 0 && value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseAnd(Object owner, int index, byte value) {
        int v;
        this.checkArray(owner, index, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v & value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseAnd(Object owner, int index, char value) {
        int v;
        this.checkArray(owner, index, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v & value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseAnd(Object owner, int index, short value) {
        int v;
        this.checkArray(owner, index, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v & value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseAnd(Object owner, int index, int value) {
        int v;
        this.checkArray(owner, index, Integer.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v & value)) {
        }
        return v;
    }

    public final long getAndBitwiseAnd(Object owner, int index, long value) {
        long v;
        this.checkArray(owner, index, Long.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v & value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseAndAcquire(boolean value) {
        boolean v = this.getAndBitwiseAnd(value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseAndAcquire(byte value) {
        byte v = this.getAndBitwiseAnd(value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseAndAcquire(char value) {
        char v = this.getAndBitwiseAnd(value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseAndAcquire(short value) {
        short v = this.getAndBitwiseAnd(value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseAndAcquire(int value) {
        int v = this.getAndBitwiseAnd(value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseAndAcquire(long value) {
        long v = this.getAndBitwiseAnd(value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseAndAcquire(Object owner, boolean value) {
        boolean v = this.getAndBitwiseAnd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseAndAcquire(Object owner, byte value) {
        byte v = this.getAndBitwiseAnd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseAndAcquire(Object owner, char value) {
        char v = this.getAndBitwiseAnd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseAndAcquire(Object owner, short value) {
        short v = this.getAndBitwiseAnd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseAndAcquire(Object owner, int value) {
        int v = this.getAndBitwiseAnd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseAndAcquire(Object owner, long value) {
        long v = this.getAndBitwiseAnd(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseAndAcquire(Object owner, int index, boolean value) {
        boolean v = this.getAndBitwiseAnd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseAndAcquire(Object owner, int index, byte value) {
        byte v = this.getAndBitwiseAnd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseAndAcquire(Object owner, int index, char value) {
        char v = this.getAndBitwiseAnd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseAndAcquire(Object owner, int index, short value) {
        short v = this.getAndBitwiseAnd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseAndAcquire(Object owner, int index, int value) {
        int v = this.getAndBitwiseAnd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseAndAcquire(Object owner, int index, long value) {
        long v = this.getAndBitwiseAnd(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseAndRelease(boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(value);
    }

    public final byte getAndBitwiseAndRelease(byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(value);
    }

    public final char getAndBitwiseAndRelease(char value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(value);
    }

    public final short getAndBitwiseAndRelease(short value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(value);
    }

    public final int getAndBitwiseAndRelease(int value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(value);
    }

    public final long getAndBitwiseAndRelease(long value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(value);
    }

    public final boolean getAndBitwiseAndRelease(Object owner, boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, value);
    }

    public final byte getAndBitwiseAndRelease(Object owner, byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, value);
    }

    public final char getAndBitwiseAndRelease(Object owner, char value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, value);
    }

    public final short getAndBitwiseAndRelease(Object owner, short value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, value);
    }

    public final int getAndBitwiseAndRelease(Object owner, int value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, value);
    }

    public final long getAndBitwiseAndRelease(Object owner, long value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, value);
    }

    public final boolean getAndBitwiseAndRelease(Object owner, int index, boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, index, value);
    }

    public final byte getAndBitwiseAndRelease(Object owner, int index, byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, index, value);
    }

    public final char getAndBitwiseAndRelease(Object owner, int index, char value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, index, value);
    }

    public final short getAndBitwiseAndRelease(Object owner, int index, short value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, index, value);
    }

    public final int getAndBitwiseAndRelease(Object owner, int index, int value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, index, value);
    }

    public final long getAndBitwiseAndRelease(Object owner, int index, long value) {
        unsafe.fullFence();
        return this.getAndBitwiseAnd(owner, index, value);
    }

    public final boolean getAndBitwiseXor(boolean value) {
        int v;
        this.checkStatic(Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v, (byte)(v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset)) != 0 ^ value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseXor(byte value) {
        int v;
        this.checkStatic(Byte.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v ^ value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseXor(char value) {
        int v;
        this.checkStatic(Character.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v ^ value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseXor(short value) {
        int v;
        this.checkStatic(Short.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v ^ value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseXor(int value) {
        int v;
        this.checkStatic(Integer.TYPE);
        while (!unsafe.compareAndSwapInt(this.staticFieldBase, this.fieldOffset, v = unsafe.getIntVolatile(this.staticFieldBase, this.fieldOffset), v ^ value)) {
        }
        return v;
    }

    public final long getAndBitwiseXor(long value) {
        long v;
        this.checkStatic(Long.TYPE);
        while (!unsafe.compareAndSwapLong(this.staticFieldBase, this.fieldOffset, v = unsafe.getLongVolatile(this.staticFieldBase, this.fieldOffset), v ^ value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseXor(Object owner, boolean value) {
        int v;
        this.checkOwner(owner, Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v, (byte)(v = unsafe.getIntVolatile(owner, this.fieldOffset)) != 0 ^ value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseXor(Object owner, byte value) {
        int v;
        this.checkOwner(owner, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v ^ value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseXor(Object owner, char value) {
        int v;
        this.checkOwner(owner, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v ^ value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseXor(Object owner, short value) {
        int v;
        this.checkOwner(owner, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v ^ value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseXor(Object owner, int value) {
        int v;
        this.checkOwner(owner, Integer.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset, v = unsafe.getIntVolatile(owner, this.fieldOffset), v ^ value)) {
        }
        return v;
    }

    public final long getAndBitwiseXor(Object owner, long value) {
        long v;
        this.checkOwner(owner, Long.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset, v = unsafe.getLongVolatile(owner, this.fieldOffset), v ^ value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseXor(Object owner, int index, boolean value) {
        int v;
        this.checkArray(owner, index, Boolean.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), (byte)v != 0 ^ value ? 1 : 0)) {
        }
        return (byte)v != 0;
    }

    public final byte getAndBitwiseXor(Object owner, int index, byte value) {
        int v;
        this.checkArray(owner, index, Byte.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v ^ value)) {
        }
        return (byte)v;
    }

    public final char getAndBitwiseXor(Object owner, int index, char value) {
        int v;
        this.checkArray(owner, index, Character.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v ^ value)) {
        }
        return (char)v;
    }

    public final short getAndBitwiseXor(Object owner, int index, short value) {
        int v;
        this.checkArray(owner, index, Short.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v ^ value)) {
        }
        return (short)v;
    }

    public final int getAndBitwiseXor(Object owner, int index, int value) {
        int v;
        this.checkArray(owner, index, Integer.TYPE);
        while (!unsafe.compareAndSwapInt(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getIntVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v ^ value)) {
        }
        return v;
    }

    public final long getAndBitwiseXor(Object owner, int index, long value) {
        long v;
        this.checkArray(owner, index, Long.TYPE);
        while (!unsafe.compareAndSwapLong(owner, this.fieldOffset + (long)index * this.arrayIndexScale, v = unsafe.getLongVolatile(owner, this.fieldOffset + (long)index * this.arrayIndexScale), v ^ value)) {
        }
        return v;
    }

    public final boolean getAndBitwiseXorAcquire(boolean value) {
        boolean v = this.getAndBitwiseXor(value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseXorAcquire(byte value) {
        byte v = this.getAndBitwiseXor(value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseXorAcquire(char value) {
        char v = this.getAndBitwiseXor(value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseXorAcquire(short value) {
        short v = this.getAndBitwiseXor(value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseXorAcquire(int value) {
        int v = this.getAndBitwiseXor(value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseXorAcquire(long value) {
        long v = this.getAndBitwiseXor(value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseXorAcquire(Object owner, boolean value) {
        boolean v = this.getAndBitwiseXor(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseXorAcquire(Object owner, byte value) {
        byte v = this.getAndBitwiseXor(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseXorAcquire(Object owner, char value) {
        char v = this.getAndBitwiseXor(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseXorAcquire(Object owner, short value) {
        short v = this.getAndBitwiseXor(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseXorAcquire(Object owner, int value) {
        int v = this.getAndBitwiseXor(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseXorAcquire(Object owner, long value) {
        long v = this.getAndBitwiseXor(owner, value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseXorAcquire(Object owner, int index, boolean value) {
        boolean v = this.getAndBitwiseXor(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final byte getAndBitwiseXorAcquire(Object owner, int index, byte value) {
        byte v = this.getAndBitwiseXor(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final char getAndBitwiseXorAcquire(Object owner, int index, char value) {
        char v = this.getAndBitwiseXor(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final short getAndBitwiseXorAcquire(Object owner, int index, short value) {
        short v = this.getAndBitwiseXor(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final int getAndBitwiseXorAcquire(Object owner, int index, int value) {
        int v = this.getAndBitwiseXor(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final long getAndBitwiseXorAcquire(Object owner, int index, long value) {
        long v = this.getAndBitwiseXor(owner, index, value);
        unsafe.fullFence();
        return v;
    }

    public final boolean getAndBitwiseXorRelease(boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(value);
    }

    public final byte getAndBitwiseXorRelease(byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(value);
    }

    public final short getAndBitwiseXorRelease(short value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(value);
    }

    public final char getAndBitwiseXorRelease(char value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(value);
    }

    public final int getAndBitwiseXorRelease(int value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(value);
    }

    public final long getAndBitwiseXorRelease(long value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(value);
    }

    public final boolean getAndBitwiseXorRelease(Object owner, boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, value);
    }

    public final byte getAndBitwiseXorRelease(Object owner, byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, value);
    }

    public final char getAndBitwiseXorRelease(Object owner, char value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, value);
    }

    public final short getAndBitwiseXorRelease(Object owner, short value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, value);
    }

    public final int getAndBitwiseXorRelease(Object owner, int value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, value);
    }

    public final long getAndBitwiseXorRelease(Object owner, long value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, value);
    }

    public final boolean getAndBitwiseXorRelease(Object owner, int index, boolean value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, index, value);
    }

    public final byte getAndBitwiseXorRelease(Object owner, int index, byte value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, index, value);
    }

    public final char getAndBitwiseXorRelease(Object owner, int index, char value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, index, value);
    }

    public final short getAndBitwiseXorRelease(Object owner, int index, short value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, index, value);
    }

    public final int getAndBitwiseXorRelease(Object owner, int index, int value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, index, value);
    }

    public final long getAndBitwiseXorRelease(Object owner, int index, long value) {
        unsafe.fullFence();
        return this.getAndBitwiseXor(owner, index, value);
    }

    public final MethodHandle toMethodHandle(AccessMode accessMode) throws NoSuchMethodException, IllegalAccessException {
        MethodType vmt;
        MethodType mt;
        Class<?> vt = this.field.getType();
        Class t = this.field.getType().isPrimitive() ? this.field.getType() : Object.class;
        switch (accessMode.accessType) {
            case GET: {
                if (this.isStatic) {
                    mt = MethodType.methodType(t);
                    vmt = MethodType.methodType(vt);
                    break;
                }
                if (this.isArray) {
                    mt = MethodType.methodType(t, Object.class, Integer.TYPE);
                    vmt = MethodType.methodType(vt, this.ownerClass, Integer.TYPE);
                    break;
                }
                mt = MethodType.methodType(t, Object.class);
                vmt = MethodType.methodType(vt, this.ownerClass);
                break;
            }
            case SET: {
                if (this.isStatic) {
                    mt = MethodType.methodType(Void.TYPE, t);
                    vmt = MethodType.methodType(Void.TYPE, vt);
                    break;
                }
                if (this.isArray) {
                    mt = MethodType.methodType(Void.TYPE, Object.class, Integer.TYPE, t);
                    vmt = MethodType.methodType(Void.TYPE, this.ownerClass, Integer.TYPE, vt);
                    break;
                }
                mt = MethodType.methodType(Void.TYPE, Object.class, t);
                vmt = MethodType.methodType(Void.TYPE, this.ownerClass, vt);
                break;
            }
            case COMPARE_AND_SET: {
                if (this.isStatic) {
                    mt = MethodType.methodType(Boolean.TYPE, t, t);
                    vmt = MethodType.methodType(Boolean.TYPE, vt, vt);
                    break;
                }
                if (this.isArray) {
                    mt = MethodType.methodType(Boolean.TYPE, Object.class, Integer.TYPE, t, t);
                    vmt = MethodType.methodType(Boolean.TYPE, this.ownerClass, Integer.TYPE, vt, vt);
                    break;
                }
                mt = MethodType.methodType(Boolean.TYPE, Object.class, t, t);
                vmt = MethodType.methodType(Boolean.TYPE, this.ownerClass, vt, vt);
                break;
            }
            case COMPARE_AND_EXCHANGE: {
                if (this.isStatic) {
                    mt = MethodType.methodType(t, t, t);
                    vmt = MethodType.methodType(vt, vt, vt);
                    break;
                }
                if (this.isArray) {
                    mt = MethodType.methodType(t, Object.class, Integer.TYPE, t, t);
                    vmt = MethodType.methodType(vt, this.ownerClass, Integer.TYPE, vt, vt);
                    break;
                }
                mt = MethodType.methodType(t, Object.class, t, t);
                vmt = MethodType.methodType(vt, this.ownerClass, vt, vt);
                break;
            }
            case GET_AND_UPDATE: {
                if (this.isStatic) {
                    mt = MethodType.methodType(t, t);
                    vmt = MethodType.methodType(vt, vt);
                    break;
                }
                if (this.isArray) {
                    mt = MethodType.methodType(t, Object.class, Integer.TYPE, t);
                    vmt = MethodType.methodType(vt, this.ownerClass, Integer.TYPE, vt);
                    break;
                }
                mt = MethodType.methodType(t, Object.class, t);
                vmt = MethodType.methodType(vt, this.ownerClass, vt);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return lookup.findVirtual(J_L_I_VarHandle.class, J_L_I_VarHandle.fixMethodName(accessMode.methodName(), Utils.getDescForClass(this.field.getType())), mt).bindTo(this).asType(vmt);
    }

    public static void fullFence() {
        unsafe.fullFence();
    }

    public static void acquireFence() {
        unsafe.loadFence();
    }

    public static void releaseFence() {
        unsafe.storeFence();
    }

    public static void loadLoadFence() {
        unsafe.loadFence();
    }

    public static void storeStoreFence() {
        unsafe.storeFence();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/invoke/VarHandle$AccessMode")
    public static enum AccessMode {
        GET("get", AccessType.GET),
        SET("set", AccessType.SET),
        GET_VOLATILE("getVolatile", AccessType.GET),
        SET_VOLATILE("setVolatile", AccessType.SET),
        GET_ACQUIRE("getAcquire", AccessType.GET),
        SET_RELEASE("setRelease", AccessType.SET),
        GET_OPAQUE("getOpaque", AccessType.GET),
        SET_OPAQUE("setOpaque", AccessType.SET),
        COMPARE_AND_SET("compareAndSet", AccessType.COMPARE_AND_SET),
        COMPARE_AND_EXCHANGE("compareAndExchange", AccessType.COMPARE_AND_EXCHANGE),
        COMPARE_AND_EXCHANGE_ACQUIRE("compareAndExchangeAcquire", AccessType.COMPARE_AND_EXCHANGE),
        COMPARE_AND_EXCHANGE_RELEASE("compareAndExchangeRelease", AccessType.COMPARE_AND_EXCHANGE),
        WEAK_COMPARE_AND_SET_PLAIN("compareAndSetPlain", AccessType.COMPARE_AND_SET),
        WEAK_COMPARE_AND_SET("compareAndSet", AccessType.COMPARE_AND_SET),
        WEAK_COMPARE_AND_SET_ACQUIRE("compareAndSetAcquire", AccessType.COMPARE_AND_SET),
        WEAK_COMPARE_AND_SET_RELEASE("compareAndSetRelease", AccessType.COMPARE_AND_SET),
        GET_AND_SET("getAndSet", AccessType.GET_AND_UPDATE),
        GET_AND_SET_ACQUIRE("getAndSetAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_SET_RELEASE("getAndSetRelease", AccessType.GET_AND_UPDATE),
        GET_AND_ADD("getAndAdd", AccessType.GET_AND_UPDATE),
        GET_AND_ADD_ACQUIRE("getAndAddAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_ADD_RELEASE("getAndAddRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_OR("getAndBitwiseOr", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_OR_RELEASE("getAndBitwiseOrRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_OR_ACQUIRE("getAndBitwiseOrAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_AND("getAndBitwiseAnd", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_AND_RELEASE("getAndBitwiseAndRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_AND_ACQUIRE("getAndBitwiseAndAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_XOR("getAndBitwiseXor", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_XOR_RELEASE("getAndBitwiseXorRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_XOR_ACQUIRE("getAndBitwiseXorAcquire", AccessType.GET_AND_UPDATE);

        static final Map<String, AccessMode> byName;
        final String methodName;
        final AccessType accessType;

        private AccessMode(String methodName, AccessType at) {
            this.methodName = methodName;
            this.accessType = at;
        }

        public String methodName() {
            return this.methodName;
        }

        public static AccessMode valueFromMethodName(String methodName) {
            AccessMode am = byName.get(methodName);
            if (am == null) {
                throw new IllegalArgumentException("No AccessMode value for method name " + methodName);
            }
            return am;
        }

        static {
            byName = new HashMap<String, AccessMode>();
            for (AccessMode value : AccessMode.values()) {
                byName.put(value.methodName(), value);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/invoke/VarHandle$AccessType")
    public static enum AccessType {
        GET,
        SET,
        COMPARE_AND_SET,
        COMPARE_AND_EXCHANGE,
        GET_AND_UPDATE;

    }
}

