/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Module;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Modify;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_ClassLoader {
    private static final Map<ClassLoader, String> nameMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<ClassLoader, J_L_Module> unnamedModuleMap = Collections.synchronizedMap(new WeakHashMap());
    private static final MethodHandles.Lookup IMPL_LOOKUP = Utils.getImplLookup();
    private static final MethodHandle IS_REGISTERED;

    @Modify(ref=@Ref(value="Ljava/lang/ClassLoader;", member="<init>", desc="(Ljava/lang/String;Ljava/lang/ClassLoader;)V"))
    public static void init(MethodNode mnode, int i) {
        MethodInsnNode node = (MethodInsnNode)mnode.instructions.get(i);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new InsnNode(95));
        list.add((AbstractInsnNode)new InsnNode(91));
        list.add((AbstractInsnNode)new InsnNode(87));
        list.add((AbstractInsnNode)new InsnNode(92));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/ClassLoader", "<init>", "(Ljava/lang/ClassLoader;)V", false));
        list.add((AbstractInsnNode)new InsnNode(87));
        list.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(J_L_ClassLoader.class), "setClassloaderName", "(Ljava/lang/String;Ljava/lang/ClassLoader;)V", false));
        mnode.instructions.insert((AbstractInsnNode)node, list);
        mnode.instructions.remove((AbstractInsnNode)node);
    }

    public static void setClassloaderName(String name, ClassLoader classLoader) {
        if (name != null && name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-empty or null");
        }
        nameMap.put(classLoader, name);
    }

    @Stub
    public static String getName(ClassLoader classLoader) {
        return nameMap.get(classLoader);
    }

    @Stub
    public static J_L_Module getUnnamedModule(ClassLoader classLoader) {
        return unnamedModuleMap.computeIfAbsent(classLoader, J_L_Module::new);
    }

    @Stub(ref=@Ref(value="Ljava/lang/ClassLoader;"))
    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    @Stub
    public static boolean isRegisteredAsParallelCapable(ClassLoader loader) throws Throwable {
        return IS_REGISTERED.invokeExact(loader.getClass());
    }

    static {
        try {
            Class<?> parallelLoaders = Class.forName("java.lang.ClassLoader$ParallelLoaders");
            IS_REGISTERED = IMPL_LOOKUP.findStatic(parallelLoaders, "isRegistered", MethodType.methodType(Boolean.TYPE, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

