/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_I_InputStream {
    @Stub
    public static byte[] readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    @Stub
    public static int readNBytes(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int read;
        J_U_Objects.checkFromIndexSize(off, len, b.length);
        for (total = 0; total < len && (read = in.read(b, off + total, len - total)) != -1; total += read) {
        }
        return total;
    }

    @Stub
    public static long transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }
}

