/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.intl.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_M_ModuleDescriptor;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Module;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_ModuleLayer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ModuleConstantHelper {
    private static final Map<String, J_L_Module> MODULES = new HashMap<String, J_L_Module>();
    public static final J_L_ModuleLayer BOOT_LAYER = new J_L_ModuleLayer(Collections.emptyList(), MODULES);
    private static final Map<String, J_L_Module> MODULES_FROM_PACKAGE = new HashMap<String, J_L_Module>();
    private static final ClassLoader ORIGINAL_SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();

    private static void registerBootModule(String name, String ... packages) {
        J_L_M_ModuleDescriptor descriptor = new J_L_M_ModuleDescriptor.Builder(name, false, Collections.emptySet()).packages(new HashSet<String>(Arrays.asList(packages))).build();
        J_L_Module module = new J_L_Module(ORIGINAL_SYSTEM_CLASS_LOADER, BOOT_LAYER, descriptor);
        MODULES.put(name, module);
        for (String packageName : packages) {
            MODULES_FROM_PACKAGE.put(packageName, module);
        }
    }

    public static J_L_Module bootModuleFromClass(Class<?> clazz) {
        boolean bootClassLoader = clazz.getClassLoader() == null;
        if (bootClassLoader || clazz.getClassLoader() == ORIGINAL_SYSTEM_CLASS_LOADER) {
            J_L_Module module = ModuleConstantHelper.bootModuleFromClassName(clazz.getName());
            if (module == null && bootClassLoader) {
                return MODULES.get("java.base");
            }
            return module;
        }
        return null;
    }

    public static J_L_Module bootModuleFromClassName(String className) {
        int pkgEnd;
        J_L_Module module;
        String packageName = className;
        do {
            if ((pkgEnd = packageName.lastIndexOf(46)) != -1) continue;
            return null;
        } while ((module = MODULES_FROM_PACKAGE.get(packageName = packageName.substring(0, pkgEnd))) == null);
        return module;
    }

    static {
        ModuleConstantHelper.registerBootModule("java.base", "java.io", "java.lang", "java.math", "java.net", "java.nio", "java.security", "java.text", "java.time", "java.util", "javax.crypto", "javax.net", "javax.security");
        ModuleConstantHelper.registerBootModule("java.logging", "java.util.logging");
        ModuleConstantHelper.registerBootModule("java.net.http", "java.net.http");
        ModuleConstantHelper.registerBootModule("jdk.httpserver", "com.sun.net.httpserver");
        ModuleConstantHelper.registerBootModule("jdk.jfr", "jdk.jfr");
    }
}

