/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.intl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.exc.MissingStubError;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_ProcessHandle;
import xyz.wagyourtail.jvmdg.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WindowsProcessHandle
implements J_L_ProcessHandle {
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final MethodHandle waitForProcessExit;
    private static final MethodHandle terminateProcess;
    private static final MethodHandle isProcessAlive;
    public static final String wmicLocation;
    private final long pid;
    private final Map<String, String> info;
    private final String[] commandLine;
    private static final Pattern USER_NAME;

    public WindowsProcessHandle(long pid) {
        this.pid = pid;
        this.info = this.readInfo();
        this.commandLine = this.parseCommandLine();
    }

    public Map<String, String> readInfo() {
        try {
            HashMap<String, String> info = new HashMap<String, String>();
            ProcessBuilder pb = new ProcessBuilder(wmicLocation, "process", "where", "ProcessID=" + this.pid, "get", "/format:list");
            Process p = pb.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                br.lines().forEach(e -> {
                    if (e.isEmpty() || !e.contains("=")) {
                        return;
                    }
                    String[] line = e.split("=", 2);
                    info.put(line[0], line[1]);
                });
            }
            return info;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public String[] parseCommandLine() {
        ArrayList<String> processed = new ArrayList<String>();
        String cmd = this.info.getOrDefault("CommandLine", "").trim();
        int i = 0;
        while (i < cmd.length()) {
            int next;
            char c = cmd.charAt(i);
            if (c == ' ') {
                ++i;
                continue;
            }
            if (c == '\"' || c == '\'') {
                next = cmd.indexOf(c, i);
                processed.add(cmd.substring(i, next).replace("\\" + c, String.valueOf(c)));
            } else {
                next = cmd.indexOf(32, i);
                if (next == -1) {
                    next = cmd.length();
                }
                processed.add(cmd.substring(i, next));
            }
            i = next + 1;
        }
        return processed.toArray(new String[0]);
    }

    @Override
    public long pid() {
        return this.pid;
    }

    @Override
    public Optional<J_L_ProcessHandle> parent() {
        String parent = this.info.get("ParentProcessId");
        if (parent == null || parent.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new WindowsProcessHandle(Long.parseLong(parent.trim())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Stream<J_L_ProcessHandle> children() {
        try {
            ProcessBuilder pb = new ProcessBuilder(wmicLocation, "process", "where", "ParentProcessID=" + this.pid, "get", "ProcessId");
            Process p = pb.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                Stream<J_L_ProcessHandle> stream = Stream.of(br.lines().skip(1L).filter(e -> !e.isEmpty()).map(e -> new WindowsProcessHandle(Long.parseLong(e.trim()))).toArray(J_L_ProcessHandle[]::new));
                return stream;
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @Override
    public Stream<J_L_ProcessHandle> descendants() {
        return this.children().flatMap(e -> Stream.concat(Stream.of(e), e.descendants()));
    }

    @Override
    public J_L_ProcessHandle.Info info() {
        return new J_L_ProcessHandle.Info(){

            @Override
            public Optional<String> command() {
                String s = (String)WindowsProcessHandle.this.info.get("ExecutablePath");
                if (s == null || s.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(s.trim());
            }

            @Override
            public Optional<String> commandLine() {
                String s = (String)WindowsProcessHandle.this.info.get("CommandLine");
                if (s == null || s.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(s.trim());
            }

            @Override
            public Optional<String[]> arguments() {
                if (WindowsProcessHandle.this.commandLine != null) {
                    if (WindowsProcessHandle.this.commandLine.length < 1) {
                        return Optional.of(new String[0]);
                    }
                    String[] args = new String[WindowsProcessHandle.this.commandLine.length - 1];
                    System.arraycopy(WindowsProcessHandle.this.commandLine, 1, args, 0, WindowsProcessHandle.this.commandLine.length - 1);
                    return Optional.of(args);
                }
                return Optional.empty();
            }

            @Override
            public Optional<Instant> startInstant() {
                String s = (String)WindowsProcessHandle.this.info.get("CreationDate");
                if (s == null || s.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(Instant.parse(s.trim()));
            }

            @Override
            public Optional<Duration> totalCpuDuration() {
                String a = WindowsProcessHandle.this.info.getOrDefault("KernelModeTime", "0").trim();
                String b = WindowsProcessHandle.this.info.getOrDefault("UserModeTime", "0").trim();
                if (a.isEmpty()) {
                    a = "0";
                }
                if (b.isEmpty()) {
                    b = "0";
                }
                return Optional.of(Duration.ofMillis(Long.parseLong(a) + Long.parseLong(b)));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Optional<String> user() {
                try {
                    ProcessBuilder pb = new ProcessBuilder(wmicLocation, "process", "where", "ProcessID=" + WindowsProcessHandle.this.pid, "call", "GetOwner");
                    Process p = pb.start();
                    try (InputStream is = p.getInputStream();){
                        String s = new String(Utils.readAllBytes(is));
                        Matcher m = USER_NAME.matcher(s);
                        if (!m.find()) {
                            Optional<String> optional = Optional.empty();
                            return optional;
                        }
                        Optional<String> optional = Optional.of(m.group(1).replace("\\\"", "\""));
                        return optional;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    @Override
    public CompletableFuture<J_L_ProcessHandle> onExit() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.pid > Integer.MAX_VALUE) {
                throw MissingStubError.create();
            }
            try {
                if (this.info.isEmpty()) {
                    waitForProcessExit.invokeExact(this.pid);
                    return this;
                }
                long pid = Long.parseLong(this.info.get("Handle").trim());
                waitForProcessExit.invokeExact(pid);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return this;
        });
    }

    @Override
    public boolean supportsNormalTermination() {
        return true;
    }

    @Override
    public boolean destroy() {
        try {
            terminateProcess.invokeExact(Long.parseLong(this.info.get("Handle").trim()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public boolean destroyForcibly() {
        return this.destroy();
    }

    @Override
    public boolean isAlive() {
        try {
            return isProcessAlive.invokeExact(Long.parseLong(this.info.get("Handle").trim()));
        }
        catch (Throwable e) {
            throw new RuntimeException();
        }
    }

    @Override
    public int compareTo(@NotNull J_L_ProcessHandle other) {
        return Long.compare(this.pid, other.pid());
    }

    static {
        MethodHandle waitForProcessExit1;
        IMPL_LOOKUP = Utils.getImplLookup();
        wmicLocation = System.getenv("windir") + "\\System32\\wbem\\WMIC.exe";
        try {
            Class<?> winProcess = Class.forName("java.lang.ProcessImpl");
            waitForProcessExit1 = IMPL_LOOKUP.findStatic(winProcess, "waitForInterruptibly", MethodType.methodType(Void.TYPE, Long.TYPE));
            terminateProcess = IMPL_LOOKUP.findStatic(winProcess, "terminateProcess", MethodType.methodType(Void.TYPE, Long.TYPE));
            isProcessAlive = IMPL_LOOKUP.findStatic(winProcess, "isProcessAlive", MethodType.methodType(Boolean.TYPE, Long.TYPE));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        waitForProcessExit = waitForProcessExit1;
        USER_NAME = Pattern.compile("User = \"(.+)\";$", 8);
    }
}

