/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.intl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;
import xyz.wagyourtail.jvmdg.exc.MissingStubError;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_ProcessHandle;
import xyz.wagyourtail.jvmdg.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UnixProcessHandle
implements J_L_ProcessHandle {
    private static final Unsafe unsafe;
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final MethodHandle waitForProcessExit;
    private final long pid;
    private final String[] cmdline;
    private String[] pidInfo;

    public UnixProcessHandle(long pid) {
        this.pid = pid;
        this.pidInfo = this.readPidInfo();
        this.cmdline = this.readCmdLine();
    }

    private String[] readPidInfo() {
        Path pth = Paths.get("/proc/" + this.pid + "/stat", new String[0]);
        if (Files.isReadable(pth)) {
            try {
                this.pidInfo = new String(Files.readAllBytes(pth)).split(" ");
            }
            catch (IOException e) {
                this.pidInfo = null;
            }
        }
        return this.pidInfo;
    }

    private String[] readCmdLine() {
        Path pth = Paths.get("/proc/" + this.pid + "/cmdline", new String[0]);
        if (Files.isReadable(pth)) {
            try {
                String args = new String(Files.readAllBytes(pth));
                if (args.isEmpty()) {
                    return null;
                }
                return args.split("\u0000");
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public long pid() {
        return this.pid;
    }

    @Override
    public Optional<J_L_ProcessHandle> parent() {
        String[] info = this.readPidInfo();
        if (info != null) {
            return Optional.of(new UnixProcessHandle(Long.parseLong(info[3])));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Stream<J_L_ProcessHandle> children() {
        Path pth = Paths.get("/proc/" + this.pid + "/task", new String[0]);
        try (Stream<Path> stream = Files.list(pth);){
            Stream<J_L_ProcessHandle> stream2 = Stream.of(stream.toArray(Path[]::new)).flatMap(e -> {
                try {
                    String s = new String(Files.readAllBytes(e.resolve("children")));
                    if (s.isEmpty()) {
                        return Stream.empty();
                    }
                    return Arrays.stream(s.split(" "));
                }
                catch (IOException ex) {
                    return Stream.empty();
                }
            }).mapToLong(Long::parseLong).mapToObj(UnixProcessHandle::new);
            return stream2;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @Override
    public Stream<J_L_ProcessHandle> descendants() {
        return this.children().flatMap(e -> Stream.concat(Stream.of(e), e.descendants()));
    }

    @Override
    public J_L_ProcessHandle.Info info() {
        return new J_L_ProcessHandle.Info(){

            @Override
            public Optional<String> command() {
                if (UnixProcessHandle.this.cmdline != null) {
                    return Optional.ofNullable(UnixProcessHandle.this.cmdline[0]);
                }
                return Optional.empty();
            }

            @Override
            public Optional<String> commandLine() {
                if (UnixProcessHandle.this.cmdline != null) {
                    return Optional.of(String.join((CharSequence)" ", UnixProcessHandle.this.cmdline));
                }
                return Optional.empty();
            }

            @Override
            public Optional<String[]> arguments() {
                if (UnixProcessHandle.this.cmdline != null) {
                    String[] args = new String[UnixProcessHandle.this.cmdline.length - 1];
                    System.arraycopy(UnixProcessHandle.this.cmdline, 1, args, 0, UnixProcessHandle.this.cmdline.length - 1);
                    return Optional.of(args);
                }
                return Optional.empty();
            }

            @Override
            public Optional<Instant> startInstant() {
                String[] info = UnixProcessHandle.this.readPidInfo();
                if (info != null) {
                    return Optional.of(Instant.ofEpochMilli(Long.parseLong(info[22])));
                }
                return Optional.empty();
            }

            @Override
            public Optional<Duration> totalCpuDuration() {
                String[] info = UnixProcessHandle.this.readPidInfo();
                if (info != null) {
                    return Optional.of(Duration.ofMillis(Long.parseLong(info[14])));
                }
                return Optional.empty();
            }

            @Override
            public Optional<String> user() {
                try {
                    return Optional.of(Files.getOwner(Paths.get("/proc/" + UnixProcessHandle.this.pid + "/cmdline", new String[0]), new LinkOption[0]).getName());
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            }
        };
    }

    @Override
    public CompletableFuture<J_L_ProcessHandle> onExit() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.pid > Integer.MAX_VALUE) {
                throw MissingStubError.create();
            }
            try {
                int n = waitForProcessExit.invokeExact((int)this.pid);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return new UnixProcessHandle(this.pid);
        });
    }

    @Override
    public boolean supportsNormalTermination() {
        return true;
    }

    @Override
    public boolean destroy() {
        ProcessBuilder pb = new ProcessBuilder("kill", Long.toString(this.pid));
        try {
            Process p = pb.start();
            p.waitFor();
            return p.exitValue() == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean destroyForcibly() {
        ProcessBuilder pb = new ProcessBuilder("kill", "-9", Long.toString(this.pid));
        try {
            Process p = pb.start();
            p.waitFor();
            return p.exitValue() == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean isAlive() {
        return Files.exists(Paths.get("/proc/" + this.pid + "/status", new String[0]), new LinkOption[0]);
    }

    @Override
    public int compareTo(@NotNull J_L_ProcessHandle other) {
        return Long.compare(this.pid, other.pid());
    }

    static {
        MethodHandle waitForProcessExit1;
        unsafe = Utils.getUnsafe();
        IMPL_LOOKUP = Utils.getImplLookup();
        try {
            Class<?> unixProcess = Class.forName("java.lang.UNIXProcess");
            waitForProcessExit1 = IMPL_LOOKUP.findVirtual(unixProcess, "waitForProcessExit", MethodType.methodType(Integer.TYPE, Integer.TYPE)).bindTo(unsafe.allocateInstance(unixProcess));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            try {
                waitForProcessExit1 = MethodHandles.insertArguments(IMPL_LOOKUP.findStatic(Class.forName("java.lang.ProcessHandleImpl"), "waitForProcessExit0", MethodType.methodType(Integer.TYPE, Long.TYPE, Boolean.TYPE)), 1, false).asType(MethodType.methodType(Integer.TYPE, Integer.TYPE));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        waitForProcessExit = waitForProcessExit1;
    }
}

