/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/StringJoiner")
public final class J_U_StringJoiner {
    private final String prefix;
    private final String delimiter;
    private final String suffix;
    StringBuilder builder = new StringBuilder();
    private String emptyValue;

    public J_U_StringJoiner(CharSequence delimiter) {
        this(delimiter, "", "");
    }

    public J_U_StringJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this.prefix = prefix.toString();
        this.delimiter = delimiter.toString();
        this.suffix = suffix.toString();
    }

    public J_U_StringJoiner setEmptyValue(CharSequence emptyValue) {
        this.emptyValue = emptyValue.toString();
        return this;
    }

    public String toString() {
        if (this.emptyValue != null && this.builder.length() == 0) {
            return this.emptyValue;
        }
        this.builder.setLength(this.builder.length() - this.delimiter.length());
        String out = this.prefix + this.builder.toString() + this.suffix;
        this.builder.append(this.delimiter);
        return out;
    }

    public J_U_StringJoiner add(CharSequence newElement) {
        if (this.builder.length() + newElement.length() + this.prefix.length() + this.suffix.length() > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("StringJoiner too long");
        }
        this.builder.append(newElement).append(this.delimiter);
        return this;
    }

    public J_U_StringJoiner merge(J_U_StringJoiner other) {
        if (other.builder.length() > 0) {
            other.builder.setLength(other.builder.length() - other.delimiter.length());
            this.add(other.builder);
            other.builder.append(other.delimiter);
        }
        return this;
    }

    public int length() {
        if (this.emptyValue != null && this.builder.length() == 0) {
            return this.emptyValue.length();
        }
        if (this.builder.length() == 0) {
            return this.prefix.length() + this.suffix.length();
        }
        return this.builder.length() + this.prefix.length() + this.suffix.length() - this.delimiter.length();
    }
}

