/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.NoSuchElementException;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_IntConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_IntSupplier;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Supplier;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/OptionalInt")
public class J_U_OptionalInt {
    private static final J_U_OptionalInt EMPTY = new J_U_OptionalInt();
    private final boolean isPresent;
    private final int value;

    private J_U_OptionalInt() {
        this.isPresent = false;
        this.value = 0;
    }

    private J_U_OptionalInt(int value) {
        this.isPresent = true;
        this.value = value;
    }

    public static J_U_OptionalInt empty() {
        return EMPTY;
    }

    public static J_U_OptionalInt of(int value) {
        return new J_U_OptionalInt(value);
    }

    public int getAsint() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(J_U_F_IntConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public int orElse(int other) {
        return this.isPresent ? this.value : other;
    }

    public int orElseGet(J_U_F_IntSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsInt();
    }

    public int orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> int orElseThrow(J_U_F_Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof J_U_OptionalInt)) {
            return false;
        }
        J_U_OptionalInt other = (J_U_OptionalInt)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.value : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

