/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.NoSuchElementException;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_DoubleConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_DoubleSupplier;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Supplier;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/OptionalDouble")
public class J_U_OptionalDouble {
    private static final J_U_OptionalDouble EMPTY = new J_U_OptionalDouble();
    private final boolean isPresent;
    private final double value;

    private J_U_OptionalDouble() {
        this.isPresent = false;
        this.value = Double.NaN;
    }

    private J_U_OptionalDouble(double value) {
        this.isPresent = true;
        this.value = value;
    }

    public static J_U_OptionalDouble empty() {
        return EMPTY;
    }

    public static J_U_OptionalDouble of(double value) {
        return new J_U_OptionalDouble(value);
    }

    public double getAsDouble() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(J_U_F_DoubleConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public double orElse(double other) {
        return this.isPresent ? this.value : other;
    }

    public double orElseGet(J_U_F_DoubleSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsDouble();
    }

    public double orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> double orElseThrow(J_U_F_Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof J_U_OptionalDouble)) {
            return false;
        }
        J_U_OptionalDouble other = (J_U_OptionalDouble)obj;
        return this.isPresent && other.isPresent ? Double.compare(this.value, other.value) == 0 : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.hashCode(this.value) : 0;
    }

    private int hashCode(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalDouble[%s]", this.value) : "OptionalDouble.empty";
    }
}

