/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.Objects;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Consumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Function;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Predicate;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Supplier;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="Ljava/util/Optional;")
public class J_U_Optional<T> {
    private static final J_U_Optional EMPTY = new J_U_Optional<Object>(null);
    private final T value;

    private J_U_Optional(T value) {
        this.value = value;
    }

    public static <T> J_U_Optional<T> empty() {
        return EMPTY;
    }

    public static <T> J_U_Optional<T> of(T value) {
        return new J_U_Optional<T>(Objects.requireNonNull(value));
    }

    public static <T> J_U_Optional<T> ofNullable(T value) {
        return value == null ? EMPTY : new J_U_Optional<T>(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NullPointerException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(J_U_F_Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public J_U_Optional<T> filter(J_U_F_Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : J_U_Optional.empty();
    }

    public <U> J_U_Optional<U> map(J_U_F_Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return J_U_Optional.empty();
        }
        return J_U_Optional.ofNullable(mapper.apply(this.value));
    }

    public <U> J_U_Optional<U> flatMap(J_U_F_Function<? super T, J_U_Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return J_U_Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(J_U_F_Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(J_U_F_Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof J_U_Optional)) {
            return false;
        }
        J_U_Optional other = (J_U_Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        if (this.value != null) {
            return String.format("Optional[%s]", this.value);
        }
        return "Optional.empty";
    }
}

