/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_DoubleConsumer;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/DoubleSummaryStatistics")
public class J_U_DoubleSummaryStatistics
implements J_U_F_DoubleConsumer {
    private long count;
    private double sum;
    private double sumCompensation;
    private double simpleSum;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    @Override
    public void accept(double value) {
        ++this.count;
        this.simpleSum += value;
        this.sumWithCompensation(value);
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void combine(J_U_DoubleSummaryStatistics other) {
        this.count += other.count;
        this.simpleSum += other.simpleSum;
        this.sumWithCompensation(other.sum);
        this.sumWithCompensation(-other.sumCompensation);
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    private void sumWithCompensation(double value) {
        double tmp = value - this.sumCompensation;
        double velvel = this.sum + tmp;
        this.sumCompensation = velvel - this.sum - tmp;
        this.sum = velvel;
    }

    public final long getCount() {
        return this.count;
    }

    public final double getSum() {
        double tmp = this.sum - this.sumCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSum)) {
            return this.simpleSum;
        }
        return tmp;
    }

    public final double getMin() {
        return this.min;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getAverage() {
        return this.getCount() > 0L ? this.getSum() / (double)this.getCount() : 0.0;
    }

    public String toString() {
        return "DoubleSummaryStatistics{count=" + this.count + ", sum=" + this.getSum() + ", min=" + this.min + ", average=" + this.getAverage() + ", max=" + this.max + '}';
    }

    @Override
    public J_U_F_DoubleConsumer andThen(J_U_F_DoubleConsumer after) {
        return null;
    }
}

