/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Function;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_C_ConcurrentMap {
    @Stub
    public static <K, V> V replace(ConcurrentMap<K, V> map, K key, V value) {
        return map.replace(key, value);
    }

    @Stub
    public static <K, V> boolean replace(ConcurrentMap<K, V> map, K key, V oldValue, V newValue) {
        return map.replace(key, oldValue, newValue);
    }

    @Stub
    public static <K, V> boolean remove(ConcurrentMap<K, V> map, K key, V value) {
        return map.remove(key, value);
    }

    @Stub
    public static <K, V> V getOrDefault(ConcurrentMap<K, V> map, Object key, V defaultValue) {
        Object v = map.get(key);
        return v != null ? v : defaultValue;
    }

    @Stub
    public static <K, V> void forEach(ConcurrentMap<K, V> map, J_U_F_BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry entry : map.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    @Stub
    public static <K, V> void replaceAll(final ConcurrentMap<K, V> map, final J_U_F_BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        J_U_C_ConcurrentMap.forEach(map, new J_U_F_BiConsumer.BiConsumerAdapter<K, V>(){

            @Override
            public void accept(K k, V v) {
                while (!map.replace(k, v, function.apply(k, v)) && (v = map.get(k)) != null) {
                }
            }
        });
    }

    @Stub
    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, J_U_F_Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object oldValue = map.get(key);
        return oldValue == null && (newValue = mappingFunction.apply(key)) != null && (oldValue = map.putIfAbsent(key, newValue)) == null ? newValue : oldValue;
    }

    @Stub
    public static <K, V> V computeIfPresent(ConcurrentMap<K, V> map, K key, J_U_F_BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        Objects.requireNonNull(remappingFunction);
        while ((oldValue = map.get(key)) != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue == null) {
                if (!map.remove(key, oldValue)) continue;
                return null;
            }
            if (!map.replace(key, oldValue, newValue)) continue;
            return newValue;
        }
        return null;
    }

    @Stub
    public static <K, V> V compute(ConcurrentMap<K, V> map, K key, J_U_F_BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        block0: while (true) {
            V newValue;
            Object oldValue = map.get(key);
            while ((newValue = remappingFunction.apply(key, oldValue)) != null) {
                if (oldValue != null) {
                    if (!map.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                oldValue = map.putIfAbsent(key, newValue);
                if (oldValue != null) continue;
                return newValue;
            }
            if (oldValue == null || map.remove(key, oldValue)) break;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Stub
    public static <K, V> V merge(ConcurrentMap<K, V> map, K key, V value, J_U_F_BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        block0: while (true) {
            Object oldValue = map.get(key);
            do {
                if (oldValue == null) continue;
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (!map.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                if (map.remove(key, oldValue)) return null;
                continue block0;
            } while ((oldValue = map.putIfAbsent(key, value)) != null);
            break;
        }
        return value;
    }
}

