/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import xyz.wagyourtail.jvmdg.j8.intl.collections.SynchronizedBackingSet;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_C_CompletionException;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_C_CompletionStage;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_C_ForkJoinPool;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Function;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Supplier;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/concurrent/CompletableFuture")
public class J_U_C_CompletableFuture<T>
implements Future<T>,
J_U_C_CompletionStage<T> {
    private static final boolean USE_COMMON_POOL = J_U_C_ForkJoinPool.getCommonPoolParallelism() > 1;
    private static final Executor ASYNC_POOL = USE_COMMON_POOL ? J_U_C_ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();
    private final CompletableFutureTask<T> wrapped;
    private final Executor executor;

    J_U_C_CompletableFuture(CompletableFutureTask<T> wrapped, Executor executor) {
        this.wrapped = wrapped;
        this.executor = executor;
        if (executor == null) {
            wrapped.run();
        } else {
            executor.execute(wrapped);
        }
    }

    public static <U> J_U_C_CompletableFuture<U> supplyAsync(J_U_F_Supplier<U> supplier) {
        return J_U_C_CompletableFuture.supplyAsync(supplier, ASYNC_POOL);
    }

    public static <U> J_U_C_CompletableFuture<U> supplyAsync(final J_U_F_Supplier<U> supplier, Executor executor) {
        return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

            @Override
            public U call() throws Exception {
                return supplier.get();
            }
        }), executor);
    }

    public static J_U_C_CompletableFuture<Void> runAsync(Runnable runnable) {
        return J_U_C_CompletableFuture.runAsync(runnable, ASYNC_POOL);
    }

    public static J_U_C_CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return new J_U_C_CompletableFuture<Object>(new CompletableFutureTask<Object>(runnable, null), executor);
    }

    public static <U> J_U_C_CompletableFuture<U> completedFuture(U value) {
        return new J_U_C_CompletableFuture<U>(new CompletableFutureTask<U>(new Runnable(){

            @Override
            public void run() {
            }
        }, value), null);
    }

    static <U> J_U_C_CompletableFuture<U> failedFuture(final Exception ex) {
        return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

            @Override
            public U call() throws Exception {
                throw ex;
            }
        }), null);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.wrapped.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.wrapped.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.wrapped.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.wrapped.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.wrapped.get(timeout, unit);
    }

    public T join() {
        try {
            return (T)this.wrapped.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new J_U_C_CompletionException(e.getCause());
        }
    }

    public T getNow(T valueIfAbsent) {
        try {
            return (T)this.wrapped.get(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new J_U_C_CompletionException(e.getCause());
        }
        catch (TimeoutException e) {
            return valueIfAbsent;
        }
    }

    public boolean complete(T value) {
        return this.wrapped.complete(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.wrapped.completeExceptionally(ex);
    }

    @Override
    public <U> J_U_C_CompletionStage<U> thenApply(final J_U_F_Function<? super T, ? extends U> fn) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

                @Override
                public U call() throws Exception {
                    return fn.apply(J_U_C_CompletableFuture.this.wrapped.get());
                }
            }), null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <U> J_U_C_CompletionStage<U> thenApplyAsync(J_U_F_Function<? super T, ? extends U> fn) {
        return this.thenApplyAsync(fn, ASYNC_POOL);
    }

    @Override
    public <U> J_U_C_CompletionStage<U> thenApplyAsync(final J_U_F_Function<? super T, ? extends U> fn, Executor executor) {
        return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

            @Override
            public U call() throws Exception {
                return fn.apply(J_U_C_CompletableFuture.this.wrapped.get());
            }
        }), new AfterCompleteDelegatingExecutor(executor));
    }

    @Override
    public J_U_C_CompletionStage<Void> thenAccept(final J_U_F_Function<? super T, Void> action) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return new J_U_C_CompletableFuture<Void>(new CompletableFutureTask(new Callable(){

                public Object call() throws Exception {
                    action.apply(J_U_C_CompletableFuture.this.wrapped.get());
                    return null;
                }
            }), null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public J_U_C_CompletionStage<Void> thenAcceptAsync(J_U_F_Function<? super T, Void> action) {
        return this.thenAcceptAsync(action, ASYNC_POOL);
    }

    @Override
    public J_U_C_CompletionStage<Void> thenAcceptAsync(final J_U_F_Function<? super T, Void> action, Executor executor) {
        return new J_U_C_CompletableFuture<Void>(new CompletableFutureTask(new Callable(){

            public Object call() throws Exception {
                action.apply(J_U_C_CompletableFuture.this.wrapped.get());
                return null;
            }
        }), new AfterCompleteDelegatingExecutor(executor));
    }

    @Override
    public J_U_C_CompletionStage<Void> thenRun(Runnable action) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return new J_U_C_CompletableFuture<Object>(new CompletableFutureTask<Object>(action, null), null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public J_U_C_CompletionStage<Void> thenRunAsync(Runnable action) {
        return this.thenRunAsync(action, ASYNC_POOL);
    }

    @Override
    public J_U_C_CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return new J_U_C_CompletableFuture<Object>(new CompletableFutureTask<Object>(action, null), new AfterCompleteDelegatingExecutor(executor));
    }

    @Override
    public <U, V> J_U_C_CompletionStage<V> thenCombine(J_U_C_CompletionStage<? extends U> other, final J_U_F_BiFunction<? super T, ? super U, ? extends V> fn) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return other.thenApply(new J_U_F_Function.FunctionAdapter<U, V>(){

                @Override
                public V apply(U u) {
                    try {
                        return fn.apply(J_U_C_CompletableFuture.this.wrapped.get(), u);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new J_U_C_CompletionException(e.getCause());
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <U, V> J_U_C_CompletionStage<V> thenCombineAsync(J_U_C_CompletionStage<? extends U> other, J_U_F_BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombineAsync(other, fn, ASYNC_POOL);
    }

    @Override
    public <U, V> J_U_C_CompletionStage<V> thenCombineAsync(final J_U_C_CompletionStage<? extends U> other, final J_U_F_BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return fn.apply(J_U_C_CompletableFuture.this.wrapped.get(), other.toCompletableFuture().get());
            }
        }), new AfterAllDelegatingExecutor(new HashSet(Arrays.asList(other.toCompletableFuture().wrapped, this.wrapped)), executor));
    }

    @Override
    public <U> J_U_C_CompletionStage<Void> thenAcceptBoth(J_U_C_CompletionStage<? extends U> other, final J_U_F_BiFunction<? super T, ? super U, Void> action) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return other.thenAccept(new J_U_F_Function.FunctionAdapter<U, Object>(){

                @Override
                public Object apply(U u) {
                    try {
                        action.apply(J_U_C_CompletableFuture.this.wrapped.get(), u);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <U> J_U_C_CompletionStage<Void> thenAcceptBothAsync(J_U_C_CompletionStage<? extends U> other, J_U_F_BiFunction<? super T, ? super U, Void> action) {
        return this.thenAcceptBothAsync(other, action, ASYNC_POOL);
    }

    @Override
    public <U> J_U_C_CompletionStage<Void> thenAcceptBothAsync(final J_U_C_CompletionStage<? extends U> other, final J_U_F_BiFunction<? super T, ? super U, Void> action, Executor executor) {
        return new J_U_C_CompletableFuture<Void>(new CompletableFutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                action.apply(J_U_C_CompletableFuture.this.wrapped.get(), other.toCompletableFuture().get());
                return null;
            }
        }), new AfterAllDelegatingExecutor(new HashSet(Arrays.asList(other.toCompletableFuture().wrapped, this.wrapped)), executor));
    }

    @Override
    public J_U_C_CompletionStage<Void> runAfterBoth(J_U_C_CompletionStage<?> other, Runnable action) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return other.thenRun(action);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public J_U_C_CompletionStage<Void> runAfterBothAsync(J_U_C_CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync(other, action, ASYNC_POOL);
    }

    @Override
    public J_U_C_CompletionStage<Void> runAfterBothAsync(J_U_C_CompletionStage<?> other, Runnable action, Executor executor) {
        return new J_U_C_CompletableFuture<Object>(new CompletableFutureTask<Object>(action, null), new AfterAllDelegatingExecutor(new HashSet(Arrays.asList(other.toCompletableFuture().wrapped, this.wrapped)), executor));
    }

    @Override
    public <U> J_U_C_CompletionStage<U> applyToEither(J_U_C_CompletionStage<? extends T> other, J_U_F_Function<? super T, U> fn) {
        final Semaphore semaphore = new Semaphore(0);
        final boolean[] exceptionally = new boolean[1];
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                try {
                    J_U_C_CompletableFuture.this.wrapped.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    exceptionally[0] = true;
                }
                semaphore.release();
            }
        });
        other.toCompletableFuture().wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            if (exceptionally[0] || exceptionally[1]) {
                semaphore.acquire();
            }
            if (exceptionally[0] && exceptionally[1]) {
                return J_U_C_CompletableFuture.failedFuture(new ExecutionException("Both futures completed exceptionally", null));
            }
            if (exceptionally[0]) {
                return other.thenApply(fn);
            }
            if (exceptionally[1]) {
                return this.thenApply(fn);
            }
            Object result = null;
            try {
                result = this.wrapped.get(0L, TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException | TimeoutException | J_U_C_CompletionException e) {
                try {
                    result = other.toCompletableFuture().get(0L, TimeUnit.NANOSECONDS);
                }
                catch (ExecutionException e1) {
                    return J_U_C_CompletableFuture.failedFuture((Exception)e1.getCause());
                }
                catch (TimeoutException e2) {
                    throw new RuntimeException(e2);
                }
            }
            return J_U_C_CompletableFuture.completedFuture(fn.apply(result));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <U> J_U_C_CompletionStage<U> applyToEitherAsync(J_U_C_CompletionStage<? extends T> other, J_U_F_Function<? super T, U> fn) {
        return this.applyToEitherAsync(other, fn, ASYNC_POOL);
    }

    @Override
    public <U> J_U_C_CompletionStage<U> applyToEitherAsync(final J_U_C_CompletionStage<? extends T> other, final J_U_F_Function<? super T, U> fn, Executor executor) {
        return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

            @Override
            public U call() throws Exception {
                try {
                    return fn.apply(J_U_C_CompletableFuture.this.wrapped.get(0L, TimeUnit.NANOSECONDS));
                }
                catch (InterruptedException | ExecutionException e) {
                    return fn.apply(other.toCompletableFuture().get(0L, TimeUnit.NANOSECONDS));
                }
            }
        }), new AfterFirstExecutor(new HashSet(Arrays.asList(other.toCompletableFuture().wrapped, this.wrapped)), executor));
    }

    @Override
    public J_U_C_CompletionStage<Void> acceptEither(J_U_C_CompletionStage<? extends T> other, final J_U_F_Function<? super T, Void> action) {
        return this.applyToEither(other, new J_U_F_Function.FunctionAdapter<T, Object>(){

            @Override
            public Object apply(T t) {
                action.apply(t);
                return null;
            }
        });
    }

    @Override
    public J_U_C_CompletionStage<Void> acceptEitherAsync(J_U_C_CompletionStage<? extends T> other, J_U_F_Function<? super T, Void> action) {
        return this.acceptEitherAsync(other, action, ASYNC_POOL);
    }

    @Override
    public J_U_C_CompletionStage<Void> acceptEitherAsync(J_U_C_CompletionStage<? extends T> other, final J_U_F_Function<? super T, Void> action, Executor executor) {
        return this.applyToEitherAsync(other, new J_U_F_Function.FunctionAdapter<T, Void>(){

            @Override
            public Void apply(T t) {
                action.apply(t);
                return null;
            }
        }, executor);
    }

    @Override
    public J_U_C_CompletionStage<Void> runAfterEither(J_U_C_CompletionStage<?> other, Runnable action) {
        final Semaphore semaphore = new Semaphore(0);
        final boolean[] exceptionally = new boolean[1];
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                try {
                    J_U_C_CompletableFuture.this.wrapped.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    exceptionally[0] = true;
                }
                semaphore.release();
            }
        });
        other.toCompletableFuture().wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            if (exceptionally[0] || exceptionally[1]) {
                semaphore.acquire();
            }
            if (exceptionally[0] && exceptionally[1]) {
                return J_U_C_CompletableFuture.failedFuture(new ExecutionException("Both futures completed exceptionally", null));
            }
            if (exceptionally[0]) {
                return other.thenRun(action);
            }
            if (exceptionally[1]) {
                return this.thenRun(action);
            }
            return new J_U_C_CompletableFuture<Object>(new CompletableFutureTask<Object>(action, null), new AfterFirstExecutor(new HashSet(Arrays.asList(other.toCompletableFuture().wrapped, this.wrapped)), ASYNC_POOL));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public J_U_C_CompletionStage<Void> runAfterEitherAsync(J_U_C_CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync(other, action, ASYNC_POOL);
    }

    @Override
    public J_U_C_CompletionStage<Void> runAfterEitherAsync(J_U_C_CompletionStage<?> other, Runnable action, Executor executor) {
        return new J_U_C_CompletableFuture<Object>(new CompletableFutureTask<Object>(action, null), new AfterFirstExecutor(new HashSet(Arrays.asList(other.toCompletableFuture().wrapped, this.wrapped)), executor));
    }

    @Override
    public <U> J_U_C_CompletionStage<U> thenCompose(J_U_F_Function<? super T, ? extends J_U_C_CompletionStage<U>> fn) {
        final Semaphore semaphore = new Semaphore(0);
        final boolean[] exceptionally = new boolean[1];
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                try {
                    J_U_C_CompletableFuture.this.wrapped.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    exceptionally[0] = true;
                }
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            if (exceptionally[0]) {
                return J_U_C_CompletableFuture.failedFuture(new ExecutionException("Future completed exceptionally", null));
            }
            return fn.apply(this.wrapped.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <U> J_U_C_CompletionStage<U> thenComposeAsync(J_U_F_Function<? super T, ? extends J_U_C_CompletionStage<U>> fn) {
        return this.thenComposeAsync(fn, ASYNC_POOL);
    }

    @Override
    public <U> J_U_C_CompletionStage<U> thenComposeAsync(J_U_F_Function<? super T, ? extends J_U_C_CompletionStage<U>> fn, Executor executor) {
        return this.thenApplyAsync(fn, executor).thenApplyAsync(new J_U_F_Function.FunctionAdapter<J_U_C_CompletionStage<U>, U>(){

            @Override
            public U apply(J_U_C_CompletionStage<U> ujUCCompletionStage) {
                return ujUCCompletionStage.toCompletableFuture().join();
            }
        }, executor);
    }

    @Override
    public <U> J_U_C_CompletionStage<U> handle(final J_U_F_BiFunction<? super T, Throwable, ? extends U> fn) {
        final Semaphore semaphore = new Semaphore(0);
        this.wrapped.after(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
            return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

                @Override
                public U call() throws Exception {
                    try {
                        return fn.apply(J_U_C_CompletableFuture.this.get(0L, TimeUnit.NANOSECONDS), null);
                    }
                    catch (J_U_C_CompletionException e) {
                        return fn.apply(null, e.getCause());
                    }
                    catch (InterruptedException | TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }
            }), this.executor);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <U> J_U_C_CompletionStage<U> handleAsync(J_U_F_BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.handleAsync(fn, ASYNC_POOL);
    }

    @Override
    public <U> J_U_C_CompletionStage<U> handleAsync(final J_U_F_BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return new J_U_C_CompletableFuture(new CompletableFutureTask(new Callable<U>(){

            @Override
            public U call() throws Exception {
                try {
                    return fn.apply(J_U_C_CompletableFuture.this.get(0L, TimeUnit.NANOSECONDS), null);
                }
                catch (J_U_C_CompletionException e) {
                    return fn.apply(null, e.getCause());
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        }), executor);
    }

    @Override
    public J_U_C_CompletionStage<T> whenComplete(final J_U_F_BiConsumer<? super T, ? super Throwable> action) {
        return this.handle(new J_U_F_BiFunction.BiFunctionAdapter<T, Throwable, T>(){

            @Override
            public T apply(T t, Throwable throwable) {
                action.accept(t, throwable);
                return t;
            }
        });
    }

    @Override
    public J_U_C_CompletionStage<T> whenCompleteAsync(J_U_F_BiConsumer<? super T, ? super Throwable> action) {
        return this.whenCompleteAsync(action, ASYNC_POOL);
    }

    @Override
    public J_U_C_CompletionStage<T> whenCompleteAsync(final J_U_F_BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.handleAsync(new J_U_F_BiFunction.BiFunctionAdapter<T, Throwable, T>(){

            @Override
            public T apply(T t, Throwable throwable) {
                action.accept(t, throwable);
                return t;
            }
        }, executor);
    }

    @Override
    public J_U_C_CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class AfterCompleteDelegatingExecutor
    implements Executor {
        private final Executor executor;

        public AfterCompleteDelegatingExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public void execute(final Runnable command) {
            J_U_C_CompletableFuture.this.wrapped.after(new Runnable(){

                @Override
                public void run() {
                    AfterCompleteDelegatingExecutor.this.executor.execute(command);
                }
            });
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AfterFirstExecutor
    implements Executor {
        private final Set<CompletableFutureTask<?>> tasks;
        private final Deque<Runnable> runnables = new ConcurrentLinkedDeque<Runnable>();
        private final Executor executor;
        private boolean done;

        public AfterFirstExecutor(final Set<CompletableFutureTask<?>> tasks, final Executor executor) {
            this.tasks = new SynchronizedBackingSet(tasks);
            this.executor = executor;
            for (final CompletableFutureTask<?> task : tasks) {
                task.after(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean wasDone;
                        Set set = tasks;
                        synchronized (set) {
                            tasks.remove(task);
                            wasDone = AfterFirstExecutor.this.done;
                            AfterFirstExecutor.this.done = true;
                        }
                        if (!wasDone) {
                            Runnable runnable;
                            while ((runnable = (Runnable)AfterFirstExecutor.this.runnables.poll()) != null) {
                                executor.execute(runnable);
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            if (this.done) {
                this.executor.execute(command);
            } else {
                Set<CompletableFutureTask<?>> set = this.tasks;
                synchronized (set) {
                    if (!this.done) {
                        this.runnables.add(command);
                    }
                }
                this.executor.execute(command);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AfterAllDelegatingExecutor
    implements Executor {
        private final Set<CompletableFutureTask<?>> tasks;
        private final Deque<Runnable> runnables = new ConcurrentLinkedDeque<Runnable>();
        private final Executor executor;

        public AfterAllDelegatingExecutor(final Set<CompletableFutureTask<?>> tasks, final Executor executor) {
            this.tasks = new SynchronizedBackingSet(tasks);
            this.executor = executor;
            for (final CompletableFutureTask<?> task : tasks) {
                task.after(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set set = tasks;
                        synchronized (set) {
                            tasks.remove(task);
                        }
                        if (tasks.isEmpty()) {
                            Runnable runnable;
                            while ((runnable = (Runnable)AfterAllDelegatingExecutor.this.runnables.poll()) != null) {
                                executor.execute(runnable);
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            if (this.tasks.isEmpty()) {
                this.executor.execute(command);
            } else {
                Set<CompletableFutureTask<?>> set = this.tasks;
                synchronized (set) {
                    if (!this.tasks.isEmpty()) {
                        this.runnables.add(command);
                    }
                }
                this.executor.execute(command);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class RunOnCurrentThreadExecutor
    implements Executor {
        private RunOnCurrentThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            new Thread(command).start();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AsyncRunnableFuture<T>
    extends CompletableFutureTask<T>
    implements AsynchronousCompletionTask {
        AsyncRunnableFuture(Callable<T> runnable) {
            super(runnable);
        }

        AsyncRunnableFuture(Runnable runnable, T result) {
            super(runnable, result);
        }

        @Override
        public void run() {
            super.run();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CompletableFutureTask<T>
    extends FutureTask<T> {
        Runnable after;

        CompletableFutureTask(Callable<T> runnable) {
            super(runnable);
        }

        CompletableFutureTask(Runnable runnable, T result) {
            super(runnable, result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            CompletableFutureTask completableFutureTask = this;
            synchronized (completableFutureTask) {
                if (this.after != null) {
                    this.after.run();
                    this.after = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void after(final Runnable runnable) {
            if (this.isDone()) {
                runnable.run();
            } else {
                CompletableFutureTask completableFutureTask = this;
                synchronized (completableFutureTask) {
                    if (this.isDone()) {
                        runnable.run();
                    } else {
                        final Runnable prev = this.after;
                        this.after = new Runnable(){

                            @Override
                            public void run() {
                                if (prev != null) {
                                    prev.run();
                                }
                                runnable.run();
                            }
                        };
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean complete(T value) {
            this.set(value);
            CompletableFutureTask completableFutureTask = this;
            synchronized (completableFutureTask) {
                if (this.after != null) {
                    this.after.run();
                    this.after = null;
                }
            }
            try {
                return this.get() == value;
            }
            catch (InterruptedException | ExecutionException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean completeExceptionally(Throwable ex) {
            this.setException(ex);
            CompletableFutureTask completableFutureTask = this;
            synchronized (completableFutureTask) {
                if (this.after != null) {
                    this.after.run();
                    this.after = null;
                }
            }
            try {
                this.get();
                return false;
            }
            catch (ExecutionException e) {
                return e.getCause() == ex;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/util/concurrent/CompletableFuture$AsynchronousCompletionTask")
    public static interface AsynchronousCompletionTask {
    }
}

