/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.math.BigInteger;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_M_BigInteger {
    @Stub
    public static long longValueExact(BigInteger self) {
        if (self.bitLength() <= 63) {
            return self.longValue();
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    @Stub
    public static int intValueExact(BigInteger self) {
        if (self.bitLength() <= 31) {
            return self.intValue();
        }
        throw new ArithmeticException("BigInteger out of int range");
    }

    @Stub
    public static short shortValueExact(BigInteger self) {
        int val;
        if (self.bitLength() <= 31 && (val = self.intValue()) >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
            return (short)val;
        }
        throw new ArithmeticException("BigInteger out of short range");
    }

    @Stub
    public static byte byteValueExact(BigInteger self) {
        int val;
        if (self.bitLength() <= 31 && (val = self.intValue()) >= -128 && val <= 127) {
            return (byte)val;
        }
        throw new ArithmeticException("BigInteger out of byte range");
    }
}

