/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Math {
    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int subtractExact(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long subtractExact(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int incrementExact(int a) {
        if (a == Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return a + 1;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long incrementExact(long a) {
        if (a == Long.MAX_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return a + 1L;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int decrementExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return a - 1;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long decrementExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return a - 1L;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int negateExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return -a;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long negateExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return -a;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static int floorMod(int x, int y) {
        int r = x % y;
        if ((x ^ y) < 0 && r < 0) {
            return r + y;
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static long floorMod(long x, long y) {
        long r = x % y;
        if ((x ^ y) < 0L && r < 0L) {
            return r + y;
        }
        return r;
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static double nextDown(double d) {
        if (Double.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToLongBits(d) + (long)(d > 0.0 ? -1 : 1));
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    public static float nextDown(float f) {
        if (Float.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToIntBits(f) + (f > 0.0f ? -1 : 1));
    }
}

