/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.math.BigInteger;
import xyz.wagyourtail.jvmdg.j8.stub.J_L_Integer;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Long {
    @Stub(ref=@Ref(value="java/lang/Long"))
    public static final int BYTES = 8;

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static String toUnsignedString(long i, int radix) {
        if (i >= 0L) {
            return Long.toString(i, radix);
        }
        switch (radix) {
            case 2: {
                return Long.toBinaryString(i);
            }
            case 4: {
                return J_L_Long.toUnsignedStringByBits(i, 2);
            }
            case 8: {
                return Long.toOctalString(i);
            }
            case 10: {
                long quot = (i >>> 1) / 5L;
                long rem = i - quot * 10L;
                return Long.toString(quot) + rem;
            }
            case 16: {
                return Long.toHexString(i);
            }
            case 32: {
                return J_L_Long.toUnsignedStringByBits(i, 5);
            }
        }
        return J_L_Long.toUnsignedBigInteger(i).toString(radix);
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(J_L_Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(J_L_Integer.toUnsignedLong(lower)));
    }

    private static String toUnsignedStringByBits(long i, int bits) {
        int shift = 64 - bits;
        int radix = 1 << bits;
        long mask = radix - 1;
        char[] buf = new char[64 / bits + 1];
        int charPos = 64 / bits;
        do {
            buf[--charPos] = Character.forDigit((int)(i & mask), radix);
        } while ((i >>>= shift) != 0L && charPos > 0);
        return new String(buf, charPos, 64 / bits - charPos);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static String toUnsignedString(long i) {
        return J_L_Long.toUnsignedString(i, 10);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            BigInteger bigInteger = new BigInteger(s, radix);
            if (bigInteger.signum() < 0 || bigInteger.bitLength() > 64) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
            return bigInteger.longValue();
        }
        throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return J_L_Long.parseUnsignedLong(s, 10);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return q + ((r | r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
        }
        return (dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return r - ((r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >> 63 & divisor);
        }
        return dividend - ((dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >> 63 & divisor);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long sum(long a, long b) {
        return a + b;
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    @Stub(ref=@Ref(value="java/lang/Long"))
    public static long min(long a, long b) {
        return Math.min(a, b);
    }
}

