/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import xyz.wagyourtail.jvmdg.j8.stub.J_L_Long;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Integer {
    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static final int BYTES = 4;

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static String toUnsignedString(int i, int radix) {
        return J_L_Long.toUnsignedString(i, radix);
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static String toUnsignedString(int i) {
        return J_L_Long.toUnsignedString(i);
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        int len = s.length();
        if (len > 0) {
            char first = s.charAt(0);
            if (first == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, radix);
            }
            long ell = Long.parseLong(s, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw new NumberFormatException("Cannot parse empty string");
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return J_L_Integer.parseUnsignedInt(s, 10);
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int hashCode(int value) {
        return value;
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int compareUnsigned(int x, int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int divideUnsigned(int dividend, int divisor) {
        return (int)(J_L_Integer.toUnsignedLong(dividend) / J_L_Integer.toUnsignedLong(divisor));
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int remainderUnsigned(int dividend, int divisor) {
        return (int)(J_L_Integer.toUnsignedLong(dividend) % J_L_Integer.toUnsignedLong(divisor));
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int sum(int a, int b) {
        return a + b;
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    @Stub(ref=@Ref(value="java/lang/Integer"))
    public static int min(int a, int b) {
        return Math.min(a, b);
    }
}

