/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.spliterator;

import java.util.Comparator;
import xyz.wagyourtail.jvmdg.j8.intl.spliterator.IntArraySpliterator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_PrimitiveIterator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Spliterator;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Consumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_IntConsumer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IntIteratorSpliterator
implements J_U_Spliterator.OfInt {
    static final int BATCH_UNIT = 1024;
    static final int MAX_BATCH = 0x2000000;
    private final int characteristics;
    private final J_U_PrimitiveIterator.OfInt it;
    private long est;
    private int batch;

    public IntIteratorSpliterator(J_U_PrimitiveIterator.OfInt it, long size, int characteristics) {
        this.it = it;
        this.est = size;
        this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
    }

    public IntIteratorSpliterator(J_U_PrimitiveIterator.OfInt it, int characteristics) {
        this.it = it;
        this.est = Long.MAX_VALUE;
        this.characteristics = characteristics & 0xFFFFBFBF;
    }

    @Override
    public boolean tryAdvance(J_U_F_IntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.it.hasNext()) {
            action.accept(this.it.nextInt());
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(final J_U_F_Consumer<? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.it.forEachRemaining(new J_U_F_IntConsumer.IntConsumerAdapter(){

            @Override
            public void accept(int value) {
                action.accept(value);
            }
        });
    }

    @Override
    public void forEachRemaining(J_U_F_IntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.it.forEachRemaining(action);
    }

    @Override
    public boolean tryAdvance(J_U_F_Consumer<? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.it.hasNext()) {
            action.accept((Integer)this.it.nextInt());
            return true;
        }
        return false;
    }

    @Override
    public J_U_Spliterator.OfInt trySplit() {
        long s = this.est;
        if (s > 1L && this.it.hasNext()) {
            int n = this.batch + 1024;
            if ((long)n > s) {
                n = (int)s;
            }
            if (n > 0x2000000) {
                n = 0x2000000;
            }
            int[] a = new int[n];
            int j = 0;
            do {
                a[j] = this.it.nextInt();
            } while (++j < n && this.it.hasNext());
            this.batch = j;
            if (this.est != Long.MAX_VALUE) {
                this.est -= (long)j;
                return new IntArraySpliterator(a, 0, j, this.characteristics);
            }
            return new IntArraySpliterator(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public long getExactSizeIfKnown() {
        if ((this.characteristics & 0x40) == 0) {
            return -1L;
        }
        return this.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return (this.characteristics & characteristics) == characteristics;
    }

    @Override
    public Comparator<? super Integer> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }
}

