/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import xyz.wagyourtail.jvmdg.j8.intl.collections.BackingCollection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UnmodifiableNavigableCollection<E>
extends BackingCollection<E>
implements NavigableSet<E> {
    public static final UnmodifiableNavigableCollection EMPTY = new UnmodifiableNavigableCollection(new TreeSet());
    private final NavigableSet<E> backing;

    public UnmodifiableNavigableCollection(NavigableSet<E> backing) {
        super(Collections.unmodifiableSet(backing));
        this.backing = backing;
    }

    @Override
    public E lower(E e) {
        return this.backing.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.backing.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.backing.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.backing.higher(e);
    }

    @Override
    public E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new UnmodifiableNavigableCollection<E>(this.backing.descendingSet());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new UnmodifiableNavigableCollection<E>(this.backing.subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new UnmodifiableNavigableCollection<E>(this.backing.headSet(toElement, inclusive));
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new UnmodifiableNavigableCollection<E>(this.backing.tailSet(fromElement, inclusive));
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backing.comparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return Collections.unmodifiableSortedSet(this.backing.subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return Collections.unmodifiableSortedSet(this.backing.headSet(toElement));
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return Collections.unmodifiableSortedSet(this.backing.tailSet(fromElement));
    }

    @Override
    public E first() {
        return this.backing.first();
    }

    @Override
    public E last() {
        return this.backing.last();
    }
}

