/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import xyz.wagyourtail.jvmdg.j8.intl.collections.BackingCollection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CheckedNavigableSet<E>
extends BackingCollection<E>
implements NavigableSet<E> {
    private final NavigableSet<E> backing;
    private final Class<E> type;

    public CheckedNavigableSet(NavigableSet<E> backing, Class<E> type) {
        super(backing);
        this.backing = backing;
        this.type = type;
    }

    E typeCheck(Object o) {
        if (o != null && !this.type.isInstance(o)) {
            throw new ClassCastException(this.badElementMsg(o));
        }
        return (E)o;
    }

    private String badElementMsg(Object o) {
        return "Attempt to insert " + o.getClass() + " element into collection with element type " + this.type;
    }

    @Override
    public E lower(E e) {
        return this.backing.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.backing.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.backing.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.backing.higher(e);
    }

    @Override
    public E pollFirst() {
        return this.backing.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.backing.pollLast();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new CheckedNavigableSet<E>(this.backing.descendingSet(), this.type);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new CheckedNavigableSet<E>(this.backing.subSet(fromElement, fromInclusive, toElement, toInclusive), this.type);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new CheckedNavigableSet<E>(this.backing.headSet(toElement, inclusive), this.type);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new CheckedNavigableSet<E>(this.backing.tailSet(fromElement, inclusive), this.type);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backing.comparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return Collections.checkedSortedSet(this.backing.subSet(fromElement, toElement), this.type);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return Collections.checkedSortedSet(this.backing.headSet(toElement), this.type);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return Collections.checkedSortedSet(this.backing.tailSet(fromElement), this.type);
    }

    @Override
    public E first() {
        return this.backing.first();
    }

    @Override
    public E last() {
        return this.backing.last();
    }
}

