/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j25.stub.java_net_http;

import java.io.IOException;
import java.net.http.HttpResponse;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_N_H_HttpResponse {
    @Stub
    public static Optional<String> connectionLabel(HttpResponse<?> response) {
        return Optional.empty();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class BodySubscribers {
        @Stub(ref=@Ref(value="java/net/http/HttpResponse$BodySubscribers"))
        public static <T> HttpResponse.BodySubscriber<T> limiting(final HttpResponse.BodySubscriber<T> downstreamSubscriber, final long capacity) {
            Objects.requireNonNull(downstreamSubscriber, "downstreamSubscriber");
            if (capacity < 0L) {
                throw new IllegalArgumentException("capacity must not be negative: " + capacity);
            }
            return new HttpResponse.BodySubscriber<T>(){
                long remainingCapacity;
                Flow.Subscription subscription;
                boolean completed;
                {
                    this.remainingCapacity = capacity;
                }

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    Objects.requireNonNull(subscription, "subscription");
                    if (this.completed || this.subscription != null) {
                        subscription.cancel();
                    } else {
                        this.subscription = subscription;
                        downstreamSubscriber.onSubscribe(subscription);
                    }
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    Objects.requireNonNull(item, "item");
                    if (this.subscription == null) {
                        return;
                    }
                    try {
                        long size = item.stream().mapToLong(Buffer::remaining).reduce(0L, Math::addExact);
                        if (size > this.remainingCapacity) {
                            throw new ArithmeticException();
                        }
                        this.remainingCapacity -= size;
                        downstreamSubscriber.onNext(item);
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.completed = true;
                        this.subscription = null;
                        downstreamSubscriber.onError(new IOException("body exceeded capacity: " + capacity));
                        this.subscription.cancel();
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    Objects.requireNonNull(throwable, "throwable");
                    if (this.subscription != null) {
                        this.subscription = null;
                        this.completed = true;
                        downstreamSubscriber.onError(throwable);
                    }
                }

                @Override
                public void onComplete() {
                    if (this.subscription != null) {
                        this.subscription = null;
                        this.completed = true;
                        downstreamSubscriber.onComplete();
                    }
                }

                @Override
                public CompletionStage<T> getBody() {
                    return downstreamSubscriber.getBody();
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class BodyHandlers {
        @Stub(ref=@Ref(value="java/net/http/HttpResponse$BodyHandlers"))
        public static <T> HttpResponse.BodyHandler<T> limiting(HttpResponse.BodyHandler<T> downstreamHandler, long capacity) {
            Objects.requireNonNull(downstreamHandler, "downstreamHandler");
            if (capacity < 0L) {
                throw new IllegalArgumentException("capacity must not be negative: " + capacity);
            }
            return info -> {
                HttpResponse.BodySubscriber downstreamSubscriber = downstreamHandler.apply(info);
                return BodySubscribers.limiting(downstreamSubscriber, capacity);
            };
        }
    }
}

