/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j25.stub.java_base;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.random.RandomGenerator;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/ScopedValue")
public class J_L_ScopedValue<T> {
    private static final RandomGenerator KEY_GENERATOR = new Random();
    private final int hash = J_L_ScopedValue.generateHash();

    private static synchronized int generateHash() {
        return KEY_GENERATOR.nextInt();
    }

    public int hashCode() {
        return this.hash;
    }

    public static <T> J_L_ScopedValue<T> newInstance() {
        return new J_L_ScopedValue<T>();
    }

    public T get() {
        return Carrier.CURRENT.get().get(this);
    }

    public T orElse(T other) {
        return Carrier.CURRENT.get().orElse(this, other);
    }

    public T orElseThrow(Supplier<Throwable> other) throws Throwable {
        return Carrier.CURRENT.get().orElseThrow(this, other);
    }

    public static <T> Carrier where(J_L_ScopedValue<T> key, T value) {
        return new Carrier(Map.of(key, value));
    }

    public boolean isBound() {
        return Carrier.CURRENT.get().values.containsKey(this);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/ScopedValue$Carrier")
    public static class Carrier {
        private static final ThreadLocal<Carrier> CURRENT = ThreadLocal.withInitial(() -> new Carrier(Map.of()));
        private final Map<J_L_ScopedValue<?>, Object> values;

        private Carrier(Map<J_L_ScopedValue<?>, Object> values) {
            this.values = values;
        }

        public <T> Carrier where(J_L_ScopedValue<T> key, T value) {
            HashMap newValues = new HashMap(this.values);
            newValues.put(key, value);
            return new Carrier(newValues);
        }

        Carrier fallback(Carrier other) {
            HashMap newValues = new HashMap(other.values);
            newValues.putAll(this.values);
            return new Carrier(newValues);
        }

        public <T> T get(J_L_ScopedValue<T> key) {
            if (!this.values.containsKey(key)) {
                throw new NullPointerException("no mapping present");
            }
            return (T)this.values.get(key);
        }

        public <T> T orElse(J_L_ScopedValue<T> key, T other) {
            if (!this.values.containsKey(key)) {
                return other;
            }
            return (T)this.values.get(key);
        }

        public <T> T orElseThrow(J_L_ScopedValue<T> key, Supplier<Throwable> other) throws Throwable {
            if (!this.values.containsKey(key)) {
                throw other.get();
            }
            return (T)this.values.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R, X extends Throwable> R call(CallableOp<? extends R, X> op) throws X {
            Carrier prev = CURRENT.get();
            CURRENT.set(this.fallback(prev));
            try {
                R r = op.call();
                return r;
            }
            finally {
                CURRENT.set(prev);
            }
        }

        public void run(Runnable runnable) {
            Carrier prev = CURRENT.get();
            CURRENT.set(this.fallback(prev));
            try {
                runnable.run();
            }
            finally {
                CURRENT.set(prev);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    @Adapter(value="java/lang/ScopedValue$CallableOp")
    public static interface CallableOp<T, X extends Throwable> {
        public T call() throws X;
    }
}

