/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j21.stub.java_base;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.version.Modify;
import xyz.wagyourtail.jvmdg.version.Ref;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_R_SwitchBootstraps {
    @Modify(ref=@Ref(value="java/lang/runtime/SwitchBootstraps", member="typeSwitch", desc="(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;"))
    public static void makeTypeSwitch(MethodNode mnode, int i, ClassNode cnode, boolean noSynthetic) {
        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)mnode.instructions.get(i);
        ArrayList<Object> types = new ArrayList<Object>();
        for (Object bsmArg : indy.bsmArgs) {
            if (bsmArg instanceof ConstantDynamic) {
                ConstantDynamic condy = (ConstantDynamic)bsmArg;
                String type = condy.getDescriptor();
                if (!type.equals("Ljava/lang/Enum$EnumDesc;")) {
                    throw new IllegalStateException("Unknown condy type for switch: " + type);
                }
                ConstantDynamic cls = (ConstantDynamic)condy.getBootstrapMethodArgument(1);
                String clsName = (String)cls.getBootstrapMethodArgument(1);
                String value = (String)condy.getBootstrapMethodArgument(2);
                types.add(new EnumType(Type.getObjectType((String)clsName.replace('.', '/')), value));
                continue;
            }
            types.add(bsmArg);
        }
        MethodInsnNode min = J_L_R_SwitchBootstraps.makeSwitchInternal(mnode.name, indy.desc, types, cnode, noSynthetic);
        mnode.instructions.set((AbstractInsnNode)indy, (AbstractInsnNode)min);
    }

    @Modify(ref=@Ref(value="java/lang/runtime/SwitchBootstraps", member="enumSwitch", desc="(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;"))
    public static void makeEnumSwitch(MethodNode mnode, int i, ClassNode cnode, boolean noSynthetic) {
        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)mnode.instructions.get(i);
        Type[] argTypes = Type.getArgumentTypes((String)indy.desc);
        ArrayList<Object> types = new ArrayList<Object>();
        for (Object bsmArg : indy.bsmArgs) {
            if (bsmArg instanceof String) {
                String value = (String)bsmArg;
                types.add(new EnumType(argTypes[0], value));
                continue;
            }
            types.add(bsmArg);
        }
        MethodInsnNode min = J_L_R_SwitchBootstraps.makeSwitchInternal(mnode.name, indy.desc, types, cnode, noSynthetic);
        mnode.instructions.set((AbstractInsnNode)indy, (AbstractInsnNode)min);
    }

    public static MethodInsnNode makeSwitchInternal(String holdingMethod, String desc, List<Object> types, ClassNode cnode, boolean noSynthetic) {
        holdingMethod = holdingMethod.replace("<", "$").replace(">", "$");
        int i = 0;
        for (MethodNode mnode : cnode.methods) {
            if (!(mnode instanceof SwitchMethodNode)) continue;
            SwitchMethodNode smnode = (SwitchMethodNode)mnode;
            if (smnode.types.equals(types)) {
                return new MethodInsnNode(184, cnode.name, mnode.name, mnode.desc, (cnode.access & 0x200) != 0);
            }
            if (!mnode.name.equals("jvmdowngrader$switch$" + holdingMethod + "$" + i)) continue;
            ++i;
        }
        String name = "jvmdowngrader$switch$" + holdingMethod + "$" + i;
        SwitchMethodNode smnode = new SwitchMethodNode(0xA | (noSynthetic ? 0 : 4096), name, desc, types);
        smnode.visitCode();
        smnode.visitVarInsn(21, 1);
        Label l1 = new Label();
        smnode.visitJumpInsn(155, l1);
        smnode.visitVarInsn(21, 1);
        smnode.visitLdcInsn(types.size());
        smnode.visitJumpInsn(162, l1);
        Label l2 = new Label();
        smnode.visitJumpInsn(167, l2);
        smnode.visitLabel(l1);
        smnode.visitFrame(3, 0, null, 0, null);
        smnode.visitTypeInsn(187, "java/lang/IndexOutOfBoundsException");
        smnode.visitInsn(89);
        smnode.visitVarInsn(21, 1);
        smnode.visitLdcInsn(types.size());
        smnode.visitInvokeDynamicInsn("makeConcatWithConstants", "(II)Ljava/lang/String;", new Handle(6, "java/lang/invoke/StringConcatFactory", "makeConcatWithConstants", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false), new Object[]{"Index \u0001 out of bounds for length \u0001"});
        smnode.visitMethodInsn(183, "java/lang/IndexOutOfBoundsException", "<init>", "(Ljava/lang/String;)V", false);
        smnode.visitInsn(191);
        smnode.visitLabel(l2);
        smnode.visitFrame(3, 0, null, 0, null);
        smnode.visitVarInsn(25, 0);
        Label l0 = new Label();
        smnode.visitJumpInsn(199, l0);
        smnode.visitInsn(2);
        Label retLabel = new Label();
        smnode.visitJumpInsn(167, retLabel);
        smnode.visitLabel(l0);
        smnode.visitFrame(3, 0, null, 0, null);
        ArrayList<CaseLabels> labels = new ArrayList<CaseLabels>();
        ArrayList<Label> startLabels = new ArrayList<Label>();
        for (int j = 0; j < types.size(); ++j) {
            CaseLabels caseLabels = CaseLabels.create();
            labels.add(caseLabels);
            startLabels.add(caseLabels.start);
        }
        Label def = new Label();
        smnode.visitVarInsn(21, 1);
        smnode.visitTableSwitchInsn(0, labels.size() - 1, def, startLabels.toArray(new Label[0]));
        for (int j = 0; j < types.size(); ++j) {
            CaseLabels caseLabels = (CaseLabels)labels.get(j);
            smnode.visitLabel(caseLabels.start);
            smnode.visitFrame(3, 0, null, 0, null);
            Object type = types.get(j);
            if (type instanceof EnumType) {
                Object object;
                EnumType et = (EnumType)type;
                for (k = j + 1; k < types.size() && (object = types.get(k)) instanceof EnumType; ++k) {
                    EnumType ket = (EnumType)object;
                    if (!ket.type.equals((Object)et.type)) break;
                }
                if (--k != j) {
                    lastCaseLabels = (CaseLabels)labels.get(k);
                    hashWithLabels = new TreeSet<HashWithLabel>();
                    for (l = j; l <= k; ++l) {
                        EnumType ket = (EnumType)types.get(l);
                        hashWithLabels.add(new HashWithLabel(ket.value.hashCode(), ((CaseLabels)labels.get((int)l)).afterTypeCheck));
                    }
                    if (hashWithLabels.size() > 1) {
                        smnode.visitVarInsn(25, 0);
                        smnode.visitTypeInsn(193, et.type.getInternalName());
                        smnode.visitJumpInsn(153, lastCaseLabels.end);
                        smnode.visitVarInsn(25, 0);
                        smnode.visitTypeInsn(192, et.type.getInternalName());
                        smnode.visitMethodInsn(182, et.type.getInternalName(), "name", "()Ljava/lang/String;", false);
                        smnode.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
                        HashWithLabel[] hashWithLabelsArr = hashWithLabels.toArray(new HashWithLabel[0]);
                        hashCodes = new int[hashWithLabels.size()];
                        tableLabels = new Label[hashWithLabels.size()];
                        for (l = 0; l < hashWithLabelsArr.length; ++l) {
                            hashCodes[l] = hashWithLabelsArr[l].hash;
                            tableLabels[l] = hashWithLabelsArr[l].label;
                        }
                        smnode.visitLookupSwitchInsn(lastCaseLabels.end, hashCodes, tableLabels);
                    }
                }
                smnode.visitLabel(caseLabels.afterTypeCheck);
                smnode.visitFrame(3, 0, null, 0, null);
                smnode.visitLdcInsn(et.value);
                smnode.visitVarInsn(25, 0);
                smnode.visitTypeInsn(192, et.type.getInternalName());
                smnode.visitMethodInsn(182, et.type.getInternalName(), "name", "()Ljava/lang/String;", false);
                smnode.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
                smnode.visitJumpInsn(153, caseLabels.end);
                smnode.visitLdcInsn(j);
                smnode.visitJumpInsn(167, retLabel);
            } else if (type instanceof String) {
                for (k = j + 1; k < types.size() && types.get(k) instanceof String; ++k) {
                }
                if (--k != j) {
                    lastCaseLabels = (CaseLabels)labels.get(k);
                    hashWithLabels = new TreeSet();
                    for (l = j; l <= k; ++l) {
                        hashWithLabels.add(new HashWithLabel(types.get(l).hashCode(), ((CaseLabels)labels.get((int)l)).afterTypeCheck));
                    }
                    if (hashWithLabels.size() > 1) {
                        smnode.visitVarInsn(25, 0);
                        smnode.visitTypeInsn(193, "java/lang/String");
                        smnode.visitJumpInsn(153, lastCaseLabels.end);
                        smnode.visitVarInsn(25, 0);
                        smnode.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I", false);
                        HashWithLabel[] hashWithLabelsArr = hashWithLabels.toArray(new HashWithLabel[0]);
                        hashCodes = new int[hashWithLabels.size()];
                        tableLabels = new Label[hashWithLabels.size()];
                        for (l = 0; l < hashWithLabelsArr.length; ++l) {
                            hashCodes[l] = hashWithLabelsArr[l].hash;
                            tableLabels[l] = hashWithLabelsArr[l].label;
                        }
                        smnode.visitLookupSwitchInsn(lastCaseLabels.end, hashCodes, tableLabels);
                    }
                }
                smnode.visitLabel(caseLabels.afterTypeCheck);
                smnode.visitFrame(3, 0, null, 0, null);
                smnode.visitLdcInsn(type);
                smnode.visitVarInsn(25, 0);
                smnode.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
                smnode.visitJumpInsn(153, caseLabels.end);
                smnode.visitLdcInsn(j);
                smnode.visitJumpInsn(167, retLabel);
            } else if (type instanceof Integer) {
                for (k = j + 1; k < types.size() && types.get(k) instanceof Integer; ++k) {
                }
                if (--k != j) {
                    lastCaseLabels = (CaseLabels)labels.get(k);
                    hashWithLabels = new TreeSet();
                    for (l = j; l <= k; ++l) {
                        hashWithLabels.add(new HashWithLabel(types.get(l).hashCode(), ((CaseLabels)labels.get((int)l)).afterTypeCheck));
                    }
                    if (hashWithLabels.size() > 1) {
                        smnode.visitVarInsn(25, 0);
                        smnode.visitTypeInsn(193, "java/lang/Number");
                        smnode.visitVarInsn(25, 0);
                        smnode.visitTypeInsn(193, "java/lang/Character");
                        smnode.visitInsn(128);
                        smnode.visitJumpInsn(153, lastCaseLabels.end);
                        smnode.visitVarInsn(25, 0);
                        smnode.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I", false);
                        HashWithLabel[] hashWithLabelsArr = hashWithLabels.toArray(new HashWithLabel[0]);
                        hashCodes = new int[hashWithLabels.size()];
                        tableLabels = new Label[hashWithLabels.size()];
                        for (l = 0; l < hashWithLabelsArr.length; ++l) {
                            hashCodes[l] = hashWithLabelsArr[l].hash;
                            tableLabels[l] = hashWithLabelsArr[l].label;
                        }
                        smnode.visitLookupSwitchInsn(lastCaseLabels.end, hashCodes, tableLabels);
                    }
                }
                smnode.visitLabel(caseLabels.afterTypeCheck);
                smnode.visitFrame(3, 0, null, 0, null);
                smnode.visitVarInsn(25, 0);
                smnode.visitTypeInsn(193, "java/lang/Number");
                Label notnum = new Label();
                smnode.visitJumpInsn(153, notnum);
                smnode.visitVarInsn(25, 0);
                smnode.visitTypeInsn(192, "java/lang/Number");
                smnode.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
                smnode.visitLdcInsn(type);
                smnode.visitJumpInsn(159, notnum);
                smnode.visitLdcInsn(j);
                smnode.visitJumpInsn(167, retLabel);
                smnode.visitLabel(notnum);
                smnode.visitVarInsn(25, 0);
                smnode.visitTypeInsn(193, "java/lang/Character");
                smnode.visitJumpInsn(153, caseLabels.end);
                smnode.visitVarInsn(25, 0);
                smnode.visitTypeInsn(192, "java/lang/Character");
                smnode.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                smnode.visitLdcInsn(type);
                smnode.visitJumpInsn(159, caseLabels.end);
                smnode.visitLdcInsn(j);
                smnode.visitJumpInsn(167, retLabel);
            } else if (type instanceof Type) {
                smnode.visitVarInsn(25, 0);
                smnode.visitTypeInsn(193, ((Type)type).getInternalName());
                smnode.visitJumpInsn(153, caseLabels.end);
                smnode.visitLdcInsn(j);
                smnode.visitJumpInsn(167, retLabel);
            } else {
                throw new IllegalStateException("Unknown type for switch: " + String.valueOf(type));
            }
            smnode.visitLabel(caseLabels.end);
            smnode.visitFrame(3, 0, null, 0, null);
        }
        smnode.visitLabel(def);
        smnode.visitLdcInsn(types.size());
        smnode.visitLabel(retLabel);
        smnode.visitFrame(4, 0, null, 1, new Object[]{Opcodes.INTEGER});
        smnode.visitInsn(172);
        smnode.visitMaxs(0, 0);
        smnode.visitEnd();
        cnode.methods.add(smnode);
        return new MethodInsnNode(184, cnode.name, name, desc, (cnode.access & 0x200) != 0);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record EnumType(Type type, String value) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class SwitchMethodNode
    extends MethodNode {
        private final List<Object> types;

        public SwitchMethodNode(int access, String name, String descriptor, List<Object> types) {
            super(589824, access, name, descriptor, null, null);
            this.types = types;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CaseLabels(Label start, Label afterTypeCheck, Label end) {
        public static CaseLabels create() {
            return new CaseLabels(new Label(), new Label(), new Label());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record HashWithLabel(int hash, Label label) implements Comparable<HashWithLabel>
    {
        @Override
        public int hashCode() {
            return this.hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof HashWithLabel)) return false;
            HashWithLabel hwl = (HashWithLabel)obj;
            if (hwl.hash != this.hash) return false;
            return true;
        }

        @Override
        public int compareTo(@NotNull HashWithLabel o) {
            return Integer.compare(this.hash, o.hash);
        }
    }
}

