/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j21.stub.java_base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.RequiresResource;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Character {
    private static int[][] EMOJI_RANGES;
    private static int[][] EMOJI_COMPONENT_RANGES;
    private static int[][] EMOJI_MODIFIER_RANGES;
    private static int[][] EMOJI_MODIFIER_BASE_RANGES;
    private static int[][] EMOJI_PRESENTATION_RANGES;
    private static int[][] EXTENDED_PICTOGRAPHIC_RANGES;

    @RequiresResource(value={"unicode/emoji-data.txt"})
    private static void readData() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(J_L_Character.class.getResourceAsStream("/unicode/emoji-data.txt"))));){
            HashMap data = new HashMap();
            reader.lines().forEach(e -> {
                int[] range;
                if (e.startsWith("#")) {
                    return;
                }
                String before_comment = e.split("#")[0];
                String[] parts = before_comment.split(";");
                if (parts.length < 2) {
                    return;
                }
                String[] ranges = parts[0].trim().split("\\.\\.");
                if (ranges.length != 1 && ranges.length != 2) {
                    return;
                }
                range = new int[]{Integer.parseInt(ranges[0].trim(), 16), ranges.length == 2 ? Integer.parseInt(ranges[1].trim(), 16) : range[0]};
                data.computeIfAbsent(parts[1].trim(), k -> new ArrayList()).add(range);
            });
            EMOJI_RANGES = (int[][])((List)data.get("Emoji")).toArray((T[])new int[0][]);
            EMOJI_COMPONENT_RANGES = (int[][])((List)data.get("Emoji_Component")).toArray((T[])new int[0][]);
            EMOJI_MODIFIER_RANGES = (int[][])((List)data.get("Emoji_Modifier")).toArray((T[])new int[0][]);
            EMOJI_MODIFIER_BASE_RANGES = (int[][])((List)data.get("Emoji_Modifier_Base")).toArray((T[])new int[0][]);
            EMOJI_PRESENTATION_RANGES = (int[][])((List)data.get("Emoji_Presentation")).toArray((T[])new int[0][]);
            EXTENDED_PICTOGRAPHIC_RANGES = (int[][])((List)data.get("Extended_Pictographic")).toArray((T[])new int[0][]);
        }
    }

    @Stub(ref=@Ref(value="java/lang/Character"))
    public static boolean isEmoji(int codepoint) throws IOException {
        if (EMOJI_RANGES == null) {
            J_L_Character.readData();
        }
        for (int[] range : EMOJI_RANGES) {
            if (range[0] > codepoint || codepoint > range[1]) continue;
            return true;
        }
        return false;
    }

    @Stub(ref=@Ref(value="java/lang/Character"))
    public static boolean isEmojiComponent(int codepoint) throws IOException {
        if (EMOJI_COMPONENT_RANGES == null) {
            J_L_Character.readData();
        }
        for (int[] range : EMOJI_COMPONENT_RANGES) {
            if (range[0] > codepoint || codepoint > range[1]) continue;
            return true;
        }
        return false;
    }

    @Stub(ref=@Ref(value="java/lang/Character"))
    public static boolean isEmojiModifier(int codepoint) throws IOException {
        if (EMOJI_MODIFIER_RANGES == null) {
            J_L_Character.readData();
        }
        for (int[] range : EMOJI_MODIFIER_RANGES) {
            if (range[0] > codepoint || codepoint > range[1]) continue;
            return true;
        }
        return false;
    }

    @Stub(ref=@Ref(value="java/lang/Character"))
    public static boolean isEmojiModifierBase(int codepoint) throws IOException {
        if (EMOJI_MODIFIER_BASE_RANGES == null) {
            J_L_Character.readData();
        }
        for (int[] range : EMOJI_MODIFIER_BASE_RANGES) {
            if (range[0] > codepoint || codepoint > range[1]) continue;
            return true;
        }
        return false;
    }

    @Stub(ref=@Ref(value="java/lang/Character"))
    public static boolean isEmojiPresentation(int codepoint) throws IOException {
        if (EMOJI_PRESENTATION_RANGES == null) {
            J_L_Character.readData();
        }
        for (int[] range : EMOJI_PRESENTATION_RANGES) {
            if (range[0] > codepoint || codepoint > range[1]) continue;
            return true;
        }
        return false;
    }

    @Stub(ref=@Ref(value="java/lang/Character"))
    public static boolean isExtendedPictographic(int codepoint) throws IOException {
        if (EXTENDED_PICTOGRAPHIC_RANGES == null) {
            J_L_Character.readData();
        }
        for (int[] range : EXTENDED_PICTOGRAPHIC_RANGES) {
            if (range[0] > codepoint || codepoint > range[1]) continue;
            return true;
        }
        return false;
    }
}

