/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j20.stub.java_base;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import xyz.wagyourtail.jvmdg.j20.stub.java_base.J_L_R_ClassFileFormatVersion;
import xyz.wagyourtail.jvmdg.util.Function;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/reflect/AccessFlag")
public enum J_L_R_AccessFlag {
    PUBLIC(1, true, Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.CLASS, Location.FIELD, Location.METHOD);
        }
        return Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS);
    }),
    PRIVATE(2, true, Set.of(Location.FIELD, Location.METHOD, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.FIELD, Location.METHOD);
        }
        return Set.of(Location.FIELD, Location.METHOD, Location.INNER_CLASS);
    }),
    PROTECTED(4, true, Set.of(Location.FIELD, Location.METHOD, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.FIELD, Location.METHOD);
        }
        return Set.of(Location.FIELD, Location.METHOD, Location.INNER_CLASS);
    }),
    STATIC(8, true, Set.of(Location.FIELD, Location.METHOD, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.FIELD, Location.METHOD);
        }
        return Set.of(Location.FIELD, Location.METHOD, Location.INNER_CLASS);
    }),
    FINAL(16, true, Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.CLASS, Location.FIELD, Location.METHOD);
        }
        return Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS);
    }),
    SUPER(32, false, Set.of(Location.CLASS), null),
    OPEN(32, false, Set.of(Location.MODULE), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_9) >= 0) {
            return Set.of(Location.MODULE);
        }
        return Collections.emptySet();
    }),
    TRANSITIVE(32, false, Set.of(Location.MODULE_REQUIRES), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_9) >= 0) {
            return Set.of(Location.MODULE_REQUIRES);
        }
        return Collections.emptySet();
    }),
    SYNCHRONIZED(32, true, Set.of(Location.METHOD), null),
    STATIC_PHASE(64, false, Set.of(Location.MODULE_REQUIRES), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_9) >= 0) {
            return Set.of(Location.MODULE_REQUIRES);
        }
        return Collections.emptySet();
    }),
    VOLATILE(64, true, Set.of(Location.FIELD), null),
    BRIDGE(64, true, Set.of(Location.METHOD), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_5) >= 0) {
            return Set.of(Location.METHOD);
        }
        return Collections.emptySet();
    }),
    TRANSIENT(128, true, Set.of(Location.FIELD), null),
    VARARGS(128, true, Set.of(Location.METHOD), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_5) >= 0) {
            return Set.of(Location.METHOD);
        }
        return Collections.emptySet();
    }),
    NATIVE(256, true, Set.of(Location.METHOD), null),
    INTERFACE(512, true, Set.of(Location.CLASS, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.CLASS);
        }
        return Set.of(Location.CLASS, Location.INNER_CLASS);
    }),
    ABSTRACT(1024, true, Set.of(Location.CLASS, Location.METHOD, Location.INNER_CLASS), version -> {
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_0) {
            return Set.of(Location.CLASS, Location.METHOD);
        }
        return Set.of(Location.CLASS, Location.METHOD, Location.INNER_CLASS);
    }),
    STRICT(2048, true, Set.of(), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_2) >= 0 && version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_16) <= 0) {
            return Set.of(Location.METHOD);
        }
        return Collections.emptySet();
    }),
    SYNTHETIC(4096, false, Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS, Location.METHOD_PARAMETER, Location.MODULE, Location.MODULE_REQUIRES, Location.MODULE_EXPORTS, Location.MODULE_OPENS), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_9) >= 0) {
            return Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS, Location.METHOD_PARAMETER, Location.MODULE, Location.MODULE_REQUIRES, Location.MODULE_EXPORTS, Location.MODULE_OPENS);
        }
        return switch (version) {
            case J_L_R_ClassFileFormatVersion.RELEASE_7 -> Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS);
            case J_L_R_ClassFileFormatVersion.RELEASE_8 -> Set.of(Location.CLASS, Location.FIELD, Location.METHOD, Location.INNER_CLASS, Location.METHOD_PARAMETER);
            default -> Collections.emptySet();
        };
    }),
    ANNOTATION(8192, false, Set.of(Location.CLASS, Location.INNER_CLASS), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_5) >= 0) {
            return Set.of(Location.CLASS, Location.INNER_CLASS);
        }
        return Collections.emptySet();
    }),
    ENUM(16384, false, Set.of(Location.CLASS, Location.FIELD, Location.INNER_CLASS), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_5) >= 0) {
            return Set.of(Location.CLASS, Location.FIELD, Location.INNER_CLASS);
        }
        return Collections.emptySet();
    }),
    MANDATED(32768, false, Set.of(Location.METHOD_PARAMETER, Location.MODULE, Location.MODULE_REQUIRES, Location.MODULE_EXPORTS, Location.MODULE_OPENS), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_9) >= 0) {
            return Set.of(Location.CLASS);
        }
        if (version == J_L_R_ClassFileFormatVersion.RELEASE_8) {
            return Set.of(Location.METHOD_PARAMETER);
        }
        return Collections.emptySet();
    }),
    MODULE(32768, false, Set.of(Location.CLASS), version -> {
        if (version.compareTo(J_L_R_ClassFileFormatVersion.RELEASE_9) >= 0) {
            return Set.of(Location.CLASS);
        }
        return Collections.emptySet();
    });

    private final int mask;
    private final boolean sourceModifier;
    private final Set<Location> locations;
    private final Function<J_L_R_ClassFileFormatVersion, Set<Location>> locationsFunction;

    private J_L_R_AccessFlag(int mask, boolean sourceModifier, Set<Location> locations, Function<J_L_R_ClassFileFormatVersion, Set<Location>> locationsFunction) {
        this.mask = mask;
        this.sourceModifier = sourceModifier;
        this.locations = locations;
        this.locationsFunction = locationsFunction;
    }

    public static Set<J_L_R_AccessFlag> maskToAccessFlags(int mask, Location location) {
        EnumSet<J_L_R_AccessFlag> result = EnumSet.noneOf(J_L_R_AccessFlag.class);
        for (J_L_R_AccessFlag flag : J_L_R_AccessFlag.values()) {
            if (!flag.locations.contains((Object)location) || (mask & flag.mask) == 0) continue;
            result.add(flag);
            mask &= ~flag.mask;
        }
        if (mask != 0) {
            throw new IllegalArgumentException("Unmatched bit position 0x" + Integer.toHexString(mask) + " for location " + String.valueOf((Object)location));
        }
        return Collections.unmodifiableSet(result);
    }

    public int mask() {
        return this.mask;
    }

    public boolean sourceModifier() {
        return this.sourceModifier;
    }

    public Set<Location> locations() {
        return this.locations;
    }

    public Set<Location> locations(J_L_R_ClassFileFormatVersion version) {
        if (this.locationsFunction == null) {
            return this.locations;
        }
        return this.locationsFunction.apply(version);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/reflect/AccessFlag$Location")
    public static enum Location {
        CLASS,
        FIELD,
        METHOD,
        INNER_CLASS,
        METHOD_PARAMETER,
        MODULE,
        MODULE_REQUIRES,
        MODULE_EXPORTS,
        MODULE_OPENS;

    }
}

