/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j18.stub.java_base;

import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Math {
    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long floorDivExact(long x, long y) {
        long q = x / y;
        if ((x & y & q) >= 0L) {
            if ((x ^ y) < 0L && q * y != x) {
                return q - 1L;
            }
            return q;
        }
        throw new ArithmeticException("long overflow");
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int ceilDivExact(int x, int y) {
        int q = x / y;
        if ((x & y & q) >= 0) {
            if ((x ^ y) >= 0 && q * y != x) {
                return q + 1;
            }
            return q;
        }
        throw new ArithmeticException("integer overflow");
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int ceilDiv(int x, int y) {
        int q = x / y;
        if ((x ^ y) >= 0 && q * y != x) {
            return q + 1;
        }
        return q;
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long divideExact(long x, long y) {
        long q = x / y;
        if ((x & y & q) >= 0L) {
            return q;
        }
        throw new ArithmeticException("long overflow");
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long ceilDiv(long x, long y) {
        long q = x / y;
        if ((x ^ y) >= 0L && q * y != x) {
            return q + 1L;
        }
        return q;
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long unsignedMultiplyHigh(long x, long y) {
        long result = Math.multiplyHigh(x, y);
        result += y & x >> 63;
        return result += x & y >> 63;
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long ceilMod(long x, long y) {
        long r = x % y;
        if ((x ^ y) >= 0L && r != 0L) {
            return r - y;
        }
        return r;
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int ceilMod(long x, int y) {
        return (int)J_L_Math.ceilMod(x, (long)y);
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int floorDivExact(int x, int y) {
        int q = x / y;
        if ((x & y & q) >= 0) {
            if ((x ^ y) < 0 && q * y != x) {
                return q - 1;
            }
            return q;
        }
        throw new ArithmeticException("integer overflow");
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long ceilDivExact(long x, long y) {
        long q = x / y;
        if ((x & y & q) >= 0L) {
            if ((x ^ y) >= 0L && q * y != x) {
                return q + 1L;
            }
            return q;
        }
        throw new ArithmeticException("long overflow");
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int divideExact(int x, int y) {
        int q = x / y;
        if ((x & y & q) >= 0) {
            return q;
        }
        throw new ArithmeticException("integer overflow");
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static long ceilDiv(long x, int y) {
        return J_L_Math.ceilDiv(x, (long)y);
    }

    @Stub(ref=@Ref(value="Ljava/lang/Math;"))
    public static int ceilMod(int x, int y) {
        int r = x % y;
        if ((x ^ y) >= 0 && r != 0) {
            return r - y;
        }
        return r;
    }
}

