/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j17.stub.java_base;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.CoverageIgnore;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/HexFormat")
public record J_U_HexFormat(String delimiter, String prefix, String suffix, @CoverageIgnore char[] digits) {
    private static final char[] lowercase = "0123456789abcdef".toCharArray();
    private static final char[] uppercase = "0123456789ABCDEF".toCharArray();

    public static J_U_HexFormat of() {
        return new J_U_HexFormat("", "", "", lowercase);
    }

    public static J_U_HexFormat ofDelimiter(String delimiter) {
        return new J_U_HexFormat(delimiter, "", "", lowercase);
    }

    public static boolean isHexDigit(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    public static int fromHexDigit(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("not a hexadecimal digit: " + ch);
    }

    public static int fromHexDigits(CharSequence string) {
        return J_U_HexFormat.fromHexDigits(string, 0, string.length());
    }

    public static int fromHexDigits(CharSequence string, int offset, int toIndex) {
        Objects.requireNonNull(string, "string");
        Objects.checkFromToIndex(offset, toIndex, string.length());
        if (offset == toIndex) {
            throw new IllegalArgumentException("empty string");
        }
        int value = 0;
        for (int i = offset; i < toIndex; ++i) {
            value <<= 4;
            value |= J_U_HexFormat.fromHexDigit(string.charAt(i));
        }
        return value;
    }

    public static long fromHexDigitsToLong(CharSequence string) {
        return J_U_HexFormat.fromHexDigitsToLong(string, 0, string.length());
    }

    public static long fromHexDigitsToLong(CharSequence string, int offset, int toIndex) {
        Objects.requireNonNull(string, "string");
        Objects.checkFromToIndex(offset, toIndex, string.length());
        if (offset == toIndex) {
            throw new IllegalArgumentException("empty string");
        }
        long value = 0L;
        for (int i = offset; i < toIndex; ++i) {
            value <<= 4;
            value |= (long)J_U_HexFormat.fromHexDigit(string.charAt(i));
        }
        return value;
    }

    public J_U_HexFormat withDelimiter(String delimiter) {
        return new J_U_HexFormat(delimiter, this.prefix, this.suffix, this.digits);
    }

    public J_U_HexFormat withPrefix(String prefix) {
        return new J_U_HexFormat(this.delimiter, prefix, this.suffix, this.digits);
    }

    public J_U_HexFormat withSuffix(String suffix) {
        return new J_U_HexFormat(this.delimiter, this.prefix, suffix, this.digits);
    }

    public J_U_HexFormat withUpperCase() {
        return new J_U_HexFormat(this.delimiter, this.prefix, this.suffix, uppercase);
    }

    public J_U_HexFormat withLowerCase() {
        return new J_U_HexFormat(this.delimiter, this.prefix, this.suffix, lowercase);
    }

    public boolean isUpperCase() {
        return Arrays.equals(this.digits, uppercase);
    }

    public String formatHex(byte[] bytes) {
        return this.formatHex(bytes, 0, bytes.length);
    }

    public String formatHex(byte[] bytes, int offset, int toIndex) {
        Objects.requireNonNull(bytes, "bytes");
        Objects.checkFromToIndex(offset, toIndex, bytes.length);
        if (toIndex == offset) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < toIndex; ++i) {
            if (i != offset) {
                sb.append(this.delimiter);
            }
            sb.append(this.prefix);
            sb.append(this.digits[bytes[i] >> 4 & 0xF]);
            sb.append(this.digits[bytes[i] & 0xF]);
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public <A extends Appendable> A formatHex(A out, byte[] bytes) {
        return this.formatHex(out, bytes, 0, bytes.length);
    }

    public <A extends Appendable> A formatHex(A out, byte[] bytes, int offset, int toIndex) {
        Objects.requireNonNull(bytes, "bytes");
        Objects.checkFromToIndex(offset, toIndex, bytes.length);
        if (toIndex == offset) {
            return out;
        }
        try {
            for (int i = offset; i < toIndex; ++i) {
                if (i != offset) {
                    out.append(this.delimiter);
                }
                out.append(this.prefix);
                out.append(this.digits[bytes[i] >> 4 & 0xF]);
                out.append(this.digits[bytes[i] & 0xF]);
                out.append(this.suffix);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return out;
    }

    public byte[] parseHex(CharSequence string) {
        return this.parseHex(string, 0, string.length());
    }

    public byte[] parseHex(CharSequence string, int offset, int toIndex) {
        Objects.requireNonNull(string, "string");
        Objects.checkFromToIndex(offset, toIndex, string.length());
        if (offset == toIndex) {
            return new byte[0];
        }
        int len = toIndex - offset;
        long valueLength = this.prefix.length() + 2 + this.suffix.length();
        long stepLength = valueLength + (long)this.delimiter.length();
        if (((long)string.length() - valueLength) % stepLength != 0L) {
            throw new IllegalArgumentException("extra or missing delimiters or values consisting of prefix, two hexadecimal digits, and suffix");
        }
        int byteCount = (int)((long)(len + this.delimiter.length()) / stepLength);
        byte[] bytes = new byte[byteCount];
        for (int i = 0; i < byteCount; ++i) {
            int start = offset + (int)((long)i * stepLength);
            if (i != 0 && !this.delimiter.isEmpty() && !string.subSequence(start - this.delimiter.length(), start).toString().equals(this.delimiter)) {
                throw new IllegalArgumentException(("found: \"" + string.subSequence(start - this.delimiter.length(), start) + "\", expected: \"" + this.delimiter + "\", index: " + start).replace("\r", "\\r").replace("\n", "\\n"));
            }
            if (!this.prefix.isEmpty() && !string.subSequence(start, start + this.prefix.length()).toString().equals(this.prefix)) {
                throw new IllegalArgumentException(("found: \"" + string.subSequence(start, start + this.prefix.length()) + "\", expected: \"" + this.prefix + "\", index: " + start).replace("\r", "\\r").replace("\n", "\\n"));
            }
            int high = J_U_HexFormat.fromHexDigit(string.charAt(start + this.prefix.length()));
            int low = J_U_HexFormat.fromHexDigit(string.charAt(start + this.prefix.length() + 1));
            int value = high << 4 | low;
            bytes[i] = (byte)value;
            if (this.suffix.isEmpty() || string.subSequence(start + this.prefix.length() + 2, (int)((long)start + valueLength)).toString().equals(this.suffix)) continue;
            throw new IllegalArgumentException(("found: \"" + string.subSequence(start + this.prefix.length() + 2, (int)((long)start + valueLength)) + "\", expected: \"" + this.suffix + "\", index: " + start).replace("\r", "\\r").replace("\n", "\\n"));
        }
        return bytes;
    }

    public byte[] parseHex(char[] chars, int offset, int toIndex) {
        Objects.requireNonNull(chars, "chars");
        Objects.checkFromToIndex(offset, toIndex, chars.length);
        if (offset == toIndex) {
            return new byte[0];
        }
        return this.parseHex(CharBuffer.wrap(chars, offset, toIndex - offset));
    }

    public char toLowHexDigit(int value) {
        return this.digits[value & 0xF];
    }

    public char toHighHexDigit(int value) {
        return this.digits[value >> 4 & 0xF];
    }

    public <A extends Appendable> A toHexDigits(A out, byte value) {
        try {
            out.append(this.digits[value >> 4 & 0xF]);
            out.append(this.digits[value & 0xF]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return out;
    }

    public String toHexDigits(byte value) {
        return new String(new char[]{this.digits[value >> 4 & 0xF], this.digits[value & 0xF]});
    }

    public String toHexDigits(char value) {
        return this.toHexDigits((short)value);
    }

    public String toHexDigits(short value) {
        return new String(new char[]{this.digits[value >> 12 & 0xF], this.digits[value >> 8 & 0xF], this.digits[value >> 4 & 0xF], this.digits[value & 0xF]});
    }

    public String toHexDigits(int value) {
        return new String(new char[]{this.digits[value >> 28 & 0xF], this.digits[value >> 24 & 0xF], this.digits[value >> 20 & 0xF], this.digits[value >> 16 & 0xF], this.digits[value >> 12 & 0xF], this.digits[value >> 8 & 0xF], this.digits[value >> 4 & 0xF], this.digits[value & 0xF]});
    }

    public String toHexDigits(long value) {
        return new String(new char[]{this.digits[(int)(value >> 60 & 0xFL)], this.digits[(int)(value >> 56 & 0xFL)], this.digits[(int)(value >> 52 & 0xFL)], this.digits[(int)(value >> 48 & 0xFL)], this.digits[(int)(value >> 44 & 0xFL)], this.digits[(int)(value >> 40 & 0xFL)], this.digits[(int)(value >> 36 & 0xFL)], this.digits[(int)(value >> 32 & 0xFL)], this.digits[(int)(value >> 28 & 0xFL)], this.digits[(int)(value >> 24 & 0xFL)], this.digits[(int)(value >> 20 & 0xFL)], this.digits[(int)(value >> 16 & 0xFL)], this.digits[(int)(value >> 12 & 0xFL)], this.digits[(int)(value >> 8 & 0xFL)], this.digits[(int)(value >> 4 & 0xFL)], this.digits[(int)(value & 0xFL)]});
    }

    public String toHexDigits(long value, int digits) {
        if (digits < 0 || digits > 16) {
            throw new IllegalArgumentException("number of digits: " + digits);
        }
        if (digits == 0) {
            return "";
        }
        char[] chars = new char[digits];
        for (int i = digits - 1; i >= 0; --i) {
            chars[i] = this.digits[(int)(value & 0xFL)];
            value >>= 4;
        }
        return new String(chars);
    }
}

