/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j17.impl.random;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.SplittableRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j17.stub.java_base.J_U_R_RandomGenerator;
import xyz.wagyourtail.jvmdg.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SplittableRandomGeneratorImpl
implements J_U_R_RandomGenerator.SplittableGenerator {
    private static final MethodHandles.Lookup IMPL_LOOKUP = Utils.getImplLookup();
    private static final MethodHandle CTOR;
    private final SplittableRandom random;

    public SplittableRandomGeneratorImpl(SplittableRandom random) {
        this.random = random;
    }

    private static long mixGamma(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        int n = Long.bitCount((z = z ^ z >>> 33 | 1L) ^ z >>> 1);
        return n < 24 ? z ^ 0xAAAAAAAAAAAAAAAAL : z;
    }

    @Override
    public J_U_R_RandomGenerator.SplittableGenerator split() {
        return new SplittableRandomGeneratorImpl(this.random.split());
    }

    @Override
    public J_U_R_RandomGenerator.SplittableGenerator split(J_U_R_RandomGenerator.SplittableGenerator source) {
        try {
            return new SplittableRandomGeneratorImpl(CTOR.invoke(source.nextLong(), SplittableRandomGeneratorImpl.mixGamma(source.nextLong())));
        }
        catch (Throwable e) {
            Utils.sneakyThrow(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    public Stream<J_U_R_RandomGenerator.SplittableGenerator> splits() {
        return J_U_R_RandomGenerator.SplittableGenerator.super.splits();
    }

    @Override
    public Stream<J_U_R_RandomGenerator.SplittableGenerator> splits(long size) {
        return this.splits().limit(size);
    }

    @Override
    public Stream<J_U_R_RandomGenerator.SplittableGenerator> splits(J_U_R_RandomGenerator.SplittableGenerator source) {
        return Stream.generate(() -> this.split(source));
    }

    @Override
    public Stream<J_U_R_RandomGenerator.SplittableGenerator> splits(long size, J_U_R_RandomGenerator.SplittableGenerator source) {
        return this.splits(source).limit(size);
    }

    @Override
    public Stream<J_U_R_RandomGenerator> rngs() {
        return J_U_R_RandomGenerator.SplittableGenerator.super.rngs();
    }

    @Override
    public Stream<J_U_R_RandomGenerator> rngs(long limit) {
        return J_U_R_RandomGenerator.SplittableGenerator.super.rngs(limit);
    }

    @Override
    public DoubleStream doubles() {
        return this.random.doubles();
    }

    @Override
    public DoubleStream doubles(double lower, double upper) {
        return this.random.doubles(lower, upper);
    }

    @Override
    public DoubleStream doubles(long limit) {
        return this.random.doubles(limit);
    }

    @Override
    public DoubleStream doubles(long limit, double origin, double bound) {
        return this.random.doubles(limit, origin, bound);
    }

    @Override
    public IntStream ints() {
        return this.random.ints();
    }

    @Override
    public IntStream ints(int origin, int bound) {
        return this.random.ints(origin, bound);
    }

    @Override
    public IntStream ints(long limit) {
        return this.random.ints(limit);
    }

    @Override
    public IntStream ints(long limit, int origin, int bound) {
        return this.random.ints(limit, origin, bound);
    }

    @Override
    public LongStream longs() {
        return this.random.longs();
    }

    @Override
    public LongStream longs(long origin, long bound) {
        return this.random.longs(origin, bound);
    }

    @Override
    public LongStream longs(long limit) {
        return this.random.longs(limit);
    }

    @Override
    public LongStream longs(long limit, long origin, long bound) {
        return this.random.longs(limit, origin, bound);
    }

    @Override
    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    @Override
    public float nextFloat() {
        return J_U_R_RandomGenerator.SplittableGenerator.super.nextFloat();
    }

    @Override
    public float nextFloat(float bound) {
        return J_U_R_RandomGenerator.SplittableGenerator.super.nextFloat(bound);
    }

    @Override
    public float nextFloat(float origin, float bound) {
        return J_U_R_RandomGenerator.SplittableGenerator.super.nextFloat(origin, bound);
    }

    @Override
    public double nextDouble() {
        return this.random.nextDouble();
    }

    @Override
    public double nextDouble(double bound) {
        return this.random.nextDouble(bound);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        return this.random.nextDouble(origin, bound);
    }

    @Override
    public int nextInt() {
        return this.random.nextInt();
    }

    @Override
    public int nextInt(int bound) {
        return this.random.nextInt(bound);
    }

    @Override
    public int nextInt(int origin, int bound) {
        return this.random.nextInt(origin, bound);
    }

    @Override
    public long nextLong() {
        return this.random.nextLong();
    }

    @Override
    public long nextLong(long bound) {
        return this.random.nextLong(bound);
    }

    @Override
    public long nextLong(long origin, long bound) {
        return this.random.nextLong(origin, bound);
    }

    @Override
    public double nextGaussian() {
        return J_U_R_RandomGenerator.SplittableGenerator.super.nextGaussian();
    }

    @Override
    public double nextGaussian(double mean, double stdDev) {
        return J_U_R_RandomGenerator.SplittableGenerator.super.nextGaussian(mean, stdDev);
    }

    @Override
    public double nextExponential() {
        return J_U_R_RandomGenerator.SplittableGenerator.super.nextExponential();
    }

    static {
        try {
            CTOR = IMPL_LOOKUP.findConstructor(SplittableRandom.class, MethodType.methodType(Void.TYPE, Long.TYPE, Long.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

