/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j16.stub.java_net_http;

import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.BiPredicate;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_N_H_HttpRequest {
    @Stub(ref=@Ref(value="Ljava/net/http/HttpRequest;"))
    public static HttpRequest.Builder newBuilder(HttpRequest request, BiPredicate<String, String> filter) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(filter);
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(request.uri());
        builder.expectContinue(request.expectContinue());
        HttpHeaders headers = HttpHeaders.of(request.headers().map(), filter);
        for (Map.Entry<String, List<String>> entry : headers.map().entrySet()) {
            for (String value : entry.getValue()) {
                builder.header(entry.getKey(), value);
            }
        }
        request.version().ifPresent(builder::version);
        request.timeout().ifPresent(builder::timeout);
        String method = request.method();
        Optional<HttpRequest.BodyPublisher> publisher = request.bodyPublisher();
        if (publisher.isPresent()) {
            builder.method(method, publisher.get());
        } else {
            switch (method) {
                case "GET": {
                    builder.GET();
                    break;
                }
                case "DELETE": {
                    builder.DELETE();
                    break;
                }
                default: {
                    builder.method(method, HttpRequest.BodyPublishers.noBody());
                }
            }
        }
        return builder;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class BodyPublishers {
        @Stub(ref=@Ref(value="java/net/http/HttpRequest$BodyPublishers"))
        public static HttpRequest.BodyPublisher concat(final HttpRequest.BodyPublisher ... publishers) {
            return new HttpRequest.BodyPublisher(){

                @Override
                public long contentLength() {
                    long sum = 0L;
                    for (HttpRequest.BodyPublisher publisher : publishers) {
                        sum += publisher.contentLength();
                    }
                    return sum;
                }

                @Override
                public void subscribe(final Flow.Subscriber<? super ByteBuffer> subscriber) {
                    subscriber.onSubscribe(new Flow.Subscription(){
                        private final Iterator<HttpRequest.BodyPublisher> iterator;
                        private boolean completed;
                        {
                            this.iterator = List.of(publishers).iterator();
                        }

                        @Override
                        public void request(long n) {
                            if (n <= 0L) {
                                subscriber.onError(new IllegalArgumentException("n <= 0"));
                                return;
                            }
                            if (this.completed) {
                                return;
                            }
                            try {
                                while (n > 0L) {
                                    if (!this.iterator.hasNext()) {
                                        this.completed = true;
                                        subscriber.onComplete();
                                        return;
                                    }
                                    HttpRequest.BodyPublisher publisher = this.iterator.next();
                                    final long contentLength = publisher.contentLength();
                                    if (contentLength > 0L) {
                                        publisher.subscribe(new Flow.Subscriber<ByteBuffer>(){
                                            private long remaining;
                                            {
                                                this.remaining = contentLength;
                                            }

                                            @Override
                                            public void onSubscribe(Flow.Subscription subscription) {
                                                subscription.request(Long.MAX_VALUE);
                                            }

                                            @Override
                                            public void onNext(ByteBuffer item) {
                                                subscriber.onNext(item);
                                                this.remaining -= (long)item.remaining();
                                                if (this.remaining == 0L) {
                                                    subscriber.onComplete();
                                                }
                                            }

                                            @Override
                                            public void onError(Throwable throwable) {
                                                subscriber.onError(throwable);
                                            }

                                            @Override
                                            public void onComplete() {
                                            }
                                        });
                                    } else {
                                        publisher.subscribe(new Flow.Subscriber<ByteBuffer>(){

                                            @Override
                                            public void onSubscribe(Flow.Subscription subscription) {
                                                subscription.request(Long.MAX_VALUE);
                                            }

                                            @Override
                                            public void onNext(ByteBuffer item) {
                                                subscriber.onNext(item);
                                            }

                                            @Override
                                            public void onError(Throwable throwable) {
                                                subscriber.onError(throwable);
                                            }

                                            @Override
                                            public void onComplete() {
                                                subscriber.onComplete();
                                            }
                                        });
                                    }
                                    --n;
                                }
                            }
                            catch (Throwable t) {
                                subscriber.onError(t);
                            }
                        }

                        @Override
                        public void cancel() {
                            this.completed = true;
                        }
                    });
                }
            };
        }
    }
}

