/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j15.stub.java_base;

import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_String {
    @Stub
    public static String stripIndent(String str) {
        int len = str.length();
        if (len == 0) {
            return "";
        }
        String[] lines = str.split("\r\n|\r|\n", -1);
        int minIndent = Integer.MAX_VALUE;
        for (int i = 0; i < lines.length; ++i) {
            int indent;
            String line = lines[i];
            if (line.isEmpty() && i < lines.length - 1) continue;
            for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
            }
            if (indent >= minIndent) continue;
            minIndent = indent;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.isEmpty() && i < lines.length - 1) {
                sb.append("\n");
                continue;
            }
            line = line.stripTrailing();
            sb.append(line.substring(minIndent));
            if (i >= lines.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Stub
    public static String translateEscapes(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\\') {
                if (i + 1 < chars.length) {
                    char d = chars[++i];
                    switch (d) {
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 's': {
                            c = ' ';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case '\n': 
                        case '\r': 
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            c = d;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int limit = Math.min(d < '4' ? 2 : 1, chars.length - i);
                            int code = d - 48;
                            for (int k = 1; k < limit; ++k) {
                                char e = chars[i + 1];
                                if (e < '0' || e > '9') continue;
                                code = code * 10 + e - 48;
                                ++i;
                            }
                            c = (char)code;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Invalid escape sequence: \\%c \\\\u%04X", Character.valueOf(d), (int)d));
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Invalid escape sequence: \\EOS");
                }
            }
            chars[j++] = c;
        }
        return new String(chars, 0, j);
    }

    @Stub
    public static String formatted(String str, Object ... args) {
        return String.format(str, args);
    }
}

