/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_base;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_I_Reader {
    @Stub(ref=@Ref(value="Ljava/io/Reader;"))
    public static Reader nullReader() {
        return new NullReader();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class NullReader
    extends Reader {
        private volatile boolean closed;

        @Override
        public int read(CharBuffer target) throws IOException {
            Objects.requireNonNull(target);
            this.ensureOpen();
            if (target.hasRemaining()) {
                return -1;
            }
            return 0;
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            return -1;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            Objects.checkFromIndexSize(off, len, cbuf.length);
            this.ensureOpen();
            if (len == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            return 0L;
        }

        @Override
        public boolean ready() throws IOException {
            this.ensureOpen();
            return false;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public long transferTo(Writer out) throws IOException {
            Objects.requireNonNull(out);
            this.ensureOpen();
            return 0L;
        }
    }
}

