/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.impl.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StreamIterator
implements Iterator<ByteBuffer> {
    public static final int BUFSIZE = Integer.parseInt(System.getProperty("jdk.httpclient.bufsize", "16384"));
    final InputStream is;
    final Supplier<? extends ByteBuffer> bufSupplier;
    volatile ByteBuffer nextBuffer;
    volatile boolean need2Read = true;
    volatile boolean haveNext;
    private volatile boolean eof;

    public StreamIterator(InputStream is) {
        this(is, () -> ByteBuffer.allocate(BUFSIZE));
    }

    StreamIterator(InputStream is, Supplier<? extends ByteBuffer> bufSupplier) {
        this.is = is;
        this.bufSupplier = bufSupplier;
    }

    private int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.nextBuffer = this.bufSupplier.get();
        this.nextBuffer.clear();
        byte[] buf = this.nextBuffer.array();
        int offset = this.nextBuffer.arrayOffset();
        int cap = this.nextBuffer.capacity();
        int n = this.is.read(buf, offset, cap);
        if (n == -1) {
            this.eof = true;
            return -1;
        }
        this.nextBuffer.limit(n);
        this.nextBuffer.position(0);
        return n;
    }

    private void closeStream() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.need2Read) {
            try {
                boolean bl = this.haveNext = this.read() != -1;
                if (this.haveNext) {
                    this.need2Read = false;
                }
            }
            catch (IOException e) {
                this.haveNext = false;
                this.need2Read = false;
                throw new UncheckedIOException(e);
            }
            finally {
                if (!this.haveNext) {
                    this.closeStream();
                }
            }
        }
        return this.haveNext;
    }

    @Override
    public synchronized ByteBuffer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.need2Read = true;
        return this.nextBuffer;
    }
}

