/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.impl.http;

import java.util.Iterator;
import java.util.concurrent.Flow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IterablePublisher<T>
implements Flow.Publisher<T> {
    private final Iterable<T> iterable;
    private final Throwable throwable;

    public IterablePublisher(Iterable<T> iterable, Throwable throwable) {
        this.iterable = iterable;
        this.throwable = throwable;
    }

    public IterablePublisher(Iterable<T> iterable) {
        this(iterable, null);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(new Subscription(subscriber));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class Subscription
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final Iterator<T> iterator;
        private volatile boolean completed;
        private volatile boolean cancelled;
        private volatile Throwable error;

        public Subscription(Flow.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            this.iterator = IterablePublisher.this.iterable.iterator();
            this.error = IterablePublisher.this.throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.subscriber.onError(new IllegalArgumentException("n <= 0"));
                return;
            }
            if (this.completed || this.cancelled) {
                return;
            }
            if (this.error != null) {
                this.completed = true;
                this.subscriber.onError(this.error);
                return;
            }
            try {
                Subscription subscription = this;
                synchronized (subscription) {
                    for (long i = 0L; i < n && !this.cancelled; ++i) {
                        if (!this.iterator.hasNext()) {
                            this.completed = true;
                            this.subscriber.onComplete();
                            break;
                        }
                        this.subscriber.onNext(this.iterator.next());
                    }
                }
            }
            catch (Throwable t) {
                this.error = t;
                this.subscriber.onError(t);
                this.completed = true;
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }
}

