/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.impl.http;

import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpRequestBuilderImpl;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HttpRequestImpl
extends J_N_H_HttpRequest {
    URI uri;
    boolean expectContinue;
    J_N_H_HttpClient.Version version;
    Map<String, List<String>> headers = new HashMap<String, List<String>>();
    Duration timeout;
    String method;
    J_N_H_HttpRequest.BodyPublisher publisher;

    public HttpRequestImpl(HttpRequestBuilderImpl builder) {
        this.uri = builder.uri;
        this.expectContinue = builder.expectContinue;
        this.version = builder.version;
        builder.headers.forEach((k, v) -> this.headers.put((String)k, List.copyOf(v)));
        this.timeout = builder.timeout;
        this.method = builder.method;
        this.publisher = builder.publisher;
    }

    @Override
    public Optional<J_N_H_HttpRequest.BodyPublisher> bodyPublisher() {
        return Optional.ofNullable(this.publisher);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Optional<Duration> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Override
    public boolean expectContinue() {
        return this.expectContinue;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Optional<J_N_H_HttpClient.Version> version() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public J_N_H_HttpHeaders headers() {
        return new J_N_H_HttpHeaders(this.headers);
    }
}

