/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.impl.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ForkJoinPool;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpClientBuilderImpl;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpRequestImpl;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpResponseImpl;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpResponseInfo;
import xyz.wagyourtail.jvmdg.j11.impl.http.StreamIterator;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpResponse;
import xyz.wagyourtail.jvmdg.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HttpClientImpl
extends J_N_H_HttpClient {
    CookieHandler cookieHandler;
    Duration connectTimeout;
    J_N_H_HttpClient.Redirect followRedirects;
    ProxySelector proxy;
    Authenticator authenticator;
    J_N_H_HttpClient.Version version;
    Executor executor;
    SSLContext sslContext;
    SSLParameters sslParams;
    int priority = -1;

    public HttpClientImpl(HttpClientBuilderImpl builder) {
        this.cookieHandler = builder.cookieHandler;
        this.connectTimeout = builder.connectTimeout;
        this.followRedirects = builder.followRedirects;
        this.proxy = builder.proxy;
        this.authenticator = builder.authenticator;
        this.version = builder.version;
        this.executor = builder.executor;
        this.sslContext = builder.sslContext;
        this.sslParams = builder.sslParams;
        this.priority = builder.priority;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return Optional.ofNullable(this.cookieHandler);
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    public J_N_H_HttpClient.Redirect followRedirects() {
        return this.followRedirects;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public SSLParameters sslParameters() {
        return this.sslParams;
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    @Override
    public J_N_H_HttpClient.Version version() {
        return this.version;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.ofNullable(this.executor);
    }

    @Override
    public <T> J_N_H_HttpResponse<T> send(J_N_H_HttpRequest var1, J_N_H_HttpResponse.BodyHandler<T> handler) throws IOException, InterruptedException {
        return this.sendImpl(var1, handler, null);
    }

    protected static void putHeaders(URLConnection connection, String key, List<String> values) {
        if (values.isEmpty()) {
            return;
        }
        if (key.equalsIgnoreCase("cookie")) {
            connection.setRequestProperty("Cookie", String.join((CharSequence)"; ", values));
        } else {
            Iterator<String> iter = values.iterator();
            connection.setRequestProperty(key, iter.next());
            while (iter.hasNext()) {
                connection.addRequestProperty(key, iter.next());
            }
        }
    }

    protected <T> J_N_H_HttpResponse<T> sendImpl(J_N_H_HttpRequest var1, J_N_H_HttpResponse.BodyHandler<T> handler, J_N_H_HttpResponse.PushPromiseHandler<T> pushPromiseHandler) throws IOException, InterruptedException {
        HttpURLConnection connection;
        Objects.requireNonNull(var1);
        Objects.requireNonNull(handler);
        if (var1.method().equals("CONNECT")) {
            throw new IllegalArgumentException("Unsupported method CONNECT");
        }
        if (this.proxy != null) {
            Proxy p = this.proxy.select(var1.uri()).stream().findFirst().orElse(Proxy.NO_PROXY);
            connection = (HttpURLConnection)var1.uri().toURL().openConnection(p);
        } else {
            connection = (HttpURLConnection)var1.uri().toURL().openConnection();
        }
        connection.setRequestMethod(var1.method());
        connection.setInstanceFollowRedirects(this.followRedirects != J_N_H_HttpClient.Redirect.NEVER);
        if (this.connectTimeout != null) {
            connection.setConnectTimeout((int)this.connectTimeout.toMillis());
        }
        var1.timeout().ifPresent(t -> connection.setReadTimeout((int)t.toMillis()));
        connection.setDoOutput(var1.bodyPublisher().isPresent());
        connection.setDoInput(handler != J_N_H_HttpResponse.BodyHandlers.discarding());
        connection.setAllowUserInteraction(false);
        HttpRequestImpl request = (HttpRequestImpl)var1;
        HashMap<Object, Object> headers = new HashMap<String, List>();
        for (Map.Entry<String, List<String>> entry : request.headers.entrySet()) {
            headers.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        if (this.cookieHandler != null) {
            for (Map.Entry<String, List<String>> entry : this.cookieHandler.get(var1.uri(), request.headers).entrySet()) {
                headers.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            HttpClientImpl.putHeaders(connection, entry.getKey(), entry.getValue());
        }
        J_N_H_HttpRequest.BodyPublisher publisher = request.publisher;
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
            SSLSocketFactory sslSocketFactory = httpsURLConnection.getSSLSocketFactory();
            if (this.sslContext != null) {
                sslSocketFactory = this.sslContext.getSocketFactory();
            }
            if (this.sslParams != null) {
                sslSocketFactory = new SSLParamSocketFactory(sslSocketFactory, this.sslParams);
            }
            httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
        }
        connection.connect();
        if (publisher != null) {
            final OutputStream outputStream = connection.getOutputStream();
            publisher.subscribe(new Flow.Subscriber<ByteBuffer>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(ByteBuffer item) {
                    try {
                        outputStream.write(item.array(), item.arrayOffset() + item.position(), item.remaining());
                        item.position(item.limit());
                    }
                    catch (IOException e) {
                        Utils.sneakyThrow(e);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.addSuppressed(throwable);
                        Utils.sneakyThrow(e);
                    }
                    Utils.sneakyThrow(throwable);
                }

                @Override
                public void onComplete() {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        Utils.sneakyThrow(e);
                    }
                }
            });
        }
        int n = connection.getResponseCode();
        headers = new HashMap<String, List<String>>(connection.getHeaderFields());
        if (this.cookieHandler != null) {
            this.cookieHandler.put(var1.uri(), headers);
        }
        headers.remove(null);
        J_N_H_HttpClient.Version version = J_N_H_HttpClient.Version.HTTP_1_1;
        HttpResponseInfo info = new HttpResponseInfo(n, new J_N_H_HttpHeaders(headers), version);
        J_N_H_HttpResponse.BodySubscriber<T> subscriber = handler.apply(info);
        CompletableFuture.runAsync(() -> {
            try (InputStream is = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
                int bytesRead;
                byte[] buffer = new byte[StreamIterator.BUFSIZE];
                while ((bytesRead = is.read(buffer, 0, buffer.length)) != -1) {
                    subscriber.onNext(List.of(ByteBuffer.wrap(buffer, 0, bytesRead)));
                    buffer = new byte[StreamIterator.BUFSIZE];
                }
                subscriber.onComplete();
            }
            catch (IOException e) {
                subscriber.onError(e);
            }
        }, this.executor == null ? ForkJoinPool.commonPool() : this.executor);
        T body = subscriber.getBody().toCompletableFuture().join();
        return new HttpResponseImpl<T>(var1, info, body, null);
    }

    @Override
    public <T> CompletableFuture<J_N_H_HttpResponse<T>> sendAsync(J_N_H_HttpRequest var1, J_N_H_HttpResponse.BodyHandler<T> handler) {
        return this.sendAsync(var1, handler, null);
    }

    @Override
    public <T> CompletableFuture<J_N_H_HttpResponse<T>> sendAsync(J_N_H_HttpRequest var1, J_N_H_HttpResponse.BodyHandler<T> handler, J_N_H_HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.sendImpl(var1, handler, pushPromiseHandler);
            }
            catch (IOException | InterruptedException e) {
                Utils.sneakyThrow(e);
                return null;
            }
        }, this.executor == null ? ForkJoinPool.commonPool() : this.executor);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class SSLParamSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final SSLParameters sslParams;

        private SSLParamSocketFactory(SSLSocketFactory delegate, SSLParameters sslParams) {
            this.delegate = delegate;
            this.sslParams = sslParams;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket(s, host, port, autoClose);
            socket.setSSLParameters(this.sslParams);
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
            socket.setSSLParameters(this.sslParams);
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port, localHost, localPort);
            socket.setSSLParameters(this.sslParams);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
            socket.setSSLParameters(this.sslParams);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket socket = (SSLSocket)this.delegate.createSocket(address, port, localAddress, localPort);
            socket.setSSLParameters(this.sslParams);
            return socket;
        }
    }
}

