/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.impl;

import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CharReader {
    private final String buffer;
    private int pos;

    public CharReader(String buf, int pos) {
        this.buffer = buf.replace("\r\n", "\n");
        this.pos = pos;
    }

    public boolean exhausted() {
        return this.pos >= this.buffer.length();
    }

    public int peek() {
        if (this.pos >= this.buffer.length()) {
            return -1;
        }
        return this.buffer.charAt(this.pos);
    }

    public int take() {
        if (this.pos >= this.buffer.length()) {
            return -1;
        }
        return this.buffer.charAt(this.pos++);
    }

    public String takeUntil(char character) {
        StringBuilder sb = new StringBuilder();
        int next = this.peek();
        while (next != -1 && next != character) {
            sb.append((char)this.take());
            next = this.peek();
        }
        return sb.toString();
    }

    public String takeUntil(Set<Integer> c) {
        char ch;
        StringBuilder sb = new StringBuilder();
        while (this.pos < this.buffer.length() && !c.contains(ch = this.buffer.charAt(this.pos))) {
            sb.append(ch);
            ++this.pos;
        }
        return sb.toString();
    }

    public void takeWhitespace() {
        while (this.pos < this.buffer.length() && Character.isWhitespace(this.buffer.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public String takeString() {
        char c;
        this.expect('\"');
        StringBuilder sb = new StringBuilder();
        int escapes = 0;
        while (this.pos < this.buffer.length() && ((c = (char)this.take()) != '\"' || escapes != 0)) {
            escapes = c == '\\' ? ++escapes : 0;
            sb.append(c);
            if (escapes != 2) continue;
            escapes = 0;
        }
        return sb.toString();
    }

    public void expect(char c) {
        int next = this.take();
        if (next != c) {
            throw new IllegalArgumentException("Expected " + c + ", found " + next);
        }
    }
}

